/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSlice;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomes;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.LevelStem;

public class EnvironmentalBiomeSlices {
    public static final ResourceKey<ModdedBiomeSlice> MARSH_SLICE = EnvironmentalBiomeSlices.createKey("marsh");
    public static final ResourceKey<ModdedBiomeSlice> BLOSSOM_SLICE = EnvironmentalBiomeSlices.createKey("blossom");
    public static final ResourceKey<ModdedBiomeSlice> PINE_SLICE = EnvironmentalBiomeSlices.createKey("pine_barrens");
    public static final ResourceKey<Biome> MARSH_AREA = EnvironmentalBiomes.createKey("marsh_area");
    public static final ResourceKey<Biome> BLOSSOM_WOODS_AREA = EnvironmentalBiomes.createKey("blossom_woods_area");
    public static final ResourceKey<Biome> BLOSSOM_VALLEYS_AREA = EnvironmentalBiomes.createKey("blossom_valleys_area");
    public static final ResourceKey<Biome> PINE_BARRENS_AREA = EnvironmentalBiomes.createKey("pine_barrens_area");
    public static final ResourceKey<Biome> SNOWY_PINE_BARRENS_AREA = EnvironmentalBiomes.createKey("snowy_pine_barrens_area");
    public static final ResourceKey<Biome> OLD_GROWTH_PINE_BARRENS_AREA = EnvironmentalBiomes.createKey("old_growth_pine_barrens_area");
    public static final ResourceKey<Biome> SNOWY_OLD_GROWTH_PINE_BARRENS_AREA = EnvironmentalBiomes.createKey("snowy_old_growth_pine_barrens_area");
    public static final ResourceKey<Biome> PINE_SLOPES_AREA = EnvironmentalBiomes.createKey("pine_slopes_area");

    public static void bootstrap(BootstapContext<ModdedBiomeSlice> context) {
        ArrayList entries = new ArrayList();
        new EnvironmentalBiomeBuilder().addBiomes(entries::add);
        context.m_255272_(MARSH_SLICE, (Object)new ModdedBiomeSlice(25, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(MARSH_AREA, EnvironmentalBiomes.MARSH).build(), new ResourceKey[]{LevelStem.f_63971_}));
        context.m_255272_(BLOSSOM_SLICE, (Object)new ModdedBiomeSlice(25, (BiomeUtil.ModdedBiomeProvider)BiomeUtil.MultiNoiseModdedBiomeProvider.builder().biomes(entries::forEach).area(BLOSSOM_WOODS_AREA, EnvironmentalBiomes.BLOSSOM_WOODS).area(BLOSSOM_VALLEYS_AREA, EnvironmentalBiomes.BLOSSOM_VALLEYS).build(), new ResourceKey[]{LevelStem.f_63971_}));
    }

    public static ResourceKey<ModdedBiomeSlice> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)BlueprintDataPackRegistries.MODDED_BIOME_SLICES, (ResourceLocation)new ResourceLocation("environmental", name));
    }

    private static final class EnvironmentalBiomeBuilder {
        private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
        private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
        private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
        private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
        private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
        private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
        private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
        private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
        private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
        private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
        private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
        private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
        private final ResourceKey<Biome> VANILLA = BlueprintBiomes.ORIGINAL_SOURCE_MARKER;
        private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}};
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, BLOSSOM_WOODS_AREA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}};
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{null, null, null, SNOWY_OLD_GROWTH_PINE_BARRENS_AREA, null}, {null, null, null, null, OLD_GROWTH_PINE_BARRENS_AREA}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, BLOSSOM_WOODS_AREA, BLOSSOM_WOODS_AREA, BLOSSOM_WOODS_AREA}, {this.VANILLA, this.VANILLA, BLOSSOM_WOODS_AREA, BLOSSOM_WOODS_AREA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, BLOSSOM_VALLEYS_AREA, null}, {null, null, BLOSSOM_WOODS_AREA, BLOSSOM_VALLEYS_AREA, null}, {null, null, null, null, null}, {null, null, null, null, null}};
        private final ResourceKey<Biome>[][] SHATTERED_BIOMES = new ResourceKey[][]{{this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, BLOSSOM_WOODS_AREA, BLOSSOM_WOODS_AREA}, {null, null, null, null, null}, {null, null, null, null, null}};

        private EnvironmentalBiomeBuilder() {
        }

        private void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addOffCoastBiomes(consumer);
            this.addInlandBiomes(consumer);
            this.addUndergroundBiomes(consumer);
        }

        private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187196_) {
            this.addSurfaceBiome(p_187196_, this.FULL_RANGE, this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][i]);
                this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][i]);
            }
        }

        private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187216_) {
            this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
            this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
            this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
            this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
            this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
            this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
            this.addValleys(p_187216_, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
            this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
            this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
            this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
            this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
            this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
            this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
        }

        private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187178_, Climate.Parameter p_187179_) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187179_);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187179_);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, p_187179_);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187179_);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, p_187179_, resourcekey4);
                    ResourceKey<Biome> resourcekey6 = this.pickPeakBiome(i, j, p_187179_);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187179_, 0.0f, resourcekey6);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], p_187179_, 0.0f, resourcekey6);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187179_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187179_, 0.0f, resourcekey3);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey1);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey3);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187179_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], p_187179_, 0.0f, resourcekey5);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187179_, 0.0f, resourcekey4);
                    this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187179_, 0.0f, resourcekey);
                }
            }
        }

        private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187198_, Climate.Parameter p_187199_) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187199_);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187199_);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, p_187199_);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187199_);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, p_187199_, resourcekey);
                    ResourceKey<Biome> resourcekey7 = this.pickPeakBiome(i, j, p_187199_);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187199_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187199_, 0.0f, resourcekey7);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187199_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187199_, 0.0f, resourcekey3);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187199_, 0.0f, resourcekey1);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187199_, 0.0f, resourcekey3);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187199_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], p_187199_, 0.0f, resourcekey5);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187199_, 0.0f, resourcekey4);
                    this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187199_, 0.0f, resourcekey);
                }
            }
        }

        private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187218_, Climate.Parameter p_187219_) {
            this.addSurfaceBiome(p_187218_, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), p_187219_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187218_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187219_, 0.0f, MARSH_AREA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187219_);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187219_);
                    ResourceKey<Biome> resourcekey3 = this.pickShatteredBiome(i, j, p_187219_);
                    ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, p_187219_);
                    ResourceKey<Biome> resourcekey5 = this.pickBeachBiome(i, j);
                    ResourceKey<Biome> resourcekey6 = this.maybePickWindsweptSavannaBiome(i, j, p_187219_, resourcekey);
                    ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, p_187219_);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey1);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey4);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey1);
                    if (p_187219_.f_186814_() < 0L) {
                        this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[4], p_187219_, 0.0f, resourcekey5);
                        this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                    } else {
                        this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                    }
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187219_, 0.0f, resourcekey7);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], p_187219_, 0.0f, resourcekey6);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187219_, 0.0f, resourcekey3);
                    if (p_187219_.f_186814_() < 0L) {
                        this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey5);
                    } else {
                        this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey);
                    }
                    if (i != 0) continue;
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187219_, 0.0f, resourcekey);
                }
            }
        }

        private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187229_, Climate.Parameter p_187230_) {
            this.addSurfaceBiome(p_187229_, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), p_187230_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187229_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187230_, 0.0f, MARSH_AREA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187230_);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187230_);
                    ResourceKey<Biome> resourcekey3 = this.pickBeachBiome(i, j);
                    ResourceKey<Biome> resourcekey4 = this.maybePickWindsweptSavannaBiome(i, j, p_187230_, resourcekey);
                    ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, p_187230_);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187230_, 0.0f, resourcekey1);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey1);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), p_187230_, 0.0f, resourcekey3);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187230_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187230_, 0.0f, resourcekey5);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], p_187230_, 0.0f, resourcekey4);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187230_, 0.0f, resourcekey);
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187230_, 0.0f, resourcekey3);
                    if (i != 0) continue;
                    this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187230_, 0.0f, resourcekey);
                }
            }
        }

        private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187238_, Climate.Parameter p_187239_) {
            this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], p_187239_, 0.0f, this.VANILLA);
            this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187239_, 0.0f, MARSH_AREA);
            this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187239_, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187239_);
                    this.addSurfaceBiome(p_187238_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, resourcekey);
                }
            }
        }

        private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187227_) {
            this.addUndergroundBiome(p_187227_, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            this.addUndergroundBiome(p_187227_, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
        }

        private ResourceKey<Biome> pickMiddleBiome(int p_187164_, int p_187165_, Climate.Parameter weirdness) {
            ResourceKey<Biome> resourcekey;
            ResourceKey<Biome> middleBiome = weirdness.f_186814_() < 0L ? this.MIDDLE_BIOMES[p_187164_][p_187165_] : ((resourcekey = this.MIDDLE_BIOMES_VARIANT[p_187164_][p_187165_]) == null ? this.MIDDLE_BIOMES[p_187164_][p_187165_] : resourcekey);
            return middleBiome == null && ((float)weirdness.f_186813_() >= 4000.0f || (float)weirdness.f_186814_() <= -4000.0f) ? this.VANILLA : middleBiome;
        }

        private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int p_187192_, int p_187193_, Climate.Parameter p_187194_) {
            return p_187192_ == 4 ? this.pickBadlandsBiome(p_187193_, p_187194_) : this.pickMiddleBiome(p_187192_, p_187193_, p_187194_);
        }

        private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int p_201991_, int p_201992_, Climate.Parameter p_201993_, ResourceKey<Biome> p_201994_) {
            return p_201991_ > 1 && p_201992_ < 4 && p_201993_.f_186814_() >= 0L ? this.VANILLA : p_201994_;
        }

        private ResourceKey<Biome> pickShatteredCoastBiome(int p_187223_, int p_187224_, Climate.Parameter p_187225_) {
            ResourceKey<Biome> resourcekey = p_187225_.f_186814_() >= 0L ? this.pickMiddleBiome(p_187223_, p_187224_, p_187225_) : this.pickBeachBiome(p_187223_, p_187224_);
            return this.maybePickWindsweptSavannaBiome(p_187223_, p_187224_, p_187225_, resourcekey);
        }

        private ResourceKey<Biome> pickBeachBiome(int p_187161_, int p_187162_) {
            return this.VANILLA;
        }

        private ResourceKey<Biome> pickBadlandsBiome(int p_187173_, Climate.Parameter p_187174_) {
            return this.VANILLA;
        }

        private ResourceKey<Biome> pickPlateauBiome(int p_187234_, int p_187235_, Climate.Parameter p_187236_) {
            if (p_187236_.f_186814_() < 0L) {
                return this.PLATEAU_BIOMES[p_187234_][p_187235_];
            }
            ResourceKey<Biome> resourcekey = this.PLATEAU_BIOMES_VARIANT[p_187234_][p_187235_];
            return resourcekey == null ? this.PLATEAU_BIOMES[p_187234_][p_187235_] : resourcekey;
        }

        private ResourceKey<Biome> pickPeakBiome(int p_187241_, int p_187242_, Climate.Parameter p_187243_) {
            if (p_187241_ <= 2) {
                return this.VANILLA;
            }
            return p_187241_ == 3 ? this.VANILLA : this.pickBadlandsBiome(p_187242_, p_187243_);
        }

        private ResourceKey<Biome> pickShatteredBiome(int p_202002_, int p_202003_, Climate.Parameter p_202004_) {
            ResourceKey<Biome> resourcekey = this.SHATTERED_BIOMES[p_202002_][p_202003_];
            return resourcekey == null ? this.pickMiddleBiome(p_202002_, p_202003_, p_202004_) : resourcekey;
        }

        private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187181_, Climate.Parameter p_187182_, Climate.Parameter p_187183_, Climate.Parameter p_187184_, Climate.Parameter p_187185_, Climate.Parameter p_187186_, float p_187187_, ResourceKey<Biome> p_187188_) {
            p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
            p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
        }

        private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187201_, Climate.Parameter p_187202_, Climate.Parameter p_187203_, Climate.Parameter p_187204_, Climate.Parameter p_187205_, Climate.Parameter p_187206_, float p_187207_, ResourceKey<Biome> p_187208_) {
            p_187201_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187202_, (Climate.Parameter)p_187203_, (Climate.Parameter)p_187204_, (Climate.Parameter)p_187205_, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)p_187206_, (float)p_187207_), p_187208_));
        }
    }
}

