/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class WeepingWillowTreeFeature
extends BlueprintTreeFeature {
    public WeepingWillowTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        int branches = 2 + random.m_188503_(2);
        List<Integer> branchHeights = Arrays.asList(3, 4, 5);
        Collections.shuffle(branchHeights, new Random(random.m_188505_()));
        ArrayList branchDirections = new ArrayList(Direction.Plane.HORIZONTAL.m_122557_().toList());
        Collections.shuffle(branchDirections, new Random(random.m_188505_()));
        for (int i = 0; i < branches; ++i) {
            int branchHeight = branchHeights.get(i);
            Direction direction = (Direction)branchDirections.get(i);
            this.createBranch(origin.m_6630_(branchHeight), direction, random, config);
        }
        Direction direction = (Direction)branchDirections.get(random.m_188503_(branchDirections.size()));
        for (int i = 0; i < trunkHeight; ++i) {
            BlockPos logPos = i < trunkHeight - 5 ? origin.m_6630_(i) : origin.m_6630_(i).m_121945_(direction);
            this.addLog(logPos);
        }
        this.createTopLeafBlob(origin.m_6630_(trunkHeight).m_121945_(direction), random, direction);
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        int length = 3 + random.m_188503_(2);
        int offsetPos = 1 + random.m_188503_(length - 1);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int i = 0; i < length; ++i) {
            if (i == offsetPos) {
                mutablePos.m_122173_(Direction.UP);
            }
            mutablePos.m_122173_(direction);
            this.addSpecialLog((BlockPos)mutablePos, (BlockState)config.f_68185_.m_213972_(random, (BlockPos)mutablePos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
        }
        this.createBranchLeafBlob((BlockPos)mutablePos, random, direction, length <= 3);
    }

    private void createTopLeafBlob(BlockPos pos, RandomSource random, Direction direction) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = 0; y >= -3; --y) {
            int r = 2 - y / 2;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) == r && Math.abs(z) == r && (random.m_188503_(2) != 0 || y == 0)) continue;
                    mutablePos.m_122154_((Vec3i)pos, x, y, z);
                    this.addFoliage((BlockPos)mutablePos);
                }
            }
        }
        this.createLeafWall(pos.m_6625_(4), random, direction, 3, 2);
    }

    private void createBranchLeafBlob(BlockPos pos, RandomSource random, Direction direction, boolean small) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int radius = small ? 1 : 2;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1 && random.m_188503_(4) != 0) continue;
                mutablePos.m_122154_((Vec3i)pos, x, radius, z);
                this.addFoliage((BlockPos)mutablePos);
            }
        }
        for (int y = radius - 1; y >= 0; --y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    mutablePos.m_122154_((Vec3i)pos, x, y, z);
                    this.addFoliage((BlockPos)mutablePos);
                }
            }
        }
        this.createLeafWall(pos.m_7495_(), random, direction, radius, 3);
    }

    private void createLeafWall(BlockPos pos, RandomSource random, Direction direction, int width, int maxLength) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -width; x <= width; ++x) {
            for (int z = -width; z <= width; ++z) {
                if (!this.shouldPlaceLeafColumn(x, z, direction, width)) continue;
                boolean outerEdge = Math.abs(x) >= 2 && Math.abs(z) >= 2;
                int length = outerEdge ? random.m_188503_(2) : 1 + random.m_188503_(maxLength);
                for (int y = 0; y > -length; --y) {
                    mutablePos.m_122154_((Vec3i)pos, x, y, z);
                    this.addFoliage((BlockPos)mutablePos);
                }
            }
        }
    }

    private boolean shouldPlaceLeafColumn(int x, int z, Direction direction, int width) {
        Vec3i normal = direction.m_122436_();
        int edgex = normal.m_123341_() * width;
        int edgez = normal.m_123343_() * width;
        if (Math.abs(x) != width && Math.abs(z) != width) {
            return false;
        }
        if (width > 1 && Math.abs(x) == width && Math.abs(z) == width) {
            return false;
        }
        return (edgex == 0 || x != -edgex) && (edgez == 0 || z != -edgez);
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.WILLOW_SAPLING.get()).m_49966_();
    }
}

