/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;

public class TasselflowerPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public TasselflowerPatchFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState tasselflowerState = ((Block)EnvironmentalBlocks.TASSELFLOWER.get()).m_49966_();
        if (!(TasselflowerPatchFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_7495_()) && level.m_8055_(pos).m_247087_() && TasselflowerPatchFeature.isNearWater(level, pos))) {
            return false;
        }
        int flowers = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 128; ++i) {
            float offsetX = (random.m_188501_() - 0.5f) * 8.0f;
            float offsetZ = (random.m_188501_() - 0.5f) * 8.0f;
            int newX = pos.m_123341_() + Math.round(offsetX);
            int newZ = pos.m_123343_() + Math.round(offsetZ);
            mutablePos.m_122178_(newX, level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, newX, newZ), newZ);
            if (!level.m_46859_((BlockPos)mutablePos) || !tasselflowerState.m_60710_((LevelReader)level, (BlockPos)mutablePos) || TasselflowerPatchFeature.isNextToTasselflower(level, (BlockPos)mutablePos)) continue;
            level.m_7731_((BlockPos)mutablePos, tasselflowerState, 2);
            ++flowers;
        }
        return flowers > 0;
    }

    private static boolean isNextToTasselflower(WorldGenLevel level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!level.m_8055_(pos.m_121945_(direction)).m_60713_((Block)EnvironmentalBlocks.TASSELFLOWER.get())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearWater(WorldGenLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                checkPos.m_122178_(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
                FluidState fluidState = level.m_6425_((BlockPos)checkPos);
                if (!fluidState.m_205070_(FluidTags.f_13131_) || fluidState.m_76186_() != 8) continue;
                return true;
            }
        }
        return false;
    }
}

