/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.CupLichenBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CupLichenPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public CupLichenPatchFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int r = this.getRadius();
        int s = this.getYSpread();
        boolean place = false;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                double distance = Math.sqrt(x * x + z * z) / (double)r;
                if (!(distance <= 1.0)) continue;
                for (int y = -s; y <= s; ++y) {
                    int cups;
                    mutable.m_122154_((Vec3i)origin, x, 0, z);
                    if (!this.canGenerateAt(level, (BlockPos)mutable) || (cups = this.getCups(distance, random)) <= 0) continue;
                    level.m_7731_((BlockPos)mutable, (BlockState)((Block)EnvironmentalBlocks.CUP_LICHEN.get()).m_49966_().m_61124_((Property)CupLichenBlock.CUPS, (Comparable)Integer.valueOf(cups)), 2);
                    place = true;
                }
            }
        }
        return place;
    }

    protected int getRadius() {
        return 4;
    }

    protected int getYSpread() {
        return 0;
    }

    protected int getCups(double distance, RandomSource random) {
        int cups = distance < 0.2 ? 3 : (distance < 0.35 ? 2 : (distance < 0.5 ? 1 : 0));
        float f = random.m_188501_();
        if (f < 0.4f) {
            --cups;
        } else if (f < 0.8f) {
            ++cups;
        }
        return Mth.m_14045_((int)cups, (int)0, (int)4);
    }

    protected boolean canGenerateAt(WorldGenLevel level, BlockPos pos) {
        return level.m_46859_(pos) && ((Block)EnvironmentalBlocks.CUP_LICHEN.get()).m_49966_().m_60710_((LevelReader)level, pos);
    }
}

