/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item.explorer;

import com.teamabnormals.environmental.common.item.explorer.ExplorerArmor;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalTiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ExplorerArmorItem
extends DyeableArmorItem
implements ExplorerArmor {
    public ExplorerArmorItem(ArmorItem.Type slot, Item.Properties properties) {
        super((ArmorMaterial)EnvironmentalTiers.EnvironmentalArmorMaterials.EXPLORER, slot, properties);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ExplorerArmorItem.getCorrectTexture(ForgeRegistries.ITEMS.getKey((Object)this).m_135815_(), type);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        ItemStack stack;
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_ && (stack = (player = event.player).m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof ExplorerArmorItem && player instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            EnvironmentalCriteriaTriggers.UPGRADE_GEAR.trigger(serverplayerentity, stack);
        }
    }

    public static String getCorrectTexture(String armor, String type) {
        if ("overlay".equals(type)) {
            return "environmental:textures/models/armor/" + armor + "_overlay.png";
        }
        return "environmental:textures/models/armor/" + armor + ".png";
    }

    public int m_41121_(ItemStack stack) {
        if (!this.m_41113_(stack)) {
            return 7820095;
        }
        return super.m_41121_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41784_();
        int uses = this.getUses(nbt);
        int nextLevel = this.getLevelsUntilUpgrade(uses);
        MutableComponent counter = nextLevel != 0 ? Component.m_237113_((String)(uses + "/" + nextLevel)) : Component.m_237113_((String)String.valueOf(uses));
        counter.m_130940_(this.getFormattingForLevel(uses));
        MutableComponent description = Component.m_237113_((String)" ").m_7220_((Component)this.getDescription()).m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)counter.m_7220_((Component)description));
    }

    @Override
    public int getIncreaseForUses(int uses) {
        int increase = 0;
        for (int level : this.getLevelCaps()) {
            if (uses < level) continue;
            ++increase;
        }
        return increase;
    }

    public int getLevelsUntilUpgrade(int uses) {
        int increase;
        int[] levels = this.getLevelCaps();
        if (levels.length > (increase = this.getIncreaseForUses(uses))) {
            return levels[increase];
        }
        return 0;
    }

    public int getUses(CompoundTag nbt) {
        return nbt.m_128451_(this.getUsesTag());
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }

    public ChatFormatting getFormattingForLevel(int uses) {
        ChatFormatting[] formatting = new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.GREEN, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD};
        return formatting[this.getIncreaseForUses(uses) - 1];
    }

    public Rarity m_41460_(ItemStack stack) {
        boolean maxed;
        boolean bl = maxed = this.getIncreaseForUses(this.getUses(stack.m_41784_())) == 5;
        if (stack.m_41793_()) {
            if (maxed) {
                return Rarity.EPIC;
            }
            return Rarity.RARE;
        }
        if (maxed) {
            return Rarity.RARE;
        }
        return Rarity.COMMON;
    }
}

