/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.slabfish;

import com.teamabnormals.environmental.common.entity.ai.goal.slabfish.SlabbyBreedGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.slabfish.SlabbyFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.slabfish.SlabbyGrabItemGoal;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.common.inventory.SlabfishInventory;
import com.teamabnormals.environmental.common.inventory.SlabfishInventoryMenu;
import com.teamabnormals.environmental.common.network.message.SOpenSlabfishInventoryMessage;
import com.teamabnormals.environmental.common.slabfish.BackpackType;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.SweaterType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishBackpacks;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishSweaters;
import com.teamabnormals.environmental.core.registry.slabfish.EnvironmentalSlabfishTypes;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class Slabfish
extends TamableAnimal
implements ContainerListener,
Bucketable {
    private static final EntityDataAccessor<ResourceLocation> SLABFISH_TYPE = SynchedEntityData.m_135353_(Slabfish.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    private static final EntityDataAccessor<Integer> SLABFISH_OVERLAY = SynchedEntityData.m_135353_(Slabfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Slabfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ResourceLocation> BACKPACK = SynchedEntityData.m_135353_(Slabfish.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    private static final EntityDataAccessor<Boolean> HAS_BACKPACK = SynchedEntityData.m_135353_(Slabfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ResourceLocation> SWEATER = SynchedEntityData.m_135353_(Slabfish.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    public static final EntityDimensions SIZE_SWIMMING = EntityDimensions.m_20398_((float)0.7f, (float)0.6f);
    public static final EntityDimensions SIZE_SITTING = EntityDimensions.m_20398_((float)0.45f, (float)0.6f);
    public static final EntityDimensions SIZE_SWIMMING_CHILD = EntityDimensions.m_20398_((float)0.35f, (float)0.3f);
    public static final EntityDimensions SIZE_SITTING_CHILD = EntityDimensions.m_20398_((float)0.225f, (float)0.3f);
    public SlabfishInventory slabfishBackpack;
    public boolean backpackFull;
    public int playersUsing;
    private UUID lightningUUID;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public boolean isPartying = false;
    BlockPos jukeboxPosition;
    private boolean clearing;
    private LazyOptional<?> itemHandler = null;

    public Slabfish(EntityType<? extends Slabfish> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.slabfishBackpack = new SlabfishInventory(this);
        this.slabfishBackpack.addListener(this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.slabfishBackpack));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, entity -> entity.m_6095_().m_204039_(EntityTypeTags.f_13121_), 15.0f, 1.0, 1.25, EntitySelector.f_20406_::test));
        this.f_21345_.m_25352_(4, (Goal)new SlabbyBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SlabbyGrabItemGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(EnvironmentalItemTags.SLABFISH_FOOD), false));
        this.f_21345_.m_25352_(8, (Goal)new SlabbyFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SLABFISH_TYPE, (Object)EnvironmentalSlabfishTypes.SWAMP.m_135782_());
        this.m_20088_().m_135372_(SLABFISH_OVERLAY, (Object)0);
        this.m_20088_().m_135372_(FROM_BUCKET, (Object)false);
        this.m_20088_().m_135372_(BACKPACK, (Object)EnvironmentalSlabfishBackpacks.BROWN.m_135782_());
        this.m_20088_().m_135372_(HAS_BACKPACK, (Object)false);
        this.m_20088_().m_135372_(SWEATER, (Object)EnvironmentalSlabfishSweaters.EMPTY.m_135782_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("SlabfishType", this.getSlabfishTypeLocation().toString());
        compound.m_128405_("SlabfishOverlay", this.getSlabfishOverlay().getId());
        if (this.hasBackpack()) {
            compound.m_128359_("BackpackType", this.getBackpackLocation().toString());
        }
        compound.m_128379_("FromBucket", this.m_27487_());
        this.slabfishBackpack.write(compound);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSlabfishTypeFromLocation(compound.m_128441_("SlabfishType") ? new ResourceLocation(compound.m_128461_("SlabfishType")) : EnvironmentalSlabfishTypes.SWAMP.m_135782_());
        this.setSlabfishOverlay(SlabfishOverlay.byId(compound.m_128451_("SlabfishOverlay")));
        this.setBackpack(compound.m_128425_("BackpackType", 8) ? new ResourceLocation(compound.m_128461_("BackpackType")) : EnvironmentalSlabfishBackpacks.BROWN.m_135782_());
        this.m_27497_(compound.m_128471_("FromBucket"));
        this.slabfishBackpack.read(compound);
        this.updateSweater();
        this.updateBackpack();
        this.setHasBackpack(!this.slabfishBackpack.m_8020_(1).m_41619_() && this.slabfishBackpack.m_8020_(1).m_204117_(Tags.Items.CHESTS_WOODEN));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        SlabfishType slabfishType = this.getSlabfishType();
        if (item == Items.f_42447_ && this.m_6084_() && (!this.m_21824_() || player.m_36341_())) {
            if (this.hasBackpack()) {
                this.dropBackpack();
            }
            return (InteractionResult)Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).get();
        }
        if (stack.m_204117_(ItemTags.f_13159_)) {
            this.m_142075_(player, hand, stack);
            this.playBurpSound();
            this.particleCloud((ParticleOptions)ParticleTypes.f_123758_);
            this.dropItem((ItemLike)EnvironmentalItems.MUSIC_DISC_SLABRAVE.get());
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            Registry<BackpackType> backpacks = SlabfishHelper.slabfishBackpacks(this.m_9236_());
            if (this.hasBackpack() && slabfishType.isBackpackEmpty(this.m_9236_()) && SlabfishHelper.getBackpackType(backpacks, stack).isPresent() && !backpacks.m_7981_((Object)SlabfishHelper.getBackpackType(backpacks, stack).get()).equals((Object)this.getBackpackLocation())) {
                if (!this.m_9236_().m_5776_()) {
                    ItemStack previousBackpack = this.slabfishBackpack.m_8020_(2);
                    if (!previousBackpack.m_41619_()) {
                        Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)previousBackpack.m_41777_());
                        this.slabfishBackpack.m_8016_(2);
                    }
                    this.slabfishBackpack.m_6836_(2, new ItemStack((ItemLike)item));
                    this.m_142075_(player, hand, stack);
                }
                return InteractionResult.SUCCESS;
            }
            Registry<SweaterType> sweaters = SlabfishHelper.slabfishSweaters(this.m_9236_());
            if (!(!SlabfishHelper.getSweaterType(sweaters, stack).isPresent() || player.m_36341_() || this.hasSweater() && sweaters.m_7981_((Object)SlabfishHelper.getSweaterType(sweaters, stack).get()).equals((Object)this.getSweaterLocation()))) {
                if (!this.m_9236_().m_5776_()) {
                    ItemStack previousSweater = this.slabfishBackpack.m_8020_(0);
                    if (!previousSweater.m_41619_()) {
                        Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)previousSweater.m_41777_());
                        this.slabfishBackpack.m_8016_(0);
                    }
                    this.slabfishBackpack.m_6836_(0, new ItemStack((ItemLike)item));
                    this.m_142075_(player, hand, stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_204117_(Tags.Items.CHESTS_WOODEN) && !this.hasBackpack()) {
                if (!this.m_9236_().m_5776_()) {
                    this.slabfishBackpack.m_6836_(1, new ItemStack((ItemLike)item));
                    this.m_142075_(player, hand, stack);
                    if (player instanceof ServerPlayer) {
                        EnvironmentalCriteriaTriggers.BACKPACK_SLABFISH.trigger((ServerPlayer)player);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42574_ && this.hasSweater() && !player.m_36341_()) {
                ItemStack previousSweater = this.slabfishBackpack.m_8020_(0);
                if (!previousSweater.m_41619_()) {
                    Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)previousSweater.m_41777_());
                    this.slabfishBackpack.m_8016_(0);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_36341_() && stack.m_204117_(Tags.Items.SHEARS) && this.hasBackpack()) {
                this.dropBackpack();
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, stack);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)EnvironmentalSoundEvents.SLABFISH_EAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
                this.m_5634_(item.getFoodProperties(stack, (LivingEntity)player).m_38744_());
                this.particleCloud((ParticleOptions)ParticleTypes.f_123749_);
                return InteractionResult.SUCCESS;
            }
            if (Ingredient.m_204132_(EnvironmentalItemTags.SLABFISH_SNACKS).test(stack)) {
                stack.m_41671_(this.m_9236_(), (LivingEntity)this);
                this.m_142075_(player, hand, stack);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)EnvironmentalSoundEvents.SLABFISH_EAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(stack)) {
                int i = this.m_146764_();
                if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(player, hand, stack);
                    this.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6162_()) {
                    this.m_142075_(player, hand, stack);
                    this.m_146740_((int)((float)(-i / 20) * 0.1f), true);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.m_9236_().f_46443_) {
                    return InteractionResult.CONSUME;
                }
            }
            if (!this.m_21827_() && this.m_21830_((LivingEntity)player) && player.m_36341_() && !this.m_20069_()) {
                this.m_21816_(player.m_20148_());
                if (!this.m_9236_().m_5776_()) {
                    this.m_21839_(true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_21827_() && this.m_21830_((LivingEntity)player) && player.m_36341_()) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_21839_(false);
                }
                return InteractionResult.SUCCESS;
            }
            if (!player.m_36341_()) {
                if (!this.m_9236_().m_5776_()) {
                    this.openGui((ServerPlayer)player);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_204117_(EnvironmentalItemTags.SLABFISH_TAME_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6763_(BlockState state) {
        if (state.m_60734_() == Blocks.f_49990_ && this.getSlabfishOverlay() != SlabfishOverlay.NONE) {
            this.setSlabfishOverlay(SlabfishOverlay.NONE);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_123314_((Vec3i)this.m_20183_(), 3.46) || this.m_9236_().m_8055_(this.jukeboxPosition).m_60734_() != Blocks.f_50131_) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        if (this.m_20202_() != null && this.m_20202_().m_6144_()) {
            this.m_8127_();
        }
        if (this.m_20069_() && this.m_20202_() != null) {
            this.m_8127_();
        }
        if (this.isMoving() && this.m_21023_(MobEffects.f_19596_) && this.f_19796_.m_188503_(3) == 0 && !this.m_20069_()) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(0.5), this.m_20186_() + 0.2, this.m_20262_(0.5), d0, d1, d2);
        }
        if (this.f_19796_.m_188501_() < 0.1f && this.getSlabfishOverlay() == SlabfishOverlay.MUDDY) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.doParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)EnvironmentalItems.MUD_BALL.get())));
            }
        }
        List playerList = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(5.0, 5.0, 5.0));
        for (Player player : playerList) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_9236_().m_5776_()) continue;
            EnvironmentalCriteriaTriggers.SLABFISH.trigger(serverPlayer, this);
        }
        this.m_6210_();
        this.m_21553_(this.hasBackpack());
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.m_20096_() ? -1 : 4) * 0.3);
        this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.m_20096_()) {
            if (!this.m_20069_() && this.m_20184_().f_82480_ < 0.0) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            }
            if (this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    private boolean isMoving() {
        return this.m_20184_().m_7096_() > 0.0 || this.m_20184_().m_7098_() > 0.0 || this.m_20184_().m_7094_() > 0.0;
    }

    public double m_6049_() {
        if (this.m_20202_() != null) {
            if (this.m_20202_() instanceof Boat) {
                return this.m_6162_() ? 0.43 : 0.3;
            }
            return this.m_6162_() ? (double)0.7f : (double)0.52f;
        }
        return super.m_6049_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_20202_() != null) {
            this.m_8127_();
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.SLABFISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.SLABFISH_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.SLABFISH_STEP.get(), 0.15f, 1.0f);
    }

    protected void playBackpackSound() {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.SLABFISH_BACKPACK.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    protected void playSweaterSound() {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.SLABFISH_SWEATER.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    protected void playBurpSound() {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.SLABFISH_BURP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    private void doParticle(Level world, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double p_226397_10_, ParticleOptions p_226397_12_) {
        world.m_7106_(p_226397_12_, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)p_226397_2_, (double)p_226397_4_), p_226397_10_, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)p_226397_6_, (double)p_226397_8_), 0.0, 0.0, 0.0);
    }

    private void particleCloud(ParticleOptions particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particle, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void dropItem(ItemLike item) {
        ItemEntity itementity = this.m_20000_(item, 0);
        if (itementity != null) {
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public Slabfish getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        Slabfish baby = (Slabfish)((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).m_20615_((Level)world);
        UUID uuid = this.m_21805_();
        if (baby != null) {
            baby.setSlabfishType(this.getSlabfishType());
            if (uuid != null) {
                baby.m_21816_(uuid);
                baby.m_7105_(true);
            }
        }
        return baby;
    }

    public boolean m_6898_(ItemStack stack) {
        return !Ingredient.m_204132_(EnvironmentalItemTags.SLABFISH_TAME_ITEMS).test(stack) && Ingredient.m_204132_(EnvironmentalItemTags.SLABFISH_FOOD).test(stack);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_20069_() ? (this.m_6162_() ? SIZE_SWIMMING_CHILD : SIZE_SWIMMING) : (this.m_21825_() || this.m_20202_() != null ? (this.m_6162_() ? SIZE_SITTING_CHILD : SIZE_SITTING) : super.m_6972_(pose));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_21825_() ? sizeIn.f_20378_ * 0.6f : (this.m_20069_() ? (this.m_6162_() ? sizeIn.f_20378_ * 1.4f : sizeIn.f_20378_ * 0.855f) : sizeIn.f_20378_ * 0.8f);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public int m_5792_() {
        return 5;
    }

    protected float m_6108_() {
        return 0.96f;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (!this.m_9236_().m_5776_() && name != null && !this.getSlabfishTypeLocation().equals((Object)EnvironmentalSlabfishTypes.GHOST.m_135782_())) {
            super.m_6593_(name);
            Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes(this.m_9236_());
            SlabfishType currentType = this.getSlabfishType();
            SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.rename(this)).ifPresent(newType -> {
                if (!currentType.canBeSold(this.m_9236_()) && newType.canBeSold(this.m_9236_())) {
                    return;
                }
                if (registry.m_7981_(newType) != this.getSlabfishTypeLocation()) {
                    this.setSlabfishType((SlabfishType)newType);
                }
            });
        }
    }

    public void playTransformSound() {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.SLABFISH_TRANSFORM.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        this.particleCloud((ParticleOptions)ParticleTypes.f_123777_);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightningBolt) {
        UUID uuid = lightningBolt.m_20148_();
        if (!(world.m_5776_() || uuid.equals(this.lightningUUID) || this.getSlabfishTypeLocation().equals((Object)EnvironmentalSlabfishTypes.GHOST.m_135782_()))) {
            Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes((Level)world);
            SlabfishType currentType = this.getSlabfishType();
            SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.lightning(this)).ifPresent(newType -> {
                if (!currentType.canBeSold((Level)world) && newType.canBeSold((Level)world)) {
                    return;
                }
                this.setSlabfishType((SlabfishType)newType);
                this.lightningUUID = uuid;
                this.m_5496_(SoundEvents.f_12090_, 2.0f, 1.0f);
            });
        }
    }

    public SlabfishType getSlabfishType() {
        return (SlabfishType)SlabfishHelper.slabfishTypes(this.m_9236_()).m_7745_(this.getSlabfishTypeLocation());
    }

    public ResourceLocation getSlabfishTypeLocation() {
        return (ResourceLocation)this.f_19804_.m_135370_(SLABFISH_TYPE);
    }

    public void setSlabfishType(SlabfishType type) {
        this.setSlabfishTypeFromLocation(SlabfishHelper.slabfishTypes(this.m_9236_()).m_7981_((Object)type));
    }

    public void setSlabfishTypeFromLocation(ResourceLocation type) {
        this.f_19804_.m_135381_(SLABFISH_TYPE, (Object)type);
        this.updateBackpack();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET) {
            return spawnDataIn;
        }
        if (spawnDataIn instanceof SlabfishData) {
            this.setSlabfishType(((SlabfishData)spawnDataIn).type);
            return spawnDataIn;
        }
        Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes(this.m_9236_());
        SlabfishType type = SlabfishHelper.getSlabfishType(registry, SlabfishConditionContext.spawned(this)).get();
        spawnDataIn = new SlabfishData(type);
        this.setSlabfishType(type);
        return super.m_6518_(world, difficulty, reason, spawnDataIn, dataTag);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean value) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)value);
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128425_("SlabfishType", 8)) {
            if (tag.m_128441_("Age")) {
                this.m_146762_(tag.m_128451_("Age"));
            }
            if (tag.m_128441_("Owner")) {
                this.m_7105_(true);
                this.m_21816_(tag.m_128342_("Owner"));
            }
            this.setSlabfishTypeFromLocation(new ResourceLocation(tag.m_128461_("SlabfishType")));
            if (tag.m_128425_("BackpackType", 8)) {
                this.setBackpack(new ResourceLocation(tag.m_128461_("BackpackType")));
            }
            if (tag.m_128425_("SweaterType", 8)) {
                this.setBackpack(new ResourceLocation(tag.m_128461_("SweaterType")));
            }
            this.slabfishBackpack.read(tag);
            this.updateSweater();
            this.updateBackpack();
        } else {
            TagKey<SlabfishType> rarity = SlabfishType.getRandomRarity(this.m_9236_().m_213780_().m_188501_());
            Registry<SlabfishType> registry = SlabfishHelper.slabfishTypes(this.m_9236_());
            SlabfishType type = SlabfishHelper.getRandomSlabfishType(registry, s -> s.canBeSold(this.m_9236_()) && s.is(this.m_9236_(), rarity), this.m_9236_().m_213780_()).get();
            this.setSlabfishType(type);
        }
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag compound = bucket.m_41784_();
        compound.m_128350_("Health", this.m_21223_());
        compound.m_128405_("Age", this.m_146764_());
        if (this.m_21805_() != null && this.m_21824_()) {
            compound.m_128362_("Owner", this.m_21805_());
        }
        compound.m_128359_("SlabfishType", this.getSlabfishTypeLocation().toString());
        if (this.hasBackpack()) {
            compound.m_128359_("BackpackType", this.getBackpackLocation().toString());
        }
        if (this.hasSweater()) {
            compound.m_128359_("SweaterType", this.getSweaterLocation().toString());
        }
        this.slabfishBackpack.write(compound);
    }

    private void updateSweater() {
        if (!this.m_9236_().m_5776_()) {
            ItemStack sweaterStack = this.slabfishBackpack.m_8020_(0);
            Registry<SweaterType> sweaters = SlabfishHelper.slabfishSweaters(this.m_9236_());
            SweaterType sweaterType = SlabfishHelper.getSweaterType(sweaters, sweaterStack).orElse((SweaterType)sweaters.m_6246_(EnvironmentalSlabfishSweaters.EMPTY));
            if (!sweaterType.isEmpty()) {
                this.setSweater(sweaters.m_7981_((Object)sweaterType));
            } else {
                this.setSweater(EnvironmentalSlabfishSweaters.EMPTY.m_135782_());
            }
        }
    }

    private void updateBackpack() {
        if (!this.m_9236_().m_5776_()) {
            SlabfishType slabfishType = this.getSlabfishType();
            Optional<ResourceLocation> backpackType = slabfishType.backpack();
            Registry<BackpackType> registry = SlabfishHelper.slabfishBackpacks(this.m_9236_());
            if (!slabfishType.isBackpackEmpty(this.m_9236_())) {
                this.setBackpack(backpackType.get());
                if (!this.slabfishBackpack.m_8020_(2).m_41619_()) {
                    this.m_19983_(this.slabfishBackpack.m_8016_(2));
                }
            } else {
                ItemStack backpackColorStack = this.slabfishBackpack.m_8020_(2);
                this.setBackpack(registry.m_7981_((Object)SlabfishHelper.getBackpackType(registry, backpackColorStack).orElse((BackpackType)registry.m_6246_(EnvironmentalSlabfishBackpacks.BROWN))));
            }
        }
    }

    public boolean hasBackpack() {
        return (Boolean)this.m_20088_().m_135370_(HAS_BACKPACK);
    }

    public void setHasBackpack(boolean hasBackpack) {
        this.m_20088_().m_135381_(HAS_BACKPACK, (Object)hasBackpack);
    }

    public void setBackpack(ResourceLocation backpackType) {
        this.f_19804_.m_135381_(BACKPACK, (Object)backpackType);
    }

    public ResourceLocation getBackpackLocation() {
        return (ResourceLocation)this.f_19804_.m_135370_(BACKPACK);
    }

    public boolean hasSweater() {
        return !((ResourceLocation)this.f_19804_.m_135370_(SWEATER)).equals((Object)EnvironmentalSlabfishSweaters.EMPTY.m_135782_());
    }

    public void setSweater(ResourceLocation sweaterType) {
        this.f_19804_.m_135381_(SWEATER, (Object)sweaterType);
    }

    public ResourceLocation getSweaterLocation() {
        return (ResourceLocation)this.f_19804_.m_135370_(SWEATER);
    }

    public SweaterType getSweater() {
        return (SweaterType)SlabfishHelper.slabfishSweaters(this.m_9236_()).m_7745_(this.getSweaterLocation());
    }

    public SlabfishOverlay getSlabfishOverlay() {
        return SlabfishOverlay.byId((Integer)this.f_19804_.m_135370_(SLABFISH_OVERLAY));
    }

    public void setSlabfishOverlay(SlabfishOverlay typeId) {
        this.f_19804_.m_135381_(SLABFISH_OVERLAY, (Object)typeId.getId());
    }

    public void openGui(ServerPlayer player) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        player.m_9217_();
        Environmental.PLAY.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SOpenSlabfishInventoryMessage(this, player.f_8940_));
        player.f_36096_ = new SlabfishInventoryMenu(player.f_8940_, player.m_150109_(), this.slabfishBackpack, this);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    public boolean m_7252_(ItemStack stack) {
        return this.hasBackpack();
    }

    public boolean m_7066_(ItemStack stack) {
        return this.hasBackpack();
    }

    protected void m_5907_() {
        ItemStack itemstack = this.slabfishBackpack.m_8016_(0);
        if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            this.m_19983_(itemstack);
        }
        this.dropBackpack();
    }

    protected void dropBackpack() {
        super.m_5907_();
        if (this.hasBackpack() && this.slabfishBackpack != null) {
            for (int i = this.slabfishBackpack.m_6643_(); i > 0; --i) {
                ItemStack itemstack = this.slabfishBackpack.m_8016_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (itemEntity.m_19749_() == this) {
            return;
        }
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.hasBackpack()) {
            ItemStack stack = this.slabfishBackpack.addItem(itemstack, 3, this.slabfishBackpack.m_6643_());
            if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)stack)) {
                this.m_7938_((Entity)itemEntity, itemstack.m_41613_() - stack.m_41613_());
            }
            if (stack.m_41619_()) {
                itemEntity.m_146870_();
            } else {
                itemEntity.m_32045_(stack);
            }
        }
    }

    public void m_5757_(Container invBasic) {
        boolean hasBackpack;
        if (this.clearing) {
            return;
        }
        boolean hadSweater = this.hasSweater();
        boolean hadBackpack = this.hasBackpack();
        this.updateSweater();
        boolean bl = hasBackpack = !this.slabfishBackpack.m_8020_(1).m_41619_() && this.slabfishBackpack.m_8020_(1).m_204117_(Tags.Items.CHESTS_WOODEN);
        if (!hadSweater && this.hasSweater()) {
            this.playSweaterSound();
        }
        if (hadBackpack != hasBackpack) {
            this.playBackpackSound();
        }
        if (hadBackpack && !hasBackpack) {
            this.clearing = true;
            this.dropBackpack();
            this.clearing = false;
        }
        this.setHasBackpack(hasBackpack);
        this.updateBackpack();
        if (this.hasBackpack()) {
            this.backpackFull = true;
            for (int i = 3; i < this.slabfishBackpack.m_6643_(); ++i) {
                ItemStack stack = this.slabfishBackpack.m_8020_(i);
                if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
                this.backpackFull = false;
                break;
            }
        } else {
            this.backpackFull = false;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get());
    }

    public static class SlabfishData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final SlabfishType type;

        public SlabfishData(SlabfishType type) {
            super(true);
            this.type = type;
        }
    }
}

