/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.tapir;

import com.teamabnormals.environmental.common.entity.animal.Tapir;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TapirSniffForFloraGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(12.0).m_148355_();
    private final Tapir tapir;
    private final PathNavigation pathNav;
    private int walkWait;
    private int sniffTime;
    private int stopTime;
    private int outOfWaterTime;
    private int delayCounter;
    private BlockPos origin;
    private BlockPos foundPos;

    public TapirSniffForFloraGoal(Tapir tapir) {
        this.tapir = tapir;
        this.pathNav = tapir.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.tapir.getTrackingTime() > 0 && !this.tapir.hasFloraPos();
    }

    public boolean m_8045_() {
        return this.sniffTime > 0 || this.stopTime > 0;
    }

    public void m_8056_() {
        this.setWalkWait();
        this.sniffTime = this.m_183277_(300);
        this.stopTime = 0;
        this.outOfWaterTime = 0;
        this.delayCounter = 0;
        this.foundPos = null;
        this.origin = this.tapir.m_20183_();
        this.pathNav.m_26573_();
    }

    public void m_8041_() {
        if (this.sniffTime <= 0) {
            if (this.foundPos != null && this.stopTime == 0) {
                int time = (int)Math.sqrt(this.tapir.m_20238_(Vec3.m_82512_((Vec3i)this.foundPos))) * 12;
                this.tapir.setFloraPos(this.foundPos);
                this.tapir.setTrackingTime(Math.max(time, 200) + 100);
            } else {
                this.tapir.stopTracking();
            }
        }
        this.tapir.setSniffing(false);
        this.pathNav.m_26573_();
    }

    public void m_8037_() {
        if (this.stopTime > 0) {
            --this.stopTime;
            return;
        }
        if (this.tapir.m_20072_()) {
            this.tapir.setSniffing(false);
            this.outOfWaterTime = this.m_183277_(10);
            if (this.pathNav.m_26571_() && --this.delayCounter <= 0) {
                this.delayCounter = this.m_183277_(20);
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.tapir, (int)15, (int)7);
                if (vec3 != null && !this.tapir.m_9236_().m_8055_(BlockPos.m_274446_((Position)vec3)).m_60819_().m_205070_(FluidTags.f_13131_)) {
                    this.pathNav.m_26519_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 1.0);
                }
            }
            return;
        }
        this.tapir.setSniffing(true);
        if (--this.sniffTime <= 0) {
            for (int i = 0; i < 16; ++i) {
                BlockPos targetpos = this.findNearestFlora(i);
                if (targetpos == null) continue;
                this.findFlora(targetpos);
                return;
            }
            this.tapir.setSniffing(false);
            this.tapir.m_9236_().m_7605_((Entity)this.tapir, (byte)5);
            this.tapir.m_9236_().m_7605_((Entity)this.tapir, (byte)6);
            this.tapir.m_216990_((SoundEvent)EnvironmentalSoundEvents.TAPIR_REJECT.get());
            this.stopTime = this.m_183277_(20);
        } else if (--this.outOfWaterTime <= 0) {
            Vec3 vec3;
            BlockPos targetpos;
            if (this.sniffTime <= 129 && (targetpos = this.findNearestFlora(128 - this.sniffTime + 1)) != null) {
                this.findFlora(targetpos);
            }
            if (this.pathNav.m_26571_() && --this.walkWait <= 0 && (vec3 = LandRandomPos.m_148488_((PathfinderMob)this.tapir, (int)4, (int)2)) != null) {
                this.pathNav.m_26519_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0.6);
                this.setWalkWait();
            }
        }
    }

    private void findFlora(BlockPos targetPos) {
        BlockPos partnerpos = this.findNearestPartnersFlora();
        if (partnerpos != null) {
            targetPos = partnerpos;
        }
        this.foundPos = targetPos;
        this.tapir.m_9236_().m_7605_((Entity)this.tapir, (byte)4);
        this.sniffTime = 0;
        this.stopTime = this.m_183277_(20);
    }

    private void setWalkWait() {
        this.walkWait = this.m_183277_(10 + this.tapir.m_217043_().m_188503_(20));
    }

    private BlockPos findNearestFlora(int range) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        Item item = this.tapir.getFloraItem();
        for (int height = 0; height <= 12; ++height) {
            for (int i = 0; i < 2; ++i) {
                int y = i == 0 ? -height : height;
                int x = 0;
                while (x <= range) {
                    int z;
                    int n = z = x < range && x > -range ? range : 0;
                    while (z <= range) {
                        mutablepos.m_122154_((Vec3i)this.origin, x, y, z);
                        BlockState blockstate = this.tapir.m_9236_().m_8055_((BlockPos)mutablepos);
                        if (blockstate.m_60734_().m_7397_((BlockGetter)this.tapir.m_9236_(), (BlockPos)mutablepos, blockstate).m_150930_(item)) {
                            return mutablepos;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
        }
        return null;
    }

    private BlockPos findNearestPartnersFlora() {
        List list = this.tapir.m_9236_().m_45971_(Tapir.class, PARTNER_TARGETING, (LivingEntity)this.tapir, this.tapir.m_20191_().m_82400_(12.0));
        Tapir partner = null;
        double d0 = Double.MAX_VALUE;
        for (Tapir entity : list) {
            double d1 = this.tapir.m_20280_((Entity)entity);
            if (!entity.hasFloraPos() || entity.m_146764_() != 0 || this.tapir.getFloraItem() != entity.getFloraItem() || !(d1 < d0)) continue;
            d0 = d1;
            partner = entity;
        }
        if (partner != null) {
            return partner.getFloraPos();
        }
        return null;
    }
}

