/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DeerFrolicGoal
extends Goal {
    private final AbstractDeer deer;
    private int jumpCooldown;
    private int frolicCooldown;
    private boolean jumping = false;

    public DeerFrolicGoal(AbstractDeer deerIn) {
        this.deer = deerIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.deer.isSpreadingFlowers();
    }

    public boolean m_8045_() {
        return this.deer.isSpreadingFlowers() || !this.deer.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.resetJumpCooldown();
        this.frolicCooldown = 0;
    }

    public void m_8037_() {
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.jumping && this.deer.m_20096_()) {
            this.deer.spawnFlower();
            this.jumpCooldown = Math.max(this.m_183277_(2), this.jumpCooldown);
            this.jumping = false;
        } else if (this.deer.m_21573_().m_26571_()) {
            Vec3 vec3;
            if (this.frolicCooldown > 0) {
                --this.frolicCooldown;
            } else if (this.deer.isSpreadingFlowers() && (vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.deer, (int)15, (int)7)) != null) {
                this.deer.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.6);
                if (this.deer.m_217043_().m_188503_(8) == 0) {
                    this.frolicCooldown = this.m_183277_(20 + this.deer.m_217043_().m_188503_(20));
                }
            }
        } else if (this.jumpCooldown <= 0 && this.deer.m_20096_()) {
            Path path = this.deer.m_21573_().m_26570_();
            Vec3 vec3 = path.m_77380_((Entity)this.deer);
            Vec3 vec31 = vec3.m_82546_(this.deer.m_20182_());
            Vec3 vec32 = vec31.m_82541_();
            this.deer.m_9236_().m_7605_((Entity)this.deer, (byte)4);
            this.deer.m_6862_(true);
            this.deer.m_20256_(this.deer.m_20184_().m_82520_(vec32.f_82479_ * 0.32, 0.5, vec32.f_82481_ * 0.32));
            this.resetJumpCooldown();
            this.jumping = true;
        }
    }

    private void resetJumpCooldown() {
        this.jumpCooldown = this.m_183277_(16);
    }
}

