/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal;

import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class CatLeapAtDwarfSpruceGoal
extends Goal {
    private final Cat cat;
    private int nextStartTick;
    private int tryTicks;
    private int maxStayTicks;
    private BlockPos targetPos;
    private boolean leaping;

    public CatLeapAtDwarfSpruceGoal(Cat cat) {
        this.cat = cat;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = 200 + this.cat.m_217043_().m_188503_(200);
        if (!this.cat.m_21824_() || this.cat.m_21827_() || this.cat.m_28164_()) {
            return false;
        }
        this.targetPos = this.findNearestTorchPos();
        return this.targetPos != null;
    }

    public boolean m_8045_() {
        if (this.tryTicks < -this.maxStayTicks || this.tryTicks > 600) {
            return false;
        }
        return (!this.cat.m_20096_() && !this.cat.isInFluidType() || !this.leaping) && this.isTorchSpruce((LevelReader)this.cat.m_9236_(), this.targetPos);
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.cat.m_21837_(false);
        this.tryTicks = 0;
        this.maxStayTicks = this.cat.m_217043_().m_188503_(this.cat.m_217043_().m_188503_(1200) + 1200) + 1200;
        this.leaping = false;
    }

    public void m_8037_() {
        double d0 = (double)this.targetPos.m_123341_() + 0.5 - this.cat.m_20185_();
        double d1 = (double)this.targetPos.m_123342_() - this.cat.m_20186_();
        double d2 = (double)this.targetPos.m_123343_() + 0.5 - this.cat.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (this.leaping) {
            if (this.cat.m_20183_().equals((Object)this.targetPos)) {
                BlockState blockstate = this.cat.m_9236_().m_8055_(this.targetPos);
                DwarfSpruceBlock block = (DwarfSpruceBlock)blockstate.m_60734_();
                this.cat.m_9236_().m_46597_(this.targetPos, block.getWithoutTorchesState(blockstate));
                Block.m_49840_((Level)this.cat.m_9236_(), (BlockPos)this.targetPos, (ItemStack)new ItemStack((ItemLike)block.getTorch()));
            }
        } else {
            int patience = 1;
            if (d3 < 2.0 && this.cat.m_20096_()) {
                if (Math.abs(d1) <= 2.0) {
                    Vec3 vec3 = this.cat.m_20184_();
                    Vec3 vec31 = new Vec3((double)this.targetPos.m_123341_() + 0.5 - this.cat.m_20185_(), 0.0, (double)this.targetPos.m_123343_() + 0.5 - this.cat.m_20189_());
                    if (vec31.m_82556_() > 1.0E-7) {
                        vec31 = vec31.m_82541_().m_82490_(0.3).m_82549_(vec3.m_82490_(0.2));
                    }
                    double yd = Math.max((double)this.targetPos.m_123342_() + 0.5 - this.cat.m_20186_(), 0.8);
                    this.cat.m_20334_(vec31.f_82479_, Math.sqrt(2.0 * this.cat.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) * yd), vec31.f_82481_);
                    this.leaping = true;
                    return;
                }
                patience = 3;
            }
            this.cat.m_21563_().m_24946_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_() + 0.5, (double)this.targetPos.m_123343_() + 0.5);
            for (int i = 0; i < patience; ++i) {
                ++this.tryTicks;
                if (this.tryTicks % 40 != 0) continue;
                this.moveMobToBlock();
            }
        }
    }

    private void moveMobToBlock() {
        this.cat.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 0.6);
    }

    private boolean isTorchSpruce(LevelReader level, BlockPos pos) {
        DwarfSpruceBlock dwarfspruce;
        Block block = level.m_8055_(pos).m_60734_();
        return block instanceof DwarfSpruceBlock && (dwarfspruce = (DwarfSpruceBlock)block).getTorch() != null;
    }

    private boolean isSpruceBottom(LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        return block instanceof DwarfSprucePlantBlock && (Boolean)blockstate.m_61143_((Property)DwarfSprucePlantBlock.BOTTOM) != false || block instanceof DwarfSpruceHeadBlock && (Boolean)blockstate.m_61143_((Property)DwarfSpruceHeadBlock.TOP) == false;
    }

    private BlockPos findNearestTorchPos() {
        BlockPos blockpos = this.cat.m_20183_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= 1) {
            for (int r = 0; r < 6; ++r) {
                int x = 0;
                while (x <= r) {
                    int z;
                    int n = z = x < r && x > -r ? r : 0;
                    while (z <= r) {
                        mutable.m_122154_((Vec3i)blockpos, x, y, z);
                        if (this.isSpruceBottom((LevelReader)this.cat.m_9236_(), (BlockPos)mutable)) {
                            ArrayList<BlockPos> treepositions = new ArrayList<BlockPos>();
                            for (int i = 0; i <= 2; ++i) {
                                mutable.m_122154_((Vec3i)blockpos, x, y + i, z);
                                if (!this.isTorchSpruce((LevelReader)this.cat.m_9236_(), (BlockPos)mutable)) continue;
                                treepositions.add(mutable.m_7949_());
                            }
                            if (!treepositions.isEmpty()) {
                                return (BlockPos)treepositions.get(this.cat.m_217043_().m_188503_(treepositions.size()));
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return null;
    }
}

