/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.common.block.RedstoneDwarfSpruceBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;

public abstract class DwarfSpruceBlock
extends BushBlock
implements BonemealableBlock {
    protected final Supplier<Item> torch;

    public DwarfSpruceBlock(BlockBehaviour.Properties properties, Supplier<Item> torch) {
        super(properties);
        this.torch = torch;
        if (torch != null) {
            this.getTorchSpruces().put(torch, (Block)this);
        }
    }

    public abstract Item getTorch();

    public abstract BlockState getWithoutTorchesState(BlockState var1);

    abstract Map<Supplier<? extends Item>, Block> getTorchSpruces();

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowpos = pos.m_7495_();
        BlockState belowstate = level.m_8055_(belowpos);
        return belowstate.m_60734_() instanceof DwarfSpruceBlock || DwarfSpruceBlock.m_49863_((LevelReader)level, (BlockPos)belowpos, (Direction)Direction.UP) || belowstate.m_60734_() instanceof LeavesBlock;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block torchspruce;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Item torch = this.getTorch();
        if (itemstack.canPerformAction(ToolActions.SHEARS_HARVEST) && torch != null) {
            DwarfSpruceBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)torch));
            level.m_46597_(pos, this.getWithoutTorchesState(state));
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            level.m_5594_(null, pos, SoundEvents.f_12480_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (item != Items.f_41852_ && torch == null && (torchspruce = (Block)this.getTorchSpruces().getOrDefault(this.getTorchSpruces().keySet().stream().filter(key -> item == key.get()).findFirst().orElse(null), null)) != null) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            BlockState blockstate = torchspruce.m_152465_(state);
            if (item == Items.f_41978_) {
                blockstate = RedstoneDwarfSpruceBlock.setLitPoweredState(blockstate, level, pos);
            }
            level.m_46597_(pos, blockstate);
            level.m_5594_(null, pos, SoundEvents.f_144057_, SoundSource.BLOCKS, 0.4f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        Item torch = this.getTorch();
        if (torch != null) {
            drops.add(new ItemStack((ItemLike)torch));
        }
        return drops;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get());
    }

    protected static BlockPos getHeadPos(BlockGetter level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        do {
            mutable.m_122173_(Direction.UP);
            if (!(level.m_8055_((BlockPos)mutable).m_60734_() instanceof DwarfSpruceHeadBlock)) continue;
            return mutable.m_7949_();
        } while (level.m_8055_((BlockPos)mutable).m_60734_() instanceof DwarfSprucePlantBlock);
        return null;
    }

    protected static boolean isValidAboveBlock(BlockState state) {
        return state.m_60734_() instanceof DwarfSpruceHeadBlock && (Boolean)state.m_61143_((Property)DwarfSpruceHeadBlock.TOP) != false || state.m_60734_() instanceof DwarfSprucePlantBlock && (Boolean)state.m_61143_((Property)DwarfSprucePlantBlock.BOTTOM) == false;
    }
}

