/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.properties;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_sound_features.ESF;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class PlayingSoundProperty
extends StringArrayOrRegexProperty {
    private final boolean doPrint;

    protected PlayingSoundProperty(String values, boolean printing) throws RandomProperty.RandomPropertyException {
        super(values);
        this.doPrint = printing;
    }

    public static PlayingSoundProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            String val = RandomProperty.readPropertiesOrThrow((Properties)properties, (int)propertyNum, (String[])new String[]{"playingSound", "playingSounds"});
            boolean printing = val.startsWith("print:");
            return new PlayingSoundProperty(printing ? val.replaceFirst("print:", "") : val, printing);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    public boolean testEntityInternal(ETFEntity entity) {
        Set<String> sounds = PlayingSoundProperty.getPlayingSounds();
        if (this.doPrint) {
            if (sounds == null) {
                ESF.log("Sounds property print: No sounds found, this could also be from an error.");
            } else {
                ESF.log("Sounds property print: Sounds found -> " + String.valueOf(sounds));
            }
        }
        if (sounds == null) {
            return false;
        }
        for (String sound : sounds) {
            if (!this.MATCHER.testString(sound)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Set<String> getPlayingSounds() {
        SoundEngine engine = Minecraft.m_91087_().m_91106_().f_120349_;
        if (!engine.f_120219_) {
            return null;
        }
        ObjectOpenHashSet sounds = new ObjectOpenHashSet();
        for (Map.Entry entry : engine.f_120230_.entrySet()) {
            if ((Integer)entry.getValue() > engine.f_120225_) continue;
            sounds.add(((SoundInstance)entry.getKey()).m_7904_().toString().replaceFirst("minecraft:", ""));
        }
        for (SoundInstance soundInstance : engine.f_120226_.keySet()) {
            sounds.add(soundInstance.m_7904_().toString().replaceFirst("minecraft:", ""));
        }
        return sounds.isEmpty() ? null : sounds;
    }

    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"playingSound", "playingSounds"};
    }

    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Nullable
    protected String getValueFromEntity(ETFEntity etfEntity) {
        return null;
    }
}

