/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFVariantSupplier;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.EntityIntLRU;

public class ESFSoundContext {
    private static final List<ESFVariantSupplier> variantSuppliers = new ArrayList<ESFVariantSupplier>();
    private static final ObjectOpenHashSet<ResourceLocation> announcedSounds = new ObjectOpenHashSet();
    private static final ObjectOpenHashSet<ResourceLocation> knownESFSounds = new ObjectOpenHashSet();
    public static ETFEntity entitySource = null;
    public static final EntityIntLRU lastRuleMet = new EntityIntLRU();
    public static final EntityIntLRU lastSuffix = new EntityIntLRU();

    public static void addKnownESFSound(ResourceLocation sound) {
        knownESFSounds.add((Object)sound);
    }

    public static boolean shouldCaptureEntity(ResourceLocation sound) {
        if (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds.all()) {
            return true;
        }
        return knownESFSounds.contains((Object)sound);
    }

    public static void preTestEntity(ETFEntity entity) {
        for (ESFVariantSupplier variantSupplier : variantSuppliers) {
            variantSupplier.preTestEntity(entity);
        }
    }

    public static void announceSound(ResourceLocation sound, boolean wasESF) {
        if (entitySource == null || sound == null) {
            return;
        }
        switch (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds) {
            case ESF: {
                if (!wasESF) break;
                ESFSoundContext.announceWithEntity(sound, true);
                break;
            }
            case ALL: {
                ESFSoundContext.announceWithEntity(sound, wasESF);
                break;
            }
            case ALL_ONCE: {
                if (announcedSounds.contains((Object)sound)) break;
                ESFSoundContext.announceWithEntity(sound, wasESF);
                announcedSounds.add((Object)sound);
            }
        }
    }

    private static void announceWithEntity(ResourceLocation sound, boolean wasESF) {
        String pre = wasESF ? "Modifiable sound event with ESF properties: " + String.valueOf(sound) : "Modifiable sound event: " + String.valueOf(sound);
        ESF.log(pre + ", played by: " + String.valueOf(entitySource.etf$getType()));
        if (!wasESF) {
            ESF.log("This sound event can be modified by ESF with a properties file at: assets/" + sound.m_135827_() + "/esf/" + sound.m_135815_().replaceAll("\\.", "/") + ".properties");
        }
    }

    public static void resetContext() {
        ESF.log("Resetting sound context");
        variantSuppliers.clear();
        announcedSounds.clear();
        lastRuleMet.clear();
        lastSuffix.clear();
    }

    public static void searchForEntity(Iterable<Entity> entities, double x, double y, double z) {
        block0 : switch (((ESFConfig)ESF.config().getConfig()).entitySearchMode) {
            case EXACT: {
                for (Entity entity : entities) {
                    if (!entity.m_20191_().m_82393_(x, y, z)) continue;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) continue;
                    entitySource = etfEntity;
                    break block0;
                }
                break;
            }
            case BLOCK: {
                Vec3 start = new Vec3(x - 0.5, y - 0.5, z - 0.5);
                Vec3 end = new Vec3(x + 0.5, y + 0.5, z + 0.5);
                for (Entity entity : entities) {
                    if (!entity.m_20191_().m_82335_(start, end)) continue;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) continue;
                    entitySource = etfEntity;
                    break block0;
                }
                break;
            }
            case NEAREST: {
                double distance = Double.MAX_VALUE;
                ETFEntity nearest = null;
                for (Entity entity : entities) {
                    double d;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity) || !((d = entity.m_20275_(x, y, z)) < distance)) continue;
                    distance = d;
                    nearest = etfEntity;
                }
                entitySource = nearest;
                break;
            }
            case CLIENT: {
                entitySource = (ETFEntity)Minecraft.m_91087_().f_91074_;
            }
        }
    }

    public static void searchForBlockEntity(Level level, double x, double y, double z) {
        BlockEntity blockEntity;
        if (level == null || ((ESFConfig)ESF.config().getConfig()).entitySearchMode == ESFConfig.EntitySearchMode.CLIENT) {
            return;
        }
        BlockState state = level.m_8055_(new BlockPos((int)x, (int)y, (int)z));
        if (state.m_155947_() && (blockEntity = level.m_7702_(new BlockPos((int)x, (int)y, (int)z))) instanceof ETFEntity) {
            ETFEntity etfEntity = (ETFEntity)blockEntity;
            if (((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) {
                entitySource = etfEntity;
            }
        }
    }
}

