/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.registry;

import com.google.common.base.Function;
import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.client.particle.CorrockCrownParticle;
import com.teamabnormals.endergetic.client.particle.FastBlockParticle;
import com.teamabnormals.endergetic.client.particle.ParticleTypeWithData;
import com.teamabnormals.endergetic.client.particle.PoiseBubbleParticle;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EEParticleTypes {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"endergetic");
    public static final RegistryObject<SimpleParticleType> POISE_BUBBLE = EEParticleTypes.createBasicParticleType("poise_bubble", true);
    public static final RegistryObject<SimpleParticleType> SHORT_POISE_BUBBLE = EEParticleTypes.createBasicParticleType("short_poise_bubble", true);
    public static final RegistryObject<SimpleParticleType> ENDER_FLAME = EEParticleTypes.createBasicParticleType("ender_flame", true);
    public static final RegistryObject<ParticleType<BlockParticleOption>> FAST_BLOCK = EEParticleTypes.createParticleType("fast_block", BlockParticleOption.f_123624_, BlockParticleOption::m_123634_);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> OVERWORLD_CROWN = EEParticleTypes.createParticleType("overworld_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> NETHER_CROWN = EEParticleTypes.createParticleType("nether_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> END_CROWN = EEParticleTypes.createParticleType("end_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);

    private static RegistryObject<SimpleParticleType> createBasicParticleType(String name, boolean alwaysShow) {
        return PARTICLES.register(name, () -> new SimpleParticleType(alwaysShow));
    }

    private static <T extends ParticleOptions> RegistryObject<ParticleType<T>> createParticleType(String name, ParticleOptions.Deserializer<T> deserializer, Function<ParticleType<T>, Codec<T>> function) {
        return PARTICLES.register(name, () -> new ParticleTypeWithData(deserializer, function));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="endergetic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegisterParticleFactories {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ENDER_FLAME.get(), FlameParticle.Provider::new);
            event.registerSpriteSet((ParticleType)POISE_BUBBLE.get(), PoiseBubbleParticle.Factory::new);
            event.registerSpriteSet((ParticleType)SHORT_POISE_BUBBLE.get(), PoiseBubbleParticle.ShortFactory::new);
            event.registerSpecial((ParticleType)FAST_BLOCK.get(), (ParticleProvider)new FastBlockParticle.Factory());
            event.registerSpriteSet((ParticleType)OVERWORLD_CROWN.get(), CorrockCrownParticle.Factory::new);
            event.registerSpriteSet((ParticleType)NETHER_CROWN.get(), CorrockCrownParticle.Factory::new);
            event.registerSpriteSet((ParticleType)END_CROWN.get(), CorrockCrownParticle.Factory::new);
        }
    }
}

