/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.network;

import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.util.EntityMotionHelper;
import com.teamabnormals.endergetic.common.item.BoofloVestItem;
import com.teamabnormals.endergetic.core.other.tags.EEEntityTypeTags;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public final class C2SInflateBoofloVestMessage {
    private static final String POISE_BUBBLE_ID = "endergetic:short_poise_bubble";
    public static final float HORIZONTAL_BOOST_FORCE = 4.0f;
    public static final float VERTICAL_BOOST_FORCE = 0.75f;
    private static final int DEFAULT_DELAY = 7;
    private static final int DELAY_INCREASE_THRESHOLD = 5;
    private static final int DELAY_MULTIPLIER = 5;

    public static void serialize(C2SInflateBoofloVestMessage message, FriendlyByteBuf buffer) {
    }

    public static C2SInflateBoofloVestMessage deserialize(FriendlyByteBuf buffer) {
        return new C2SInflateBoofloVestMessage();
    }

    public static boolean handle(C2SInflateBoofloVestMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ItemStack stack;
                ServerPlayer player = context.getSender();
                if (player != null && !player.m_20096_() && !player.m_5833_() && (stack = (ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_() == EEItems.BOOFLO_VEST.get() && BoofloVestItem.canBoof(stack, (Player)player)) {
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128379_("boofed", true);
                    tag.m_128405_("ticksBoofed", 0);
                    int increment = tag.m_128451_("timesBoofed") + 1;
                    tag.m_128405_("timesBoofed", increment);
                    player.m_36335_().m_41524_((Item)EEItems.BOOFLO_VEST.get(), increment < 5 ? 7 : 5 * increment);
                    Entity ridingEntity = player.m_20202_();
                    for (Entity entity : player.m_9236_().m_6443_(Entity.class, player.m_20191_().m_82400_(2.0), arg_0 -> C2SInflateBoofloVestMessage.lambda$handle$0((Player)player, ridingEntity, arg_0))) {
                        EntityMotionHelper.knockbackEntity(entity, 4.0f, 0.75f, false, false);
                    }
                    if (ridingEntity != null) {
                        EntityMotionHelper.knockbackEntity(ridingEntity, 4.0f, 0.75f, true, false);
                    }
                    double posX = player.m_20185_();
                    double posY = player.m_20186_();
                    double posZ = player.m_20189_();
                    RandomSource rand = player.m_217043_();
                    for (int i = 0; i < 8; ++i) {
                        double x = posX + C2SInflateBoofloVestMessage.makeNegativeRandomly(rand.m_188501_() * 0.15f, rand);
                        double y = posY + (double)(rand.m_188501_() * 0.05f) + 1.25;
                        double z = posZ + C2SInflateBoofloVestMessage.makeNegativeRandomly(rand.m_188501_() * 0.15f, rand);
                        NetworkUtil.spawnParticle((String)POISE_BUBBLE_ID, (double)x, (double)y, (double)z, (double)(C2SInflateBoofloVestMessage.makeNegativeRandomly(rand.m_188501_() * 0.3f, rand) + (double)0.025f), (double)(rand.m_188501_() * 0.15f + 0.1f), (double)(C2SInflateBoofloVestMessage.makeNegativeRandomly(rand.m_188501_() * 0.3f, rand) + (double)0.025f));
                    }
                    player.m_9236_().m_6263_(null, posX, posY, posZ, (SoundEvent)EESoundEvents.BOOFLO_VEST_INFLATE.get(), SoundSource.PLAYERS, 1.0f, Mth.m_14036_((float)(1.3f - (float)increment * 0.15f), (float)0.25f, (float)1.0f));
                }
            });
            return true;
        }
        return false;
    }

    private static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.m_188499_() ? -value : value;
    }

    private static /* synthetic */ boolean lambda$handle$0(Player player, Entity ridingEntity, Entity entity) {
        return entity != player && entity != ridingEntity && !entity.m_6095_().m_204039_(EEEntityTypeTags.BOOF_BLOCK_RESISTANT);
    }
}

