/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockArchConfig;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class CorrockArchFeature
extends AbstractCorrockFeature<CorrockArchConfig> {
    public CorrockArchFeature(Codec<CorrockArchConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<CorrockArchConfig> context) {
        int originZ;
        int originY;
        int originX;
        BlockPos pos;
        WorldGenLevel world = context.m_159774_();
        Block below = world.m_8055_((pos = context.m_159777_()).m_7495_()).m_60734_();
        if ((below == CORROCK_BLOCK_BLOCK || below == EEBlocks.EUMUS.get()) && world.m_46859_(pos) && CorrockArchFeature.isGroundSolid(world, originX = pos.m_123341_(), (originY = pos.m_123342_()) - 1, originZ = pos.m_123343_())) {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            BlockPos end = null;
            CorrockArchConfig config = (CorrockArchConfig)context.m_159778_();
            float maxDistance = config.getMaxDistance();
            int maxDistanceInt = (int)maxDistance;
            float minDistance = config.getMinDistance();
            double distance = 0.0;
            RandomSource rand = context.m_225041_();
            for (int i = 0; i < 10; ++i) {
                int xPos = originX + rand.m_188503_(maxDistanceInt) - rand.m_188503_(maxDistanceInt);
                int zPos = originZ + rand.m_188503_(maxDistanceInt) - rand.m_188503_(maxDistanceInt);
                mutable.m_122178_(xPos, originY, zPos);
                mutable.m_142448_(world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, xPos, zPos));
                below = world.m_8055_(mutable.m_7495_()).m_60734_();
                if (below != CORROCK_BLOCK_BLOCK && below != EEBlocks.EUMUS.get() && below != Blocks.f_50259_ || !CorrockArchFeature.isGroundSolid(world, xPos, mutable.m_123342_() - 1, zPos) || !((distance = (double)Mth.m_14116_((float)((float)mutable.m_123331_((Vec3i)pos)))) >= (double)minDistance) || !(distance <= (double)maxDistance) || !CorrockArchFeature.isGroundSolid(world, xPos, mutable.m_123342_() - 1, zPos) || !world.m_46859_((BlockPos)mutable)) continue;
                end = mutable.m_7949_();
                break;
            }
            if (end != null) {
                HashSet<BlockPos> corrockBlockPositions = new HashSet<BlockPos>();
                ArchSpline archSpline = new ArchSpline(pos, end, rand, config.getMaxArchHeight());
                int steps = (int)(20.0 + distance * 4.0);
                BlockPos prevPos = null;
                int failedPositions = 0;
                int startY = pos.m_123342_();
                int endY = end.m_123342_();
                for (int i = 0; i < steps; ++i) {
                    float progress = (float)i / (float)steps;
                    BlockPos interpolatedPos = archSpline.interpolate(progress);
                    if (interpolatedPos.equals(prevPos)) continue;
                    prevPos = interpolatedPos;
                    int radius = 2;
                    double offsetRadius = (double)radius - (rand.m_188500_() - 0.5) * 0.25;
                    for (int y = -radius; y <= radius; ++y) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos placingPos = interpolatedPos.m_7918_(x, y, z);
                                if (!((double)Mth.m_14116_((float)((float)pos.m_123331_((Vec3i)placingPos))) <= 32.0) || !((double)(x * x + y * y + z * z) <= offsetRadius)) continue;
                                if (world.m_46859_(placingPos)) {
                                    corrockBlockPositions.add(placingPos);
                                    continue;
                                }
                                int placingPosY = placingPos.m_123342_();
                                if (placingPosY < endY || placingPosY < startY || failedPositions++ <= 6) continue;
                                return false;
                            }
                        }
                    }
                }
                BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
                BlockState corrockState = ((Block)EEBlocks.END_CORROCK.get()).m_49966_();
                float crownChance = config.getCrownChance();
                float plantChance = config.getPlantChance();
                corrockBlockPositions.forEach(corrockPos -> {
                    BlockPos up;
                    world.m_7731_(corrockPos, corrockBlockState, 2);
                    if (rand.m_188501_() < crownChance) {
                        BlockPos up2 = corrockPos.m_7494_();
                        if (!corrockBlockPositions.contains(up2) && world.m_46859_(up2)) {
                            world.m_7731_(up2, CorrockArchFeature.getCorrockCrownStanding(rand.m_188503_(16)), 2);
                        } else {
                            BlockPos down = corrockPos.m_7495_();
                            if (!corrockBlockPositions.contains(down) && world.m_46859_(down)) {
                                world.m_7731_(down, (BlockState)CorrockArchFeature.getCorrockCrownStanding(rand.m_188503_(16)).m_61124_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)), 2);
                            } else {
                                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                                    BlockPos offset = corrockPos.m_121945_(horizontal);
                                    if (corrockBlockPositions.contains(offset) || !world.m_46859_(offset)) continue;
                                    world.m_7731_(offset, CorrockArchFeature.getCorrockCrownWall(horizontal), 2);
                                }
                            }
                        }
                    } else if (rand.m_188501_() < plantChance && !corrockBlockPositions.contains(up = corrockPos.m_7494_()) && world.m_46859_(up)) {
                        world.m_7731_(up, corrockState, 2);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private static boolean isGroundSolid(WorldGenLevel world, int x, int y, int z) {
        return GenerationUtils.isAreaCompletelySolid((LevelAccessor)world, x - 2, y, z - 2, x + 2, y, z + 2);
    }

    static class ArchSpline {
        private static final Vec3 UP = new Vec3(0.0, 1.0, 1.0);
        private final Vec3[] points;

        private ArchSpline(BlockPos start, BlockPos end, RandomSource rand, float maxArchHeight) {
            ArrayList<Vec3> points = new ArrayList<Vec3>();
            Vec3 startVec = Vec3.m_82528_((Vec3i)start);
            Vec3 endVec = Vec3.m_82528_((Vec3i)end);
            Vec3 difference = endVec.m_82546_(startVec);
            Vec3 normalizedDifference = difference.m_82541_();
            Vec3 anchorStart = startVec.m_82546_(normalizedDifference).m_82520_(0.0, -6.0, 0.0);
            Vec3 anchorEnd = endVec.m_82549_(normalizedDifference).m_82520_(0.0, -6.0, 0.0);
            points.add(anchorStart);
            points.add(startVec);
            Vec3 offset = UP.m_82537_(normalizedDifference);
            double offsetX = offset.f_82479_;
            double offsetZ = offset.f_82481_;
            for (int i = 0; i < 5; ++i) {
                points.add(startVec.m_82549_(difference.m_82490_((double)((float)i / 5.0f))).m_82520_(offsetX * (rand.m_188500_() - 0.5) * 3.0, (rand.m_188500_() - 0.25) * 8.0 + (double)(Mth.m_14031_((float)((float)((double)((float)i / 5.0f) * Math.PI))) * maxArchHeight), offsetZ * (rand.m_188500_() - 0.5) * 3.0));
            }
            points.add(endVec);
            points.add(anchorEnd);
            this.points = points.toArray(new Vec3[0]);
        }

        private BlockPos interpolate(float progress) {
            Vec3[] points = this.points;
            float sections = points.length - 3;
            int currentPoint = (int)Math.min(Math.floor(progress * sections), (double)(sections - 1.0f));
            Vec3 point0 = points[currentPoint];
            Vec3 point1 = points[currentPoint + 1];
            float t0 = ArchSpline.computeT(point0, point1, 0.0f);
            Vec3 point2 = points[currentPoint + 2];
            Vec3 point3 = points[currentPoint + 3];
            float t1 = ArchSpline.computeT(point1, point2, t0);
            float t = t0 + (progress * sections - (float)currentPoint) * (t1 - t0);
            double A1multiplier1 = (t0 - t) / t0;
            double A1multiplier2 = t / t0;
            double A1x = ArchSpline.multiplyPoints(point0.f_82479_, point1.f_82479_, A1multiplier1, A1multiplier2);
            double A1y = ArchSpline.multiplyPoints(point0.f_82480_, point1.f_82480_, A1multiplier1, A1multiplier2);
            double A1z = ArchSpline.multiplyPoints(point0.f_82481_, point1.f_82481_, A1multiplier1, A1multiplier2);
            double A2Denominator = t1 - t0;
            double A2Multiplier1 = (double)(t1 - t) / A2Denominator;
            double A2Multiplier2 = (double)(t - t0) / A2Denominator;
            double A2x = ArchSpline.multiplyPoints(point1.f_82479_, point2.f_82479_, A2Multiplier1, A2Multiplier2);
            double A2y = ArchSpline.multiplyPoints(point1.f_82480_, point2.f_82480_, A2Multiplier1, A2Multiplier2);
            double A2z = ArchSpline.multiplyPoints(point1.f_82481_, point2.f_82481_, A2Multiplier1, A2Multiplier2);
            float t3 = ArchSpline.computeT(point2, point3, t1);
            double A3Denominator = t3 - t1;
            double A3Multiplier1 = (double)(t3 - t) / A3Denominator;
            double A3Multiplier2 = (double)(t - t1) / A3Denominator;
            double A3x = ArchSpline.multiplyPoints(point2.f_82479_, point3.f_82479_, A3Multiplier1, A3Multiplier2);
            double A3y = ArchSpline.multiplyPoints(point2.f_82480_, point3.f_82480_, A3Multiplier1, A3Multiplier2);
            double A3z = ArchSpline.multiplyPoints(point2.f_82481_, point3.f_82481_, A3Multiplier1, A3Multiplier2);
            double B1Multiplier1 = (t1 - t) / t1;
            double B1Multiplier2 = t / t1;
            double B1x = ArchSpline.multiplyPoints(A1x, A2x, B1Multiplier1, B1Multiplier2);
            double B1y = ArchSpline.multiplyPoints(A1y, A2y, B1Multiplier1, B1Multiplier2);
            double B1z = ArchSpline.multiplyPoints(A1z, A2z, B1Multiplier1, B1Multiplier2);
            double B2Denominator = t3 - t0;
            double B2Multiplier1 = (double)(t3 - t) / B2Denominator;
            double B2Multiplier2 = (double)(t - t0) / B2Denominator;
            double B2x = ArchSpline.multiplyPoints(A2x, A3x, B2Multiplier1, B2Multiplier2);
            double B2y = ArchSpline.multiplyPoints(A2y, A3y, B2Multiplier1, B2Multiplier2);
            double B2z = ArchSpline.multiplyPoints(A2z, A3z, B2Multiplier1, B2Multiplier2);
            double CDenominator = t1 - t0;
            double CMultiplier1 = (double)(t1 - t) / CDenominator;
            double CMultiplier2 = (double)(t - t0) / CDenominator;
            return BlockPos.m_274561_((double)ArchSpline.multiplyPoints(B1x, B2x, CMultiplier1, CMultiplier2), (double)ArchSpline.multiplyPoints(B1y, B2y, CMultiplier1, CMultiplier2), (double)ArchSpline.multiplyPoints(B1z, B2z, CMultiplier1, CMultiplier2));
        }

        private static double multiplyPoints(double point1, double point2, double multiplier1, double multiplier2) {
            return point1 * multiplier1 + point2 * multiplier2;
        }

        private static float computeT(Vec3 point1, Vec3 point2, float offset) {
            return Mth.m_14116_((float)((float)point2.m_82546_(point1).m_82553_())) + offset;
        }
    }
}

