/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.item;

import com.teamabnormals.blueprint.core.util.EntityUtil;
import com.teamabnormals.endergetic.common.entity.bolloom.BalloonColor;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomKnot;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import com.teamabnormals.endergetic.core.other.tags.EEEntityTypeTags;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class BolloomBalloonItem
extends Item {
    private final BalloonColor balloonColor;

    public BolloomBalloonItem(Item.Properties properties, BalloonColor balloonColor) {
        super(properties);
        this.balloonColor = balloonColor;
    }

    public BalloonColor getBalloonColor() {
        return this.balloonColor;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && BolloomBalloonItem.hasNoEntityTarget(player) && EntityUtil.rayTrace((Entity)player, (double)BolloomBalloonItem.getPlayerReach(player), (float)1.0f).m_6662_() == HitResult.Type.MISS && !player.m_6144_()) {
            Entity ridingEntity = player.m_20202_();
            boolean isRidingBoat = ridingEntity instanceof Boat;
            if (isRidingBoat && BolloomBalloonItem.canAttachBalloonToTarget(ridingEntity)) {
                BolloomBalloonItem.attachToEntity(this.balloonColor, ridingEntity);
                player.m_21011_(hand, true);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (!isRidingBoat && BolloomBalloonItem.canAttachBalloonToTarget((Entity)player)) {
                BolloomBalloonItem.attachToEntity(this.balloonColor, (Entity)player);
                player.m_21011_(hand, true);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof FenceBlock) {
            if (this.isAirUpwards(world, pos)) {
                ItemStack stack;
                if (!world.f_46443_ && this.attachToFence(pos, world, stack = context.m_43722_())) {
                    stack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.FAIL;
            }
            for (Entity entity : world.m_45976_(Entity.class, new AABB(pos))) {
                if (!(entity instanceof BolloomKnot) || !((BolloomKnot)entity).hasMaxBalloons()) continue;
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Level world = player.m_9236_();
        if (!world.f_46443_ && BolloomBalloonItem.canAttachBalloonToTarget((Entity)target)) {
            player.m_21011_(hand, true);
            BolloomBalloonItem.attachToEntity(this.balloonColor, (Entity)target);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAttachBalloonToTarget(Entity target) {
        return !target.m_6095_().m_204039_(EEEntityTypeTags.NOT_BALLOON_ATTACHABLE) && ((BalloonHolder)target).getBalloons().size() < (target instanceof Boat ? 4 : 6);
    }

    public static void attachToEntity(BalloonColor color, Entity target) {
        Level world = target.m_9236_();
        BolloomBalloon balloon = (BolloomBalloon)((EntityType)EEEntityTypes.BOLLOOM_BALLOON.get()).m_20615_(world);
        if (balloon != null) {
            balloon.setColor(color);
            balloon.attachToEntity(target);
            balloon.updateAttachedPosition();
            balloon.setUntied(true);
            world.m_7967_((Entity)balloon);
        }
    }

    private boolean attachToFence(BlockPos fencePos, Level world, ItemStack stack) {
        BolloomKnot setKnot = BolloomKnot.getKnotForPosition(world, fencePos);
        if (setKnot != null && !setKnot.hasMaxBalloons()) {
            setKnot.addBalloon(this.getBalloonColor());
            return true;
        }
        if (setKnot == null) {
            BolloomKnot.createStartingKnot(world, fencePos, this.getBalloonColor());
            return true;
        }
        return false;
    }

    private boolean isAirUpwards(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int i = 0; i < 4; ++i) {
            if (world.m_46859_((BlockPos)mutable.m_122184_(0, 1, 0))) continue;
            return false;
        }
        return true;
    }

    public static double getPlayerReach(Player player) {
        double reach = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()).m_22135_();
        return player.m_7500_() ? reach : reach - 0.5;
    }

    public static boolean hasNoEntityTarget(Player player) {
        double sqrDistance;
        Predicate<Entity> predicate;
        AABB axisalignedbb;
        Vec3 vec3d1;
        Vec3 vec3d2;
        double distance = BolloomBalloonItem.getPlayerReach(player);
        Vec3 vec3d = player.m_20299_(1.0f);
        EntityHitResult entityraytraceresult = BolloomBalloonItem.rayTraceEntities((Entity)player, vec3d, vec3d2 = vec3d.m_82549_(vec3d1 = player.m_20252_(1.0f).m_82490_(distance)), axisalignedbb = player.m_20191_().m_82369_(vec3d1).m_82400_(1.0), predicate = entity -> !entity.m_5833_() && entity.m_6087_(), sqrDistance = distance * distance);
        if (entityraytraceresult == null) {
            return true;
        }
        return vec3d.m_82557_(entityraytraceresult.m_82450_()) > sqrDistance;
    }

    private static EntityHitResult rayTraceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
        Level world = shooter.m_9236_();
        double d0 = distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.m_6249_(shooter, boundingBox, filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_());
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (axisalignedbb.m_82390_(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    public static class BalloonDispenseBehavior
    extends DefaultDispenseItemBehavior {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel world = source.m_7727_();
            BlockState state = world.m_8055_(blockpos);
            for (Entity entity : world.m_45976_(Entity.class, new AABB(blockpos))) {
                if (world.f_46443_ || !(entity instanceof LivingEntity) && !(entity instanceof Boat) || !BolloomBalloonItem.canAttachBalloonToTarget(entity)) continue;
                BolloomBalloonItem.attachToEntity(((BolloomBalloonItem)stack.m_41720_()).getBalloonColor(), entity);
                stack.m_41774_(1);
                return stack;
            }
            if (state.m_247087_()) {
                BolloomBalloon balloon = new BolloomBalloon((Level)world, blockpos);
                balloon.setColor(((BolloomBalloonItem)stack.m_41720_()).getBalloonColor());
                world.m_7967_((Entity)balloon);
                stack.m_41774_(1);
                return stack;
            } else {
                if (!state.m_247087_() && !state.m_204336_(BlockTags.f_13039_)) {
                    return super.m_7498_(source, stack);
                }
                if (!state.m_204336_(BlockTags.f_13039_)) return super.m_7498_(source, stack);
                BolloomKnot setKnot = BolloomKnot.getKnotForPosition((Level)world, blockpos);
                if (setKnot == null) {
                    BolloomKnot.createStartingKnot((Level)world, blockpos, ((BolloomBalloonItem)stack.m_41720_()).getBalloonColor());
                    stack.m_41774_(1);
                    return stack;
                }
                if (setKnot.hasMaxBalloons()) return super.m_7498_(source, stack);
                setKnot.addBalloon(((BolloomBalloonItem)stack.m_41720_()).getBalloonColor());
                stack.m_41774_(1);
            }
            return stack;
        }
    }
}

