/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidTeleportToFlowerGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class PurpoidRestGoal
extends Goal {
    private final Purpoid purpoid;
    private float startingHealth;
    private int duration;

    public PurpoidRestGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        if (purpoid.isResting() && !purpoid.getTeleportController().isTeleporting()) {
            if (PurpoidRestGoal.isAlignedAndNotBlocked(purpoid)) {
                return true;
            }
            purpoid.setRestingPos(null);
            purpoid.setRestingSide(Direction.DOWN);
        }
        return false;
    }

    public void m_8056_() {
        Purpoid purpoid = this.purpoid;
        purpoid.m_7910_(0.0f);
        purpoid.m_20256_(Vec3.f_82478_);
        purpoid.m_21573_().m_26573_();
        this.startingHealth = purpoid.m_21223_();
        this.duration = purpoid.m_217043_().m_188503_(1501) + 300;
    }

    public void m_8037_() {
        Purpoid purpoid = this.purpoid;
        purpoid.m_7910_(0.0f);
        purpoid.m_21573_().m_26573_();
        Direction side = purpoid.getRestingSide();
        if (purpoid.getRestOntoProgress() < 0.95f) {
            purpoid.m_20256_(purpoid.m_20184_().m_82492_((double)((float)side.m_122429_() * 0.01f), (double)((float)side.m_122430_() * 0.01f), (double)((float)side.m_122431_() * 0.01f)));
        } else {
            purpoid.m_20256_(purpoid.m_20184_().m_82542_((double)(0.5f - 0.5f * (float)Mth.m_14040_((int)side.m_122429_())), (double)(0.5f - 0.5f * (float)Mth.m_14040_((int)side.m_122430_())), (double)(0.5f - 0.5f * (float)Mth.m_14040_((int)side.m_122431_()))));
        }
    }

    public boolean m_8045_() {
        Purpoid purpoid = this.purpoid;
        return purpoid.m_21223_() >= this.startingHealth && --this.duration >= 0 && PurpoidRestGoal.isAlignedAndNotBlocked(purpoid);
    }

    public void m_8041_() {
        Purpoid purpoid = this.purpoid;
        purpoid.setRestingPos(null);
        purpoid.setRestingSide(Direction.DOWN);
        purpoid.resetRestCooldown();
    }

    private static boolean isAlignedAndNotBlocked(Purpoid purpoid) {
        BlockPos restingPos = purpoid.getRestingPos();
        if (restingPos != null) {
            Direction side = purpoid.getRestingSide();
            if (purpoid.m_9236_().m_8055_(restingPos).m_60734_() != (purpoid.m_6162_() ? Blocks.f_50490_ : Blocks.f_50491_) || !purpoid.m_9236_().m_8055_(restingPos.m_121945_(side)).m_60795_()) {
                return false;
            }
            Direction.Axis axis = side.m_122434_();
            Vec3 position = purpoid.m_20182_();
            double purpoidX = position.f_82479_;
            double purpoidY = position.f_82480_;
            double purpoidZ = position.f_82481_;
            double mainAxisPurpoidCoordinate = axis.m_6150_(purpoidX, purpoidY, purpoidZ);
            Vec3 centeredRestingPos = purpoid.m_6162_() ? new Vec3((double)((float)restingPos.m_123341_() + 0.5f), (double)((float)restingPos.m_123342_() + 0.25f), (double)((float)restingPos.m_123343_() + 0.5f)) : Vec3.m_82539_((Vec3i)restingPos);
            double centeredRestingPosX = centeredRestingPos.m_7096_();
            double centeredRestingPosY = centeredRestingPos.m_7098_();
            double centeredRestingPosZ = centeredRestingPos.m_7094_();
            double mainAxisRestingPosCoordinate = axis.m_6150_(centeredRestingPosX, centeredRestingPosY, centeredRestingPosZ);
            double sideDisplacementFromRestingPos = mainAxisPurpoidCoordinate - mainAxisRestingPosCoordinate;
            if (side.m_122421_() == Direction.AxisDirection.POSITIVE ? sideDisplacementFromRestingPos >= -0.0625 && sideDisplacementFromRestingPos <= 3.0625 : sideDisplacementFromRestingPos <= 0.0625 && sideDisplacementFromRestingPos >= -3.0625) {
                int mainAxisIndex = axis.ordinal();
                Direction.Axis nextAxis = Direction.Axis.f_122448_[(mainAxisIndex + 1) % 3];
                Direction.Axis precedingAxis = Direction.Axis.f_122448_[(mainAxisIndex + 2) % 3];
                double nextAxisPurpoidCoordinate = nextAxis.m_6150_(purpoidX, purpoidY, purpoidZ);
                double precedingAxisPurpoidCoordinate = precedingAxis.m_6150_(purpoidX, purpoidY, purpoidZ);
                double nextAxisRestingPosCoordinate = nextAxis.m_6150_(centeredRestingPosX, centeredRestingPosY, centeredRestingPosZ);
                double precedingAxisRestingPosCoordinate = precedingAxis.m_6150_(centeredRestingPosX, centeredRestingPosY, centeredRestingPosZ);
                double otherAxesDistanceFromRestingPosSqr = Mth.m_144952_((double)(nextAxisPurpoidCoordinate - nextAxisRestingPosCoordinate)) + Mth.m_144952_((double)(precedingAxisPurpoidCoordinate - precedingAxisRestingPosCoordinate));
                return otherAxesDistanceFromRestingPosSqr <= 0.0625 && (purpoid.getRestOntoProgress() >= 0.6f || PurpoidTeleportToFlowerGoal.isRestingPosNotBlocked(purpoid, position, restingPos, side));
            }
        }
        purpoid.setRestingPos(null);
        purpoid.setRestingSide(Direction.DOWN);
        return false;
    }

    public boolean m_183429_() {
        return true;
    }
}

