/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.entity.purpoid.PurpoidSize;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpFollowPurpoidsGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpTeleportToPlantGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpazoidSquirtPurpsGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidAttackGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidMoveNearTargetGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidMoveRandomGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidRandomTeleportGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidRestGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidStunnedGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidTelefragGoal;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidTeleportToFlowerGoal;
import com.teamabnormals.endergetic.core.other.EEDataSerializers;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Purpoid
extends PathfinderMob
implements Endimatable {
    private static final EntityDataAccessor<PurpoidSize> SIZE = SynchedEntityData.m_135353_(Purpoid.class, EEDataSerializers.PURPOID_SIZE);
    private static final EntityDataAccessor<Integer> BOOSTING_TICKS = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STUN_TIMER = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> APPLY_ROTATION_SNAPS = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> RESTING_POS = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Direction> RESTING_SIDE = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Integer> SHIELDED_MOMMY_ID = SynchedEntityData.m_135353_(Purpoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation PURP_LOOT_TABLE = new ResourceLocation("endergetic", "entities/purp");
    private static final ResourceLocation PURPAZOID_LOOT_TABLE = new ResourceLocation("endergetic", "entities/purpazoid");
    private final TeleportController teleportController = new TeleportController();
    private int growingAge;
    private int teleportCooldown;
    private int restCooldown;
    private int despawnTimer;
    private float restOntoProgressO;
    private float restOntoProgress;
    private boolean wantsToFlee;
    private Vec3 prevPull = Vec3.f_82478_;
    private Vec3 pull = Vec3.f_82478_;
    @Nullable
    public BlockPos forcedRelativeTeleportingPos;
    public final Set<UUID> revengeTargets = new HashSet<UUID>();
    private final ArrayList<UUID> shielders = new ArrayList(3);
    private PurpoidTelefragGoal telefragGoal;
    private PurpoidMoveNearTargetGoal moveNearTargetGoal;
    private PurpoidAttackGoal attackGoal;
    private PurpoidRestGoal restGoal;
    private PurpoidTeleportToFlowerGoal teleportToFlowerGoal;
    private PurpTeleportToPlantGoal teleportToPlantGoal;
    private PurpFollowPurpoidsGoal followPurpoidsGoal;
    private final PurpazoidSquirtPurpsGoal squirtPurpsGoal = new PurpazoidSquirtPurpsGoal(this);

    public Purpoid(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.resetTeleportCooldown();
        this.resetRestCooldown();
        this.f_21342_ = new PurpoidMoveController(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)PurpoidSize.NORMAL);
        this.f_19804_.m_135372_(BOOSTING_TICKS, (Object)0);
        this.f_19804_.m_135372_(STUN_TIMER, (Object)0);
        this.f_19804_.m_135372_(APPLY_ROTATION_SNAPS, (Object)true);
        this.f_19804_.m_135372_(RESTING_POS, Optional.empty());
        this.f_19804_.m_135372_(RESTING_SIDE, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(SHIELDED_MOMMY_ID, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PurpoidStunnedGoal(this));
        this.telefragGoal = new PurpoidTelefragGoal(this);
        this.f_21345_.m_25352_(1, (Goal)this.telefragGoal);
        this.moveNearTargetGoal = new PurpoidMoveNearTargetGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.moveNearTargetGoal);
        this.attackGoal = new PurpoidAttackGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.restGoal = new PurpoidRestGoal(this);
        this.f_21345_.m_25352_(3, (Goal)this.restGoal);
        this.teleportToFlowerGoal = new PurpoidTeleportToFlowerGoal(this);
        this.f_21345_.m_25352_(4, (Goal)this.teleportToFlowerGoal);
        this.teleportToPlantGoal = new PurpTeleportToPlantGoal(this);
        this.f_21345_.m_25352_(4, (Goal)this.teleportToPlantGoal);
        this.f_21345_.m_25352_(4, (Goal)new PurpoidRandomTeleportGoal(this));
        this.followPurpoidsGoal = new PurpFollowPurpoidsGoal(this);
        this.f_21345_.m_25352_(5, (Goal)this.followPurpoidsGoal);
        this.f_21345_.m_25352_(6, (Goal)new PurpoidMoveRandomGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.2f);
    }

    public void m_8119_() {
        Level level;
        block43: {
            RandomSource random;
            block44: {
                AABB searchBox;
                List nearbyRevengeTargets;
                int tickCount;
                block46: {
                    block47: {
                        block45: {
                            block42: {
                                this.f_19794_ = this.getSize() == PurpoidSize.NORMAL && this.restOntoProgress >= 0.6f;
                                super.m_8119_();
                                this.f_19794_ = false;
                                level = this.m_9236_();
                                if (!level.f_46443_) break block42;
                                this.restOntoProgressO = this.restOntoProgress;
                                this.prevPull = this.pull;
                                Vec3 pos = this.m_20182_();
                                this.pull = pos.m_82549_(this.pull.m_82546_(pos).m_82541_().m_82490_((double)0.1f));
                                if ((this.isBoosting() || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_SQUIRT_ATTACK) || this.getStunTimer() > 0) && level.m_46467_() % 4L == 0L) {
                                    double dy = this.pull.m_7098_() - pos.m_7098_();
                                    CorrockCrownParticleData particleData = this.createParticleData();
                                    random = this.m_217043_();
                                    for (int i = 0; i < 2; ++i) {
                                        level.m_7106_((ParticleOptions)particleData, this.m_20208_(0.5), this.m_20186_() + (double)this.m_20192_(), this.m_20262_(0.5), MathUtil.makeNegativeRandomly((double)(random.m_188500_() * (double)0.05f), (RandomSource)random), dy * random.m_188500_(), MathUtil.makeNegativeRandomly((double)(random.m_188500_() * (double)0.05f), (RandomSource)random));
                                    }
                                }
                                if (!this.m_21224_() && (this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_TO) || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO) || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_FROM) || this.m_20159_() || this.getStunTimer() > 0) && this.shouldApplyRotationSnaps()) {
                                    pos = pos.m_82492_(0.0, 1.0, 0.0);
                                    this.pull = pos.m_82549_(this.pull.m_82546_(pos).m_82541_().m_82490_((double)0.1f));
                                } else {
                                    Direction restingSide;
                                    float restOntoProgressO = this.restOntoProgressO;
                                    if (restOntoProgressO > 0.0f && (restingSide = this.getRestingSide()) != Direction.DOWN) {
                                        restOntoProgressO *= restOntoProgressO;
                                        pos = pos.m_82492_((double)(restOntoProgressO * (float)restingSide.m_122429_()), (double)(restOntoProgressO * (float)restingSide.m_122430_()), (double)(restOntoProgressO * (float)restingSide.m_122431_()));
                                        this.pull = pos.m_82549_(this.pull.m_82546_(pos).m_82541_().m_82490_((double)0.1f));
                                    }
                                }
                                int animationTick = this.getAnimationTick();
                                if ((this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_TO) || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO)) && animationTick == 7 || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_FROM) && animationTick == 4 || this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEFRAG) && animationTick == 2) {
                                    this.burstParticles();
                                }
                                break block43;
                            }
                            if (!this.m_6084_()) break block44;
                            if (this.getSize() == PurpoidSize.PURPAZOID) break block45;
                            int age = this.growingAge;
                            if (age < 0) {
                                this.updateAge(++age);
                            } else if (age > 0) {
                                this.updateAge(--age);
                            }
                            if (this.despawnTimer > 0 && --this.despawnTimer == 0) {
                                level.m_7605_((Entity)this, (byte)1);
                                this.m_146870_();
                                return;
                            }
                            break block44;
                        }
                        tickCount = this.f_19797_;
                        if (tickCount < 40) break block46;
                        Iterator<UUID> shieldersIterator = this.shielders.iterator();
                        int id = this.m_19879_();
                        double x = this.m_20185_();
                        double z = this.m_20189_();
                        while (shieldersIterator.hasNext()) {
                            Entity entity2 = ((ServerLevel)level).m_8791_(shieldersIterator.next());
                            if (entity2 instanceof Purpoid) {
                                boolean purpDoesNotShield;
                                Purpoid purpoid2 = (Purpoid)entity2;
                                int shieldedMommyID = purpoid2.getIDOfShieldedMommy();
                                boolean bl = purpDoesNotShield = shieldedMommyID < 0;
                                if ((purpDoesNotShield || shieldedMommyID == id) && purpoid2.m_6084_() && purpoid2.m_6162_() && Mth.m_144952_((double)(purpoid2.m_20185_() - x)) + Mth.m_144952_((double)(purpoid2.m_20189_() - z)) <= 4096.0) {
                                    if (!purpDoesNotShield) continue;
                                    purpoid2.setShieldedMommyId(id);
                                    continue;
                                }
                                purpoid2.setShieldedMommyId(-1);
                            }
                            shieldersIterator.remove();
                        }
                        int shieldedMommyID = this.getIDOfShieldedMommy();
                        if (shieldedMommyID < 0) break block46;
                        Entity shieldedMommy = level.m_6815_(shieldedMommyID);
                        if (!(shieldedMommy instanceof Purpoid)) break block47;
                        Purpoid mommy = (Purpoid)shieldedMommy;
                        if (mommy.shielders.contains(this.f_19820_)) break block46;
                    }
                    this.setShieldedMommyId(-1);
                }
                if (tickCount % 20 == 0 && !(nearbyRevengeTargets = level.m_6443_(LivingEntity.class, searchBox = this.m_20191_().m_82400_(32.0), entity -> TargetingConditions.f_26872_.m_26885_((LivingEntity)this, entity) && this.revengeTargets.contains(entity.m_20148_()))).isEmpty()) {
                    List nearbyPassivePurps = level.m_6443_(Purpoid.class, searchBox, purpoid -> {
                        if (!purpoid.m_6162_()) {
                            return false;
                        }
                        LivingEntity purpoidTarget = purpoid.m_5448_();
                        return (purpoidTarget == null || !purpoidTarget.m_6084_()) && !purpoid.isResting();
                    });
                    random = this.m_217043_();
                    for (Purpoid purpoid3 : nearbyPassivePurps) {
                        purpoid3.m_6710_((LivingEntity)nearbyRevengeTargets.get(random.m_188503_(nearbyRevengeTargets.size())));
                    }
                }
            }
            if (this.wantsToFlee && this.isNoEndimationPlaying() && !this.getTeleportController().isTeleporting()) {
                BlockPos pos = this.m_20183_();
                int purpoidBlockX = pos.m_123341_();
                int purpoidBlockZ = pos.m_123343_();
                int levelHeight = level.m_141928_();
                random = this.m_217043_();
                EntityDimensions size = this.m_6972_(this.m_20089_());
                ArrayList<BlockPos> possiblePositions = new ArrayList<BlockPos>();
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int relX = -16; relX <= 16; ++relX) {
                    int x = purpoidBlockX + relX;
                    double xMiddle = (double)x + 0.5;
                    block4: for (int relZ = -16; relZ <= 16; ++relZ) {
                        int z = purpoidBlockZ + relZ;
                        int heightAtXZ = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                        if (!Block.m_49936_((BlockGetter)level, (BlockPos)mutableBlockPos.m_122178_(x, heightAtXZ - 1, z))) continue;
                        double zMiddle = (double)z + 0.5;
                        int minColumnHeight = Math.min(heightAtXZ + 4, levelHeight);
                        for (int y = Math.min(minColumnHeight + 4 + random.m_188503_(9), levelHeight); y >= minColumnHeight; --y) {
                            if (!level.m_45772_(size.m_20384_(xMiddle, (double)y, zMiddle))) continue;
                            possiblePositions.add(new BlockPos(x, y, z));
                            continue block4;
                        }
                    }
                }
                if (!possiblePositions.isEmpty()) {
                    this.teleportController.beginTeleportation(this, (BlockPos)possiblePositions.get(random.m_188503_(possiblePositions.size())), false);
                    this.wantsToFlee = false;
                } else if (this.tryToTeleportRandomly(0, 24, 32)) {
                    this.wantsToFlee = false;
                }
            }
            if (this.hasTeleportCooldown()) {
                --this.teleportCooldown;
            }
            if (this.hasRestCooldown()) {
                --this.restCooldown;
            }
            if (this.isBoosting()) {
                this.setBoostingTicks(this.getBoostingTicks() - 1);
            } else if (!this.m_20159_() && this.hasTeleportCooldown() && !this.isResting() && this.f_19796_.m_188501_() <= 0.001f) {
                this.setBoostingTicks(this.f_19796_.m_188503_(81) + 80);
            }
            int stunTimer = this.getStunTimer();
            if (stunTimer > 0) {
                this.setStunTimer(stunTimer - 1);
            }
            this.teleportController.tick(this);
        }
        BlockPos restingPos = this.getRestingPos();
        if (restingPos != null && !this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_TO) && !this.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_FROM)) {
            Direction side = this.getRestingSide();
            Direction.Axis axis = side.m_122434_();
            double chosenTestingPos = axis.m_7863_(restingPos.m_123341_(), restingPos.m_123342_(), restingPos.m_123343_());
            if (side.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && side.m_122421_() == Direction.AxisDirection.POSITIVE) {
                chosenTestingPos += 1.0;
            }
            this.restOntoProgress = (float)(1.0 - Mth.m_14008_((double)(Math.abs(chosenTestingPos - axis.m_6150_(this.m_20185_(), this.m_20186_(), this.m_20189_())) / 3.0), (double)0.0, (double)1.0));
        } else {
            this.restOntoProgress = this.getStunTimer() > 0 ? Math.min(this.restOntoProgress + 0.025f, 1.0f) : Math.max(this.restOntoProgress - 0.025f, 0.0f);
        }
        if (this.m_21224_()) {
            if (!this.isEndimationPlaying(EEPlayableEndimations.PURPOID_DEATH) && !level.f_46443_) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PURPOID_DEATH);
            }
            if (++this.f_20919_ >= 20) {
                if (!level.f_46443_) {
                    this.m_146870_();
                } else {
                    int i;
                    CorrockCrownParticleData particleData = this.createParticleData();
                    RandomSource random = this.m_217043_();
                    for (i = 0; i < 12; ++i) {
                        level.m_7106_((ParticleOptions)particleData, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random), (double)((random.m_188501_() - random.m_188501_()) * 0.3f + 0.1f), MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random));
                    }
                    for (i = 0; i < 20; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                    }
                }
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        ArrayList<UUID> shielders;
        super.m_7380_(compound);
        compound.m_128405_("Size", this.getSize().ordinal());
        compound.m_128405_("Age", this.growingAge);
        compound.m_128405_("BoostingTicks", this.getBoostingTicks());
        compound.m_128405_("StunTimer", this.getStunTimer());
        compound.m_128405_("TeleportCooldown", this.teleportCooldown);
        compound.m_128405_("RestCooldown", this.restCooldown);
        compound.m_128405_("DespawnTimer", this.despawnTimer);
        Set<UUID> revengeTargets = this.revengeTargets;
        if (!revengeTargets.isEmpty()) {
            ListTag revengeTargetsTag = new ListTag();
            for (UUID uuid : revengeTargets) {
                revengeTargetsTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            compound.m_128365_("RevengeTargets", (Tag)revengeTargetsTag);
        }
        if (!(shielders = this.shielders).isEmpty()) {
            ListTag shieldersTag = new ListTag();
            for (UUID uuid : shielders) {
                shieldersTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            compound.m_128365_("Shielders", (Tag)shieldersTag);
        }
        if (this.isResting()) {
            compound.m_128365_("RestingPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getRestingPos()));
        }
        compound.m_128405_("RestingSide", this.getRestingSide().m_122411_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSize(PurpoidSize.values()[Mth.m_14045_((int)compound.m_128451_("Size"), (int)0, (int)2)], false);
        this.updateAge(compound.m_128451_("Age"));
        this.setBoostingTicks(Math.max(0, compound.m_128451_("BoostingTicks")));
        this.setStunTimer(Math.max(0, compound.m_128451_("StunTimer")));
        if (compound.m_128425_("TeleportCooldown", 3)) {
            this.teleportCooldown = Math.max(0, compound.m_128451_("TeleportCooldown"));
        }
        if (compound.m_128425_("RestCooldown", 3)) {
            this.restCooldown = Math.max(0, compound.m_128451_("RestCooldown"));
        }
        this.despawnTimer = Math.max(0, compound.m_128451_("DespawnTimer"));
        Set<UUID> revengeTargets = this.revengeTargets;
        for (Tag tag : compound.m_128437_("RevengeTargets", 11)) {
            revengeTargets.add(NbtUtils.m_129233_((Tag)tag));
        }
        ArrayList<UUID> shielders = this.shielders;
        for (Tag tag : compound.m_128437_("Shielders", 11)) {
            shielders.add(NbtUtils.m_129233_((Tag)tag));
        }
        if (compound.m_128425_("RestingPos", 10)) {
            this.setRestingPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("RestingPos")));
        }
        this.setRestingSide(Direction.m_122376_((int)compound.m_128451_("RestingSide")));
    }

    public void setSize(PurpoidSize size, boolean updateHealth) {
        this.f_19804_.m_135381_(SIZE, (Object)size);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(25.0f * size.getHealthMultiplier()));
        if (updateHealth) {
            this.m_21153_(this.m_21233_());
        }
        GoalSelector goalSelector = this.f_21345_;
        if (size == PurpoidSize.PURPAZOID) {
            goalSelector.m_25352_(0, (Goal)this.squirtPurpsGoal);
            goalSelector.m_25363_((Goal)this.moveNearTargetGoal);
            goalSelector.m_25363_((Goal)this.attackGoal);
            goalSelector.m_25363_((Goal)this.restGoal);
            goalSelector.m_25363_((Goal)this.teleportToFlowerGoal);
            goalSelector.m_25363_((Goal)this.teleportToPlantGoal);
            goalSelector.m_25363_((Goal)this.telefragGoal);
            goalSelector.m_25363_((Goal)this.followPurpoidsGoal);
        } else {
            if (size == PurpoidSize.NORMAL) {
                goalSelector.m_25352_(1, (Goal)this.telefragGoal);
                goalSelector.m_25352_(4, (Goal)this.teleportToFlowerGoal);
                goalSelector.m_25363_((Goal)this.teleportToPlantGoal);
                goalSelector.m_25363_((Goal)this.followPurpoidsGoal);
            } else {
                goalSelector.m_25352_(4, (Goal)this.teleportToPlantGoal);
                goalSelector.m_25352_(5, (Goal)this.followPurpoidsGoal);
                goalSelector.m_25363_((Goal)this.telefragGoal);
                goalSelector.m_25363_((Goal)this.teleportToFlowerGoal);
            }
            goalSelector.m_25352_(2, (Goal)this.moveNearTargetGoal);
            goalSelector.m_25352_(2, (Goal)this.attackGoal);
            goalSelector.m_25352_(3, (Goal)this.restGoal);
            goalSelector.m_25363_((Goal)this.squirtPurpsGoal);
        }
        this.f_21364_ = (int)(2.0f * size.getScale());
    }

    public PurpoidSize getSize() {
        return (PurpoidSize)((Object)this.f_19804_.m_135370_(SIZE));
    }

    public void setBoostingTicks(int boostingTicks) {
        this.f_19804_.m_135381_(BOOSTING_TICKS, (Object)boostingTicks);
    }

    public int getBoostingTicks() {
        return (Integer)this.f_19804_.m_135370_(BOOSTING_TICKS);
    }

    public void setStunTimer(int stunTimer) {
        this.f_19804_.m_135381_(STUN_TIMER, (Object)stunTimer);
    }

    public int getStunTimer() {
        return (Integer)this.f_19804_.m_135370_(STUN_TIMER);
    }

    public void setShouldApplyRotationSnaps(boolean shouldApplyRotationSnaps) {
        this.f_19804_.m_135381_(APPLY_ROTATION_SNAPS, (Object)shouldApplyRotationSnaps);
    }

    public boolean shouldApplyRotationSnaps() {
        return (Boolean)this.f_19804_.m_135370_(APPLY_ROTATION_SNAPS);
    }

    public void updateAge(int growingAge) {
        int prevAge = this.growingAge;
        this.growingAge = growingAge;
        if (prevAge < 0 && growingAge >= 0 || prevAge >= 0 && growingAge < 0) {
            this.setSize(growingAge < 0 ? PurpoidSize.PURP : PurpoidSize.NORMAL, true);
        }
    }

    public boolean isBoosting() {
        return this.getBoostingTicks() > 0;
    }

    public void resetTeleportCooldown() {
        this.teleportCooldown = this.m_217043_().m_188503_(2801) + 200;
    }

    public boolean hasTeleportCooldown() {
        return this.teleportCooldown > 0;
    }

    public void allowRest() {
        this.restCooldown = 0;
    }

    public void resetRestCooldown() {
        this.restCooldown = this.m_217043_().m_188503_(2001) + 600;
    }

    public boolean hasRestCooldown() {
        return this.restCooldown > 0;
    }

    public void randomizeDespawnTimer() {
        this.despawnTimer = 1000 + this.f_19796_.m_188503_(101);
    }

    public boolean wantsToFlee() {
        return this.wantsToFlee;
    }

    public float getRestOntoProgress() {
        return this.restOntoProgress;
    }

    public float getRestOntoAnimationProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.restOntoProgressO, (float)this.restOntoProgress);
    }

    public void updatePull(Vec3 pos) {
        this.prevPull = this.pull = pos.m_82492_(0.0, 1.0, 0.0);
    }

    public Vec3 getPull(float partialTicks) {
        return MathUtil.lerp((Vec3)this.prevPull, (Vec3)this.pull, (float)partialTicks);
    }

    @Nullable
    public Purpoid getLeader() {
        return this.followPurpoidsGoal.leader;
    }

    public TeleportController getTeleportController() {
        return this.teleportController;
    }

    public void setRestingPos(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(RESTING_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public BlockPos getRestingPos() {
        return ((Optional)this.f_19804_.m_135370_(RESTING_POS)).orElse(null);
    }

    public boolean isResting() {
        return this.getRestingPos() != null;
    }

    public void setRestingSide(Direction side) {
        this.f_19804_.m_135381_(RESTING_SIDE, (Object)side);
    }

    public Direction getRestingSide() {
        return (Direction)this.f_19804_.m_135370_(RESTING_SIDE);
    }

    public void setShieldedMommyId(int id) {
        this.f_19804_.m_135381_(SHIELDED_MOMMY_ID, (Object)id);
    }

    public int getIDOfShieldedMommy() {
        return (Integer)this.f_19804_.m_135370_(SHIELDED_MOMMY_ID);
    }

    public void addShielder(Purpoid shielder) {
        this.shielders.add(shielder.f_19820_);
        shielder.setShieldedMommyId(this.m_19879_());
    }

    public boolean needsMoreShielders() {
        return this.shielders.size() < 3;
    }

    public boolean m_6162_() {
        return this.getSize() == PurpoidSize.PURP;
    }

    public float m_6134_() {
        return this.getSize().getScale();
    }

    private CorrockCrownParticleData createParticleData() {
        return new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), false, 0.2f * this.getSize().getScale());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
        }
        RandomSource random = this.f_19796_;
        if (spawnData instanceof AgeableMob.AgeableMobGroupData) {
            AgeableMob.AgeableMobGroupData ageableData = (AgeableMob.AgeableMobGroupData)spawnData;
            if (ageableData.m_146779_() && ageableData.m_146777_() > 0 && random.m_188501_() <= ageableData.m_146780_()) {
                this.updateAge(-24000);
            } else if (random.m_188501_() <= 0.005f) {
                this.setSize(PurpoidSize.PURPAZOID, true);
            }
            ageableData.m_146778_();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnData, dataTag);
    }

    public void m_267651_(boolean p_233629_2_) {
        super.m_267651_(true);
    }

    public double m_6049_() {
        Entity ridingEntity = this.m_20202_();
        if (ridingEntity != null) {
            return ridingEntity.m_20191_().f_82292_ - (ridingEntity.m_20186_() + ridingEntity.m_6048_());
        }
        return super.m_6049_();
    }

    public boolean m_7998_(Entity entity, boolean force) {
        boolean riding = super.m_7998_(entity, force);
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(entity));
        }
        return riding;
    }

    public void m_8127_() {
        Entity entity = this.m_20202_();
        super.m_8127_();
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(entity));
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21205_().m_41619_() && !this.m_20159_() && this.getSize() == PurpoidSize.NORMAL && this.m_6084_()) {
            this.m_20329_((Entity)player);
            this.m_6710_((LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            Entity ridingEntity = this.m_20202_();
            if (ridingEntity != null && source.m_7639_() == ridingEntity) {
                this.m_8127_();
                return super.m_6469_(source, amount);
            }
            if (this.getSize() == PurpoidSize.PURPAZOID) {
                Entity entity;
                UUID randomShielderUUID;
                this.wantsToFlee = true;
                this.setStunTimer(0);
                if (source.m_269014_() && this.isNoEndimationPlaying() && !this.getTeleportController().isTeleporting() && this.tryToTeleportRandomly(2, 16, 12)) {
                    this.wantsToFlee = false;
                    return true;
                }
                ArrayList<UUID> shielders = this.shielders;
                if (!shielders.isEmpty() && !source.m_269533_(DamageTypeTags.f_268738_) && (randomShielderUUID = shielders.get(this.f_19796_.m_188503_(shielders.size()))) != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(randomShielderUUID)) instanceof Purpoid) {
                    Purpoid shielder = (Purpoid)entity;
                    shielder.m_6469_(source, amount);
                    return false;
                }
                return super.m_6469_(source, amount);
            }
            if (this.isNoEndimationPlaying() && !this.getTeleportController().isTeleporting()) {
                if (source.m_269014_()) {
                    if (this.tryToTeleportRandomly(2, 16, 12)) {
                        return true;
                    }
                } else if (!(source.m_7639_() instanceof LivingEntity)) {
                    this.tryToTeleportRandomly(2, 16, 4);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.revengeTargets.add(target.m_20148_());
        }
    }

    public PathNavigation m_6037_(Level world) {
        return new EndergeticFlyingPathNavigator((Mob)this, world);
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.burstParticles();
            Level level = this.m_9236_();
            RandomSource random = this.f_19796_;
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), random.m_188583_() * 0.02, random.m_188583_() * 0.02, random.m_188583_() * 0.02);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_6153_() {
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected boolean m_6125_() {
        return true;
    }

    protected ResourceLocation m_7582_() {
        switch (this.getSize()) {
            default: {
                return super.m_7582_();
            }
            case PURP: {
                return PURP_LOOT_TABLE;
            }
            case PURPAZOID: 
        }
        return PURPAZOID_LOOT_TABLE;
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        if (endimation == EEPlayableEndimations.PURPOID_DEATH) {
            this.f_20919_ = 0;
        }
    }

    public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
        if (!(this.m_9236_().f_46443_ || newEndimation == EEPlayableEndimations.PURPOID_TELEPORT_FROM || endimation != EEPlayableEndimations.PURPOID_TELEPORT_TO && endimation != EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO)) {
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.PURPOID_TELEPORT_FROM);
        }
    }

    private void burstParticles() {
        CorrockCrownParticleData particleData = this.createParticleData();
        Level level = this.m_9236_();
        RandomSource random = this.m_217043_();
        for (int i = 0; i < 12; ++i) {
            level.m_7106_((ParticleOptions)particleData, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random), (double)((random.m_188501_() - random.m_188501_()) * 0.3f + 0.1f), MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random));
        }
    }

    private boolean tryToTeleportRandomly(int minDistance, int maxDistance, int attempts) {
        BlockPos pos = this.m_20183_();
        RandomSource random = this.m_217043_();
        EntityDimensions size = this.m_6972_(this.m_20089_());
        Level world = this.m_9236_();
        int upperBound = maxDistance - minDistance + 1;
        for (int i = 0; i < attempts; ++i) {
            BlockPos randomPos = pos.m_7918_((int)MathUtil.makeNegativeRandomly((double)(minDistance + random.m_188503_(upperBound)), (RandomSource)random), (int)MathUtil.makeNegativeRandomly((double)(minDistance + random.m_188503_(upperBound)), (RandomSource)random), (int)MathUtil.makeNegativeRandomly((double)(minDistance + random.m_188503_(upperBound)), (RandomSource)random));
            AABB collisionBox = size.m_20384_((double)((float)randomPos.m_123341_() + 0.5f), (double)randomPos.m_123342_(), (double)((float)randomPos.m_123343_() + 0.5f));
            if (!world.m_45772_(collisionBox) || world.m_46855_(collisionBox)) continue;
            this.teleportController.beginTeleportation(this, randomPos, true);
            return true;
        }
        return false;
    }

    public static class TeleportController {
        @Nullable
        private Vec3 destination;

        private void tick(Purpoid purpoid) {
            if ((purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_TO) || purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO)) && purpoid.getAnimationTick() == 10) {
                this.teleportToDestination(purpoid);
            } else if (purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_FROM)) {
                purpoid.m_20256_(Vec3.f_82478_);
            }
        }

        private void teleportToDestination(Purpoid purpoid) {
            Vec3 destination = this.destination;
            if (destination != null) {
                Entity ridingEntity = purpoid.m_20202_();
                if (ridingEntity != null) {
                    ridingEntity.m_20324_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
                } else {
                    NetworkUtil.teleportEntity((Entity)purpoid, (double)destination.f_82479_, (double)destination.f_82480_, (double)destination.f_82481_);
                }
                this.destination = null;
            }
        }

        public void beginTeleportation(Purpoid purpoid, Vec3 destination, boolean fast) {
            NetworkUtil.setPlayingAnimation((Entity)purpoid, (PlayableEndimation)(fast ? EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO : EEPlayableEndimations.PURPOID_TELEPORT_TO));
            this.destination = destination;
        }

        public void beginTeleportation(Purpoid purpoid, BlockPos destination, boolean fast) {
            this.beginTeleportation(purpoid, new Vec3((double)destination.m_123341_() + 0.5, purpoid.m_6162_() ? (double)((float)destination.m_123342_() + 0.25f) : (double)destination.m_123342_(), (double)destination.m_123343_() + 0.5), fast);
        }

        public boolean isTeleporting() {
            return this.destination != null;
        }
    }

    static class PurpoidMoveController
    extends MoveControl {
        private Vec3 prevPos;
        private int stuckTicks;

        public PurpoidMoveController(Purpoid mob) {
            super((Mob)mob);
            this.prevPos = mob.m_20182_();
        }

        public void m_6849_(double x, double y, double z, double speedIn) {
            super.m_6849_(x, y, z, speedIn);
            this.stuckTicks = 0;
        }

        public void m_8126_() {
            Purpoid purpoid = (Purpoid)this.f_24974_;
            boolean boosting = purpoid.isBoosting();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 pos = purpoid.m_20182_();
                double x = pos.m_7096_();
                double z = pos.m_7094_();
                Vec3 vector3d = new Vec3(this.f_24975_ - x, this.f_24976_ - pos.m_7098_(), this.f_24977_ - z);
                double distance = vector3d.m_82553_();
                if (distance <= (double)(0.2f * purpoid.getSize().getScale())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else {
                    double dx = vector3d.f_82479_;
                    double dz = vector3d.f_82481_;
                    purpoid.f_20883_ = this.m_24991_(purpoid.m_146908_(), (float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875) - 90.0f, 90.0f);
                    purpoid.m_146922_(purpoid.f_20883_);
                    float newMoveSpeed = Mth.m_14179_((float)0.125f, (float)purpoid.m_6113_(), (float)((boosting ? 1.25f : 1.0f) * (float)(this.f_24978_ * purpoid.m_21133_(Attributes.f_22279_))));
                    purpoid.m_7910_(newMoveSpeed);
                    double normalizedY = vector3d.f_82480_ / distance;
                    purpoid.m_20256_(purpoid.m_20184_().m_82520_(0.0, (double)newMoveSpeed * normalizedY * 0.1, 0.0));
                    LookControl lookControl = purpoid.m_21563_();
                    double d11 = lookControl.m_24969_();
                    double d12 = lookControl.m_24970_();
                    double d13 = lookControl.m_24971_();
                    double d8 = x + dx / distance * 2.0;
                    double d9 = purpoid.m_20188_() + normalizedY / distance;
                    double d10 = z + dz / distance * 2.0;
                    if (!lookControl.m_186069_()) {
                        d11 = d8;
                        d12 = d9;
                        d13 = d10;
                    }
                    lookControl.m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
                    if (this.prevPos.m_82557_(pos) <= (double)0.005f) {
                        if (++this.stuckTicks >= 60) {
                            this.f_24981_ = MoveControl.Operation.WAIT;
                        }
                    } else {
                        this.stuckTicks = 0;
                    }
                }
            } else {
                purpoid.m_7910_(0.0f);
                if (purpoid.isNoEndimationPlaying() && !purpoid.isResting() && purpoid.getStunTimer() <= 0) {
                    purpoid.m_20256_(purpoid.m_20184_().m_82520_(0.0, boosting ? (double)0.025f : (double)0.01f, 0.0));
                }
            }
            this.prevPos = purpoid.m_20182_();
        }
    }
}

