/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.ai.charger.EetleCatapultGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.charger.EetleMeleeAttackGoal;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChargerEetle
extends AbstractEetle {
    private EetleMeleeAttackGoal meleeAttackGoal;
    private EetleCatapultGoal catapultGoal;
    @Nullable
    private ChargerEetle catapultingTarget;
    private int catapultTimer;

    public ChargerEetle(EntityType<? extends AbstractEetle> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.catapultGoal = new EetleCatapultGoal(this);
        this.meleeAttackGoal = new EetleMeleeAttackGoal(this);
        this.f_21345_.m_25352_(1, (Goal)this.catapultGoal);
        this.f_21345_.m_25352_(2, (Goal)this.meleeAttackGoal);
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.2f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.m_6162_()) {
            if (this.isCatapultProjectile()) {
                LivingEntity attackTarget = this.m_5448_();
                if (attackTarget != null) {
                    this.m_21573_().m_26573_();
                    this.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
                }
                this.catapultTimer = this.m_20096_() ? 0 : --this.catapultTimer;
            }
            if (this.f_19796_.m_188501_() < 0.005f && this.idleDelay <= 0 && this.m_5448_() == null && this.isNoEndimationPlaying()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.CHARGER_EETLE_FLAP);
                this.resetIdleFlapDelay();
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CatapultCooldown", this.catapultGoal.cooldown);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.catapultGoal.cooldown = compound.m_128451_("CatapultCooldown");
    }

    public boolean m_7327_(Entity target) {
        float attackDamage;
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.CHARGER_EETLE_ATTACK);
        }
        float damage = (float)((int)(attackDamage = (float)this.m_21133_(Attributes.f_22281_))) > 0.0f ? attackDamage / 2.0f + (float)this.f_19796_.m_188503_((int)attackDamage) : attackDamage;
        boolean attacked = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
        if (attacked) {
            this.m_19970_((LivingEntity)this, target);
            this.m_6731_((LivingEntity)target);
        }
        return attacked;
    }

    protected void m_6731_(LivingEntity target) {
        double knockbackForce;
        if (!this.m_6162_() && (knockbackForce = this.m_21133_(Attributes.f_22282_) - target.m_21133_(Attributes.f_22278_)) > 0.0) {
            RandomSource random = this.m_9236_().f_46441_;
            double scale = knockbackForce * (double)(random.m_188501_() * 1.0f + 0.5f);
            Vec3 horizontalVelocity = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_().m_82490_(scale);
            target.m_5997_(horizontalVelocity.f_82479_, knockbackForce * (double)(random.m_188501_() * 0.05f), horizontalVelocity.f_82481_);
            target.f_19864_ = true;
        }
    }

    @Override
    protected void updateGoals(GoalSelector goalSelector, GoalSelector targetSelector, boolean child) {
        super.updateGoals(goalSelector, targetSelector, child);
        if (child) {
            goalSelector.m_25363_((Goal)this.catapultGoal);
            goalSelector.m_25363_((Goal)this.meleeAttackGoal);
        } else {
            goalSelector.m_25352_(1, (Goal)this.catapultGoal);
            goalSelector.m_25352_(2, (Goal)this.meleeAttackGoal);
        }
    }

    @Nullable
    public ChargerEetle getCatapultingTarget() {
        return this.catapultingTarget;
    }

    public void setCatapultingTarget(@Nullable ChargerEetle catapultingTarget) {
        this.catapultingTarget = catapultingTarget;
    }

    public boolean isCatapulting() {
        return this.catapultingTarget != null;
    }

    public boolean isCatapultProjectile() {
        return this.catapultTimer > 0;
    }

    public void launchFromCatapult(LivingEntity target) {
        this.catapultGoal.resetCooldown();
        this.catapultTimer = 25;
        double xDifference = target.m_20185_() - this.m_20185_();
        double zDifference = target.m_20189_() - this.m_20189_();
        double verticalOffset = Mth.m_14116_((float)((float)(xDifference * xDifference + zDifference * zDifference))) * 0.475f;
        Vec3 launchMotion = new Vec3(xDifference, Math.max(0.0, target.m_20227_(0.25) - this.m_20186_() + verticalOffset), zDifference).m_82541_().m_82490_((double)1.325f);
        if (launchMotion.f_82480_ > (double)0.9f) {
            launchMotion = new Vec3(launchMotion.m_7096_(), (double)0.9f, launchMotion.m_7094_());
        }
        this.m_20256_(launchMotion);
    }
}

