/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BroodEggSack
extends Entity {
    private static final EntityDimensions FLYING_SIZE = EntityDimensions.m_20398_((float)1.5f, (float)1.5f);
    private static final EntityDimensions EXPOSED_SIZE = EntityDimensions.m_20398_((float)1.5f, (float)1.75f);
    private static final EntityDataAccessor<Integer> BROOD_ID = SynchedEntityData.m_135353_(BroodEggSack.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BroodEggSack(EntityType<?> entityType, Level world) {
        super((EntityType)EEEntityTypes.BROOD_EGG_SACK.get(), world);
    }

    public BroodEggSack(Level world) {
        super((EntityType)EEEntityTypes.BROOD_EGG_SACK.get(), world);
    }

    public BroodEggSack(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)EEEntityTypes.BROOD_EGG_SACK.get(), world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BROOD_ID, (Object)-1);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (BROOD_ID.equals(key)) {
            this.m_6210_();
        }
    }

    public void m_8119_() {
        Level world = this.m_9236_();
        BroodEetle broodEetle = this.getBroodEetle(world);
        if (!(world.f_46443_ || broodEetle != null && broodEetle.m_6084_() && broodEetle.getEggSack(world) == this)) {
            this.m_146870_();
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BroodID", 3)) {
            this.setBroodID(compound.m_128451_("BroodID"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        int broodID = this.getBroodID();
        if (broodID >= 0) {
            compound.m_128405_("BroodID", broodID);
        }
    }

    public void updatePosition(BroodEetle broodEetle) {
        Vec3 sackPos = BroodEggSack.getEggPos(broodEetle.m_20182_(), broodEetle.f_20883_, broodEetle.getEggCannonProgressServer(), broodEetle.getEggCannonFlyingProgressServer(), broodEetle.getFlyingRotations().getFlyPitch(), broodEetle.isOnLastHealthStage());
        this.m_6034_(sackPos.m_7096_(), sackPos.m_7098_(), sackPos.m_7094_());
    }

    public void setBroodID(int id) {
        this.f_19804_.m_135381_(BROOD_ID, (Object)Math.max(-1, id));
    }

    private int getBroodID() {
        return (Integer)this.f_19804_.m_135370_(BROOD_ID);
    }

    @Nullable
    private BroodEetle getBroodEetle(Level world) {
        Entity entity;
        int broodID = this.getBroodID();
        if (broodID >= 0 && (entity = world.m_6815_(broodID)) instanceof BroodEetle) {
            return (BroodEetle)entity;
        }
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        BroodEetle broodEetle;
        Level world = this.m_9236_();
        if (!world.f_46443_ && (broodEetle = this.getBroodEetle(world)) != null && broodEetle.m_6084_() && (broodEetle.isEggMouthOpen() || broodEetle.isOnLastHealthStage())) {
            LivingEntity livingEntity;
            Entity trueSource = source.m_7639_();
            LivingEntity livingEntity2 = livingEntity = trueSource instanceof LivingEntity ? (LivingEntity)trueSource : null;
            if (livingEntity != null) {
                amount += 0.25f * EnchantmentHelper.m_44833_((ItemStack)livingEntity.m_21205_(), (MobType)MobType.f_21642_);
            }
            if (broodEetle.attackEntityFromEggSack(source, amount)) {
                if (livingEntity != null) {
                    this.m_19970_(livingEntity, (Entity)broodEetle);
                }
                if (world instanceof ServerLevel) {
                    ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)EEBlocks.EETLE_EGG.get()).m_49966_()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 15, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                }
                return true;
            }
        }
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        BroodEetle broodEetle = this.getBroodEetle(this.m_9236_());
        if (broodEetle != null) {
            if (broodEetle.isFlying()) {
                return FLYING_SIZE;
            }
            if (broodEetle.isOnLastHealthStage()) {
                return EXPOSED_SIZE;
            }
        }
        return super.m_6972_(pose);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static Vec3 getEggPos(Vec3 pos, float yaw, float eggCannonProgress, float eggCannonFlyingProgress, float flyPitch, boolean exposed) {
        float flyPitchMultiplier = (flyPitch = Mth.m_14036_((float)flyPitch, (float)-30.0f, (float)20.0f)) >= 0.0f ? 0.0425f : 0.0567f;
        float xOffset = flyPitch < 0.0f ? flyPitch * 0.033f : 0.0f;
        return pos.m_82549_(new Vec3((double)(-1.75f + 0.8f * eggCannonProgress - xOffset), 1.3 + Math.sin(eggCannonProgress * 0.91f) - Math.sin(eggCannonFlyingProgress * 1.2f) + (double)(flyPitch * flyPitchMultiplier) - (double)(exposed ? (eggCannonProgress == 0.0f ? 0.2f : eggCannonProgress * 0.75f) : 0.0f), 0.0).m_82524_(-yaw * ((float)Math.PI / 180) - 1.5707964f));
    }
}

