/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.api.entity.util.DetectionHelper;
import com.teamabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.teamabnormals.endergetic.api.entity.util.RayTraceHelper;
import com.teamabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloAdolescent;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloBaby;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloAttackGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloBoofGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloBreedGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloEatFruitGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloEatPuffBugGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloFaceRandomGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloGiveBirthGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloGroundHopGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloHuntFruitGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloHuntPuffBugGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloNearestAttackableTargetGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloSinkGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloSlamGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloSwimGoal;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BoofloTemptGoal;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Booflo
extends PathfinderMob
implements Endimatable {
    public static final Predicate<Entity> IS_SCARED_BY = entity -> {
        if (entity instanceof Player) {
            return !entity.m_5833_() && !((Player)entity).m_7500_();
        }
        return false;
    };
    private static final int BOOST_POWER_INCREMENT = 10;
    private static final int MAX_BOOST_POWER = 182;
    private static final int HALF_BOOST_POWER = 91;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> LAST_FED_UNIQUE_ID = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> ON_GROUND = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOVING_IN_AIR = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BOOFED = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HUNGRY = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_FRUIT = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FRUITS_NEEDED = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> BOOST_STATUS = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> BOOST_POWER = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LOVE_TICKS = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TARGET = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BRACELETS_COLOR = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> LOCKED_YAW = SynchedEntityData.m_135353_(Booflo.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDimensions BOOFED_SIZE = EntityDimensions.m_20398_((float)2.0f, (float)1.5f);
    public final TimedEndimation OPEN_JAW = new TimedEndimation(25, 0);
    private final EndergeticFlyingPathNavigator attackingNavigator = new EndergeticFlyingPathNavigator((Mob)this, this.m_9236_());
    private UUID playerInLove;
    public int hopDelay;
    public int breedDelay;
    private int croakDelay;
    private int deflateDelay;
    public int babiesToBirth;
    public boolean wasBred;
    private boolean shouldPlayLandSound;
    private boolean wasOnGround;

    public Booflo(EntityType<? extends Booflo> type, Level world) {
        super(type, world);
        this.f_21342_ = new GroundMoveHelperController(this);
        this.hopDelay = this.getDefaultGroundHopDelay();
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(LAST_FED_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(ON_GROUND, (Object)false);
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(MOVING_IN_AIR, (Object)false);
        this.f_19804_.m_135372_(BOOFED, (Object)false);
        this.f_19804_.m_135372_(HUNGRY, (Object)(this.m_217043_().m_188501_() < 0.6f ? 1 : 0));
        this.f_19804_.m_135372_(HAS_FRUIT, (Object)false);
        this.f_19804_.m_135372_(BOOST_STATUS, (Object)0);
        this.f_19804_.m_135372_(BOOST_POWER, (Object)0);
        this.f_19804_.m_135372_(FRUITS_NEEDED, (Object)(this.m_217043_().m_188503_(3) + 2));
        this.f_19804_.m_135372_(LOVE_TICKS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TARGET, (Object)0);
        this.f_19804_.m_135372_(BRACELETS_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(LOCKED_YAW, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BoofloGiveBirthGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BoofloEatPuffBugGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BoofloBoofGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BoofloSlamGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BoofloBreedGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BoofloEatFruitGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BoofloSinkGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BoofloTemptGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new BoofloHuntPuffBugGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new BoofloAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new BoofloHuntFruitGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new BoofloSwimGoal(this, 1.0, 15));
        this.f_21345_.m_25352_(9, (Goal)new BoofloFaceRandomGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new BoofloGroundHopGoal(this));
        this.f_21346_.m_25352_(1, new BoofloNearestAttackableTargetGoal<PuffBug>((Mob)this, PuffBug.class, 175, true, false));
        this.f_21346_.m_25352_(2, new BoofloNearestAttackableTargetGoal<BolloomFruit>((Mob)this, BolloomFruit.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)1.05f).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 22.0).m_22268_(Attributes.f_22278_, (double)0.6f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.breedDelay > 0) {
            --this.breedDelay;
        }
        if (this.deflateDelay > 0) {
            --this.deflateDelay;
        }
        if (this.croakDelay > 0) {
            --this.croakDelay;
        }
        if (this.isBoofed()) {
            if (this.hasAggressiveAttackTarget()) {
                this.f_21344_ = this.attackingNavigator;
            } else {
                if (this.f_21344_ instanceof EndergeticFlyingPathNavigator) {
                    this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_()){

                        public boolean m_6342_(BlockPos pos) {
                            return this.f_26495_.m_46859_(pos);
                        }
                    };
                }
                if (this.getBoofloAttackTarget() == null && this.m_21691_() && this.m_20184_().m_82553_() < 0.25 && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).m_6662_() == HitResult.Type.BLOCK) {
                    this.m_21573_().m_26573_();
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_CHARGE) && this.getAnimationTick() >= 15) {
                this.m_5997_(0.0, -0.225f, 0.0);
            }
            this.m_6853_(!this.m_9236_().m_45772_(DetectionHelper.checkOnGround(this.m_20191_(), 0.07f)));
            int power = this.getBoostPower();
            if (power > 0 && !this.isBoostExpanding()) {
                this.setBoostPower(Math.max(0, power - (this.m_20096_() ? 3 : 2)));
                if (this.getBoostPower() <= 0) {
                    this.setBoostLocked(false);
                }
            } else if (this.isBoostExpanding()) {
                if (power < 182) {
                    if (this.isBoostLocked()) {
                        int incremented = power + 10;
                        this.setBoostPower(Math.min(91, incremented));
                        if (incremented >= 91) {
                            this.setBoostExpanding(false);
                        }
                    } else {
                        this.setBoostPower(Math.min(182, power + 10));
                    }
                } else {
                    if (!this.isBoostLocked() && this.m_6688_() instanceof Player) {
                        NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_INFLATE);
                        this.m_5496_(this.getInflateSound(), 0.75f, 1.0f);
                    }
                    this.setBoostExpanding(false);
                }
            }
            if (this.m_20096_() && !this.isBoofed() && this.isBoostExpanding()) {
                this.setBoostExpanding(false);
                this.setBoostLocked(false);
            }
            if (this.isBoofed() && !this.m_20096_()) {
                this.setBoofed(true);
            }
            if (this.isBoofed() && this.isNoEndimationPlaying() && this.isMovingInAir() && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).m_6662_() != HitResult.Type.BLOCK) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_SWIM);
            }
            if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_SWIM) && this.getAnimationTick() <= 15) {
                this.setMovingInAir(true);
            }
            if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_EAT) && this.getAnimationTick() > 20 && this.getAnimationTick() <= 140) {
                if (this.getAnimationTick() % 20 == 0) {
                    if (this.m_9236_() instanceof ServerLevel && this.hasCaughtFruit()) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)EEItems.BOLLOOM_FRUIT.get())), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                    }
                    if (this.hasCaughtPuffBug()) {
                        ((Entity)this.m_20197_().get(0)).m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 0.0f);
                    }
                    this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                }
                if (this.getAnimationTick() == 140) {
                    this.setCaughtFruit(false);
                    this.m_5634_(5.0f);
                    if (this.hasCaughtPuffBug()) {
                        this.m_5496_(SoundEvents.f_12321_, 1.0f, 0.75f);
                        ((Entity)this.m_20197_().get(0)).m_146870_();
                    }
                }
            }
            if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_HOP) && this.getAnimationTick() == 10) {
                this.m_5496_(this.getHopSound(false), 0.95f, this.m_6100_());
                this.shouldPlayLandSound = true;
            }
            if (this.shouldPlayLandSound && this.m_20096_() && !this.wasOnGround) {
                this.m_5496_(this.getHopSound(true), 0.95f, this.m_6100_());
                this.shouldPlayLandSound = false;
            }
        }
        if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_INFLATE) && this.getAnimationTick() == 2) {
            this.boof(1.0f, 1.0f, false);
        }
        if (!this.m_9236_().f_46443_ && this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_GROWL)) {
            if (this.getAnimationTick() == 10) {
                this.m_5496_(this.getGrowlSound(), 0.75f, this.m_6100_());
            }
            if (this.getAnimationTick() >= 20) {
                for (Player players : this.getNearbyPlayers(0.4f)) {
                    if (this.hasAggressiveAttackTarget()) continue;
                    this.setBoofloAttackTargetId(players.m_19879_());
                }
            }
        }
        if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_SLAM) && this.getAnimationTick() == 3) {
            this.boof(1.2f, 2.2f, true);
            this.m_5496_(this.getSlamSound(), 0.75f, 1.0f);
        }
        if (this.m_20069_()) {
            if (!this.isBoofed()) {
                this.setBoofed(true);
            } else if (this.f_19796_.m_188501_() < 0.7f) {
                this.m_5997_(0.0, 0.05f, 0.0);
            }
        }
        if (this.m_20096_() && this.isBoofed()) {
            if (this.hasAggressiveAttackTarget() && !this.hasCaughtPuffBug()) {
                if (!this.m_9236_().f_46443_) {
                    if (this.isNoEndimationPlaying()) {
                        NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_INFLATE);
                    } else if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_CHARGE)) {
                        NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_SLAM);
                    }
                }
            } else if (this.m_20160_() && this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_CHARGE)) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_SLAM);
            } else if (this.deflateDelay <= 0 && !this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_SLAM) && !this.m_20069_()) {
                this.setBoofed(false);
            }
        }
        if (this.m_217043_().m_188503_(40000) < 10 && !this.hasCaughtFruit() && !this.hasCaughtPuffBug()) {
            this.setHungry(true);
        }
        if (this.m_9236_().f_46443_ && this.isBoofed()) {
            this.OPEN_JAW.setDecrementing(this.getBoofloAttackTarget() == null || this.hasCaughtPuffBug() || this.hasAggressiveAttackTarget() && !(this.getBoofloAttackTarget() instanceof PuffBug));
            this.OPEN_JAW.tick();
        }
        this.wasOnGround = this.m_20096_();
        if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_EAT) && !this.hasCaughtFruit()) {
            this.f_20885_ = this.f_20883_ = this.getLockedYaw();
            this.m_146922_(this.f_20883_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.hopDelay > 0) {
            --this.hopDelay;
        }
        if (this.getInLoveTicks() > 0) {
            this.setInLove(this.getInLoveTicks() - 1);
            if (this.getInLoveTicks() % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
        }
        if (!this.m_9236_().f_46443_ && this.croakDelay == 0 && !this.isTempted() && this.m_6084_() && this.m_20096_() && !this.isBoofed() && this.f_19796_.m_188503_(1000) < this.f_21363_++ && this.isNoEndimationPlaying() && this.m_20197_().isEmpty()) {
            this.f_21363_ = -this.m_8100_();
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_CROAK);
        }
        if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_CROAK) && this.getAnimationTick() == 5 && !this.m_9236_().f_46443_) {
            this.m_5496_(this.m_7515_(), 1.25f, this.m_6100_());
        }
        if (this.hasAggressiveAttackTarget()) {
            this.m_146922_(this.f_20885_);
            Entity attackTarget = this.getBoofloAttackTarget();
            if (!this.m_9236_().f_46443_ && (this.m_20280_(attackTarget) > 1152.0 || attackTarget.m_20145_() || attackTarget instanceof PuffBug && attackTarget.m_20159_())) {
                this.setBoofloAttackTargetId(0);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsMovingInAir", this.isMovingInAir());
        compound.m_128379_("IsBoofed", this.isBoofed());
        compound.m_128379_("IsHungry", this.isHungry());
        compound.m_128379_("HasFruit", this.hasCaughtFruit());
        compound.m_128379_("WasBred", this.wasBred);
        compound.m_128405_("FruitsNeededTillTamed", this.getFruitsNeededTillTamed());
        compound.m_128405_("InLove", this.getInLoveTicks());
        compound.m_128405_("BoofloTargetId", this.getBoofloAttackTargetId());
        compound.m_128405_("BabiesToBirth", this.babiesToBirth);
        compound.m_128344_("BraceletsColor", (byte)this.getBraceletsColor().m_41060_());
        compound.m_128350_("BirthYaw", this.getLockedYaw());
        if (this.playerInLove != null) {
            compound.m_128362_("LoveCause", this.playerInLove);
        }
        if (this.getOwnerId() != null) {
            compound.m_128359_("Owner", this.getOwnerId().toString());
        }
        if (this.getLastFedId() != null) {
            compound.m_128359_("LastFed", this.getLastFedId().toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID lastFedUUID;
        super.m_7378_(compound);
        this.setMovingInAir(compound.m_128471_("IsMovingInAir"));
        this.setBoofed(compound.m_128471_("IsBoofed"));
        this.setHungry(compound.m_128471_("IsHungry"));
        this.setCaughtFruit(compound.m_128471_("HasFruit"));
        this.setInLove(compound.m_128451_("InLove"));
        this.setBoofloAttackTargetId(compound.m_128451_("BoofloTargetId"));
        this.babiesToBirth = compound.m_128451_("BabiesToBirth");
        this.setLockedYaw(compound.m_128457_("BirthYaw"));
        this.playerInLove = compound.m_128403_("LoveCause") ? compound.m_128342_("LoveCause") : null;
        this.wasBred = compound.m_128471_("WasBred");
        if (compound.m_128425_("BraceletsColor", 99)) {
            this.setBraceletsColor(DyeColor.m_41053_((int)compound.m_128451_("BraceletsColor")));
        }
        if (compound.m_128441_("FruitsNeededTillTamed")) {
            this.setFruitsNeeded(compound.m_128451_("FruitsNeededTillTamed"));
        }
        UUID ownerUUID = compound.m_128403_("Owner") ? compound.m_128342_("Owner") : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)compound.m_128461_("Owner"));
        UUID uUID = lastFedUUID = compound.m_128403_("LastFed") ? compound.m_128342_("LastFed") : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)compound.m_128461_("LastFed"));
        if (ownerUUID != null) {
            try {
                this.setOwnerId(ownerUUID);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        if (lastFedUUID != null) {
            try {
                this.setLastFedId(lastFedUUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (BOOFED.equals(key)) {
            this.m_6210_();
            if (this.isBoofed()) {
                this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_()){

                    public boolean m_6342_(BlockPos pos) {
                        return this.f_26495_.m_46859_(pos);
                    }
                };
                this.f_21342_ = new FlyingMoveController(this);
                this.f_21365_ = new FlyingLookController(this, 10);
                if (!this.m_9236_().f_46443_ && this.f_19797_ > 5) {
                    this.m_5496_(this.getInflateSound(), this.m_6121_(), this.m_6100_());
                }
                this.deflateDelay = 10;
            } else {
                this.f_21344_ = this.m_6037_(this.m_9236_());
                this.f_21342_ = new GroundMoveHelperController(this);
                this.f_21365_ = new LookControl((Mob)this);
                if (!this.m_9236_().f_46443_ && this.f_19797_ > 5) {
                    this.m_5496_(this.getDeflateSound(), this.m_6121_(), this.m_6100_());
                }
                if (this.m_9236_().f_46443_) {
                    this.OPEN_JAW.setTick(0);
                    this.setBoofloAttackTargetId(0);
                }
            }
        }
    }

    public void m_274498_(Player rider, Vec3 vec3d) {
        super.m_274498_(rider, vec3d);
        this.m_146922_(rider.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(0.0f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        float playerMoveFoward = rider.f_20902_;
        if (!this.m_9236_().m_5776_() && playerMoveFoward > 0.0f) {
            if (this.m_20096_() && this.isNoEndimationPlaying() && !this.isBoofed()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_HOP);
            } else if (!this.m_20096_() && this.isNoEndimationPlaying() && this.isBoofed()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_SWIM);
            }
        }
        if (this.isBoofed()) {
            float gravity;
            float f = gravity = this.getBoostPower() > 0 ? 0.01f : 0.035f;
            if (this.m_21691_()) {
                this.m_21573_().m_26573_();
            }
            if (this.getBoofloAttackTarget() != null) {
                this.setBoofloAttackTargetId(0);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, (double)gravity, 0.0));
            }
        } else if (this.m_20096_() && this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_HOP) && this.getAnimationTick() == 10) {
            Vec3 motion = this.m_20184_();
            MobEffectInstance jumpBoost = this.m_21124_(MobEffects.f_19603_);
            float boostPower = jumpBoost == null ? 1.0f : (float)(jumpBoost.m_19564_() + 1);
            this.m_20334_(motion.f_82479_, 0.55f * boostPower, motion.f_82481_);
            this.f_19812_ = true;
            float xMotion = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float zMotion = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float multiplier = 0.35f + (float)this.m_21051_(Attributes.f_22279_).m_22135_();
            this.m_20256_(this.m_20184_().m_82520_((double)(xMotion * multiplier), 0.0, (double)(zMotion * multiplier)));
        }
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_6084_() && this.m_20160_()) {
            if (this.m_6109_()) {
                super.m_7023_(new Vec3(0.0, vec3d.f_82480_, 0.0));
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        } else if (this.m_21515_() && this.isBoofed()) {
            this.m_19920_(0.0f, vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMovingInAir()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
            }
        } else {
            super.m_7023_(vec3d);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            if (worldIn.m_213780_().m_188501_() < 0.2f) {
                this.babiesToBirth = 3;
            }
            this.setFruitsNeeded(worldIn.m_213780_().m_188503_(3) + 2);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_20351_(Entity passenger) {
        if (!this.m_9236_().f_46443_ && this.isBoostExpanding() && !this.isBoostLocked() && passenger instanceof Player && this.m_6688_() == passenger) {
            this.setBoostExpanding(false);
        }
        super.m_20351_(passenger);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public UUID getLastFedId() {
        return ((Optional)this.f_19804_.m_135370_(LAST_FED_UNIQUE_ID)).orElse(null);
    }

    public void setLastFedId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(LAST_FED_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    public boolean m_20096_() {
        return (Boolean)this.f_19804_.m_135370_(ON_GROUND);
    }

    public void m_6853_(boolean onGround) {
        this.f_19804_.m_135381_(ON_GROUND, (Object)onGround);
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    public boolean isMovingInAir() {
        return (Boolean)this.f_19804_.m_135370_(MOVING_IN_AIR);
    }

    public void setMovingInAir(boolean moving) {
        this.f_19804_.m_135381_(MOVING_IN_AIR, (Object)moving);
    }

    public boolean isBoofed() {
        return (Boolean)this.f_19804_.m_135370_(BOOFED);
    }

    public void setBoofed(boolean boofed) {
        this.f_19804_.m_135381_(BOOFED, (Object)boofed);
        this.shouldPlayLandSound = false;
    }

    public boolean isPregnant() {
        return this.babiesToBirth > 0;
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(HUNGRY, (Object)hungry);
    }

    public boolean hasCaughtFruit() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FRUIT);
    }

    public boolean hasCaughtPuffBug() {
        return !this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof PuffBug;
    }

    public void setCaughtFruit(boolean hasCaughtFruit) {
        this.f_19804_.m_135381_(HAS_FRUIT, (Object)hasCaughtFruit);
    }

    public void setBoostStatus(int status, boolean add) {
        this.f_19804_.m_135381_(BOOST_STATUS, (Object)((byte)(add ? (Byte)this.f_19804_.m_135370_(BOOST_STATUS) | status : (Byte)this.f_19804_.m_135370_(BOOST_STATUS) & ~status)));
    }

    public void setBoostExpanding(boolean expanding) {
        this.setBoostStatus(1, expanding);
    }

    public boolean isBoostExpanding() {
        return ((Byte)this.f_19804_.m_135370_(BOOST_STATUS) & 1) != 0;
    }

    public void setBoostLocked(boolean expandingDelay) {
        this.setBoostStatus(2, expandingDelay);
    }

    public boolean isBoostLocked() {
        return ((Byte)this.f_19804_.m_135370_(BOOST_STATUS) & 2) != 0;
    }

    public float getLockedYaw() {
        return ((Float)this.f_19804_.m_135370_(LOCKED_YAW)).floatValue();
    }

    public void setLockedYaw(float yaw) {
        this.f_19804_.m_135381_(LOCKED_YAW, (Object)Float.valueOf(yaw));
    }

    public int getBoofloAttackTargetId() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TARGET);
    }

    @Nullable
    public Entity getBoofloAttackTarget() {
        Entity entity = this.m_9236_().m_6815_(this.getBoofloAttackTargetId());
        if (entity == null || entity != null && !entity.m_6084_() || entity instanceof Booflo) {
            this.setBoofloAttackTargetId(0);
        }
        if (this.getOwner() != null && this.getOwner() == entity) {
            this.setBoofloAttackTargetId(0);
        }
        return this.getBoofloAttackTargetId() > 0 ? entity : null;
    }

    public boolean hasAggressiveAttackTarget() {
        return this.getBoofloAttackTarget() instanceof LivingEntity;
    }

    public void setBoofloAttackTargetId(int id) {
        this.f_19804_.m_135381_(ATTACK_TARGET, (Object)id);
    }

    public void setInLove(@Nullable Player player) {
        this.setInLove(600);
        if (player != null) {
            this.playerInLove = player.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    public void setFruitsNeeded(int fruitsNeeded) {
        this.f_19804_.m_135381_(FRUITS_NEEDED, (Object)fruitsNeeded);
    }

    public int getFruitsNeededTillTamed() {
        return (Integer)this.f_19804_.m_135370_(FRUITS_NEEDED);
    }

    public void setBoostPower(int power) {
        this.f_19804_.m_135381_(BOOST_POWER, (Object)power);
    }

    public int getBoostPower() {
        return (Integer)this.f_19804_.m_135370_(BOOST_POWER);
    }

    public DyeColor getBraceletsColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRACELETS_COLOR)));
    }

    public void setBraceletsColor(DyeColor color) {
        this.f_19804_.m_135381_(BRACELETS_COLOR, (Object)color.m_41060_());
    }

    public void setInLove(int ticks) {
        this.f_19804_.m_135381_(LOVE_TICKS, (Object)ticks);
    }

    public int getInLoveTicks() {
        return (Integer)this.f_19804_.m_135370_(LOVE_TICKS);
    }

    public boolean canBreed() {
        return this.isTamed() && this.getInLoveTicks() <= 0 && !this.isPregnant() && this.breedDelay <= 0;
    }

    public boolean isInLove() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getInLoveTicks() > 0;
    }

    public void resetInLove() {
        this.setInLove(0);
    }

    @Nullable
    public ServerPlayer getLoveCause() {
        if (this.playerInLove == null) {
            return null;
        }
        Player playerentity = this.m_9236_().m_46003_(this.playerInLove);
        return playerentity instanceof ServerPlayer ? (ServerPlayer)playerentity : null;
    }

    public void setTamedBy(Player player) {
        this.setTamed(true);
        this.setOwnerId(player.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10590_.m_68829_(serverPlayer, (Animal)EntityType.f_20499_.m_20615_(this.m_9236_()));
            if (!this.m_9236_().f_46443_) {
                EECriteriaTriggers.TAME_BOOFLO.trigger(serverPlayer);
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    @Nullable
    public LivingEntity getLastFedPlayer() {
        try {
            UUID uuid = this.getLastFedId();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public boolean canMateWith(Booflo possibleMate) {
        if (possibleMate == this) {
            return false;
        }
        return this.isInLove() && possibleMate.isInLove();
    }

    public int getDefaultGroundHopDelay() {
        return this.isInLove() ? this.f_19796_.m_188503_(10) + 25 : this.f_19796_.m_188503_(40) + 80;
    }

    public void boof(float internalStrength, float offensiveStrength, boolean slam) {
        float verticalStrength = 1.0f;
        if (this.m_20160_() && this.m_6688_() instanceof Player && !this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_SLAM) && !this.isBoostLocked()) {
            float boostPower = Mth.m_14036_((float)((float)this.getBoostPower() * 0.01f), (float)0.35f, (float)1.82f);
            offensiveStrength *= Mth.m_14036_((float)(boostPower / 2.0f), (float)0.5f, (float)1.85f);
            float xMotion = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float zMotion = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            Vec3 boostFowardForce = new Vec3((double)xMotion, (double)(1.3f * (verticalStrength *= Mth.m_14036_((float)boostPower, (float)0.35f, (float)1.5f))), (double)zMotion).m_82541_().m_82490_((double)boostPower > 0.35 ? (double)(boostPower * 2.0f) : (double)boostPower);
            this.m_20334_(boostFowardForce.m_7096_(), 1.3f * verticalStrength, boostFowardForce.m_7094_());
        } else {
            this.m_5997_(-Mth.m_14031_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (4.0f * internalStrength * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f, 1.3f * verticalStrength, Mth.m_14089_((float)((float)((double)this.m_146908_() * Math.PI / 180.0))) * (4.0f * internalStrength * (this.f_19796_.m_188501_() + 0.1f)) * 0.1f);
        }
        if (slam) {
            for (int i = 0; i < 12; ++i) {
                double offsetX = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                double offsetZ = MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.25f), (RandomSource)this.f_19796_);
                double x = this.m_20185_() + 0.5 + offsetX;
                double y = this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * 0.05f);
                double z = this.m_20189_() + 0.5 + offsetZ;
                if (!this.m_9236_().f_46443_) continue;
                this.m_9236_().m_7106_((ParticleOptions)EEParticleTypes.POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.3f), (RandomSource)this.f_19796_) + (double)0.025f, (double)(this.f_19796_.m_188501_() * 0.15f + 0.1f), MathUtil.makeNegativeRandomly((double)(this.f_19796_.m_188501_() * 0.3f), (RandomSource)this.f_19796_) + (double)0.025f);
            }
        }
        for (Entity entity2 : this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_((double)(3.5f * Math.max(offensiveStrength / 2.0f, 1.0f))), entity -> !(entity == this || !(entity instanceof ItemEntity) && !(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).m_7500_() && ((Player)entity).m_150110_().f_35935_))) {
            float resistance = this.isResistantToBoof(entity2) ? 0.15f : 1.0f;
            float amount = 0.2f * offensiveStrength * resistance;
            if (offensiveStrength > 2.0f && resistance > 0.15f && entity2 != this.m_6688_()) {
                entity2.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22115_());
                entity2.f_19864_ = false;
            }
            Vec3 result = entity2.m_20182_().m_82546_(this.m_20182_());
            entity2.m_5997_(result.f_82479_ * (double)amount, ((double)this.f_19796_.m_188501_() * 0.75 + 0.25) * (double)(offensiveStrength * 0.75f), result.f_82481_ * (double)amount);
        }
    }

    public LivingEntity growDown() {
        if (this.m_6084_()) {
            BoofloAdolescent boofloAdolescent = (BoofloAdolescent)((EntityType)EEEntityTypes.BOOFLO_ADOLESCENT.get()).m_20615_(this.m_9236_());
            boofloAdolescent.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.m_8077_()) {
                boofloAdolescent.m_6593_(this.m_7770_());
                boofloAdolescent.m_20340_(this.m_20151_());
            }
            if (this.m_21523_()) {
                boofloAdolescent.m_21463_(this.m_21524_(), true);
                this.m_21455_(true, false);
            }
            if (this.m_20202_() != null) {
                boofloAdolescent.m_20329_(this.m_20202_());
            }
            boofloAdolescent.wasBred = this.wasBred;
            boofloAdolescent.m_21153_(boofloAdolescent.m_21233_());
            this.m_9236_().m_7967_((Entity)boofloAdolescent);
            this.m_146870_();
            return boofloAdolescent;
        }
        return this;
    }

    public void catchPuffBug(PuffBug puffbug) {
        puffbug.m_7998_((Entity)this, true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isTamed() && !this.wasBred && !this.isPregnant();
    }

    public boolean isTempted() {
        for (Object goals : this.f_21345_.m_25386_().toArray()) {
            if (!(goals instanceof WrappedGoal)) continue;
            return ((WrappedGoal)goals).m_26015_() instanceof BoofloTemptGoal;
        }
        return false;
    }

    public List<Player> getNearbyPlayers(float multiplier) {
        return this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82377_((double)(8.0f * multiplier), 4.0, (double)(8.0f * multiplier)), IS_SCARED_BY);
    }

    public boolean isPlayerNear(float multiplier) {
        return !this.getNearbyPlayers(multiplier).isEmpty();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.isBoofed() ? 1.2f : 0.9f;
    }

    public int m_8100_() {
        return 120;
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        if (endimation == EEPlayableEndimations.BOOFLO_SWIM) {
            float pitch = this.m_20160_() ? 1.0f : this.m_146909_();
            float xMotion = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            float yMotion = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
            float zMotion = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
            double motionScale = this.hasAggressiveAttackTarget() && !this.hasCaughtPuffBug() || !this.m_20197_().isEmpty() && !this.hasCaughtPuffBug() ? (double)0.85f : 0.5;
            Vec3 motion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion).m_82541_().m_82542_(motionScale, 0.5, motionScale);
            this.m_5997_(motion.f_82479_ * (this.m_21051_(Attributes.f_22279_).m_22135_() - (double)0.05f), motion.f_82480_, motion.f_82481_ * (this.m_21051_(Attributes.f_22279_).m_22135_() - (double)0.05f));
        }
    }

    protected void m_6135_() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, 0.55, vec3d.f_82481_);
        this.f_19812_ = true;
    }

    protected void m_7324_(Entity entity) {
        if (entity instanceof BoofloBaby && (((BoofloBaby)entity).isBeingBorn() || ((BoofloBaby)entity).getMotherNoClipTicks() > 0)) {
            return;
        }
        super.m_7324_(entity);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof SpawnEggItem && ((SpawnEggItem)item).m_43230_(itemstack.m_41783_(), this.m_6095_())) {
            if (!this.m_9236_().f_46443_) {
                BoofloBaby baby = (BoofloBaby)((EntityType)EEEntityTypes.BOOFLO_BABY.get()).m_20615_(this.m_9236_());
                baby.setGrowingAge(-24000);
                baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)baby);
                if (itemstack.m_41788_()) {
                    baby.m_6593_(itemstack.m_41786_());
                }
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (item == ((Block)EEBlocks.POISE_CLUSTER.get()).m_5456_() && this.canBreed()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.setInLove(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (item == EEItems.BOLLOOM_FRUIT.get() && !this.m_5912_() && !this.hasCaughtFruit() && this.m_20096_()) {
            SimpleParticleType particle = ParticleTypes.f_123750_;
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.setCaughtFruit(true);
            this.setHungry(false);
            if (!this.isTamed()) {
                if (this.getFruitsNeededTillTamed() >= 1) {
                    this.setFruitsNeeded(this.getFruitsNeededTillTamed() - 1);
                    this.setLastFedId(player.m_20148_());
                    particle = ParticleTypes.f_123762_;
                    if (!this.m_9236_().f_46443_) {
                        NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_GROWL);
                    }
                } else if (player == this.getLastFedPlayer()) {
                    this.setFruitsNeeded(0);
                    this.setTamedBy(player);
                    this.croakDelay = 40;
                }
            }
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (item instanceof DyeItem && this.isTamed()) {
            DyeColor dyecolor = ((DyeItem)item).m_41089_();
            if (dyecolor != this.getBraceletsColor()) {
                this.setBraceletsColor(dyecolor);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else {
            InteractionResult result = itemstack.m_41647_(player, (LivingEntity)this, hand);
            if (result == InteractionResult.CONSUME || result == InteractionResult.SUCCESS) {
                return InteractionResult.PASS;
            }
            if (this.isTamed() && !this.m_20160_() && !this.isPregnant()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_146922_(this.m_146908_());
                    player.m_146926_(this.m_146909_());
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.PASS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction func) {
        if (this.m_20363_(passenger)) {
            if (passenger instanceof BoofloBaby) {
                BoofloBaby boofloBaby = (BoofloBaby)passenger;
                Vec3 ridingOffset = boofloBaby.getBirthPositionOffset().m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
                func.m_20372_(passenger, this.m_20185_() + ridingOffset.f_82479_, this.m_20186_() + (double)0.9f, this.m_20189_() + ridingOffset.f_82481_);
            } else if (passenger instanceof PuffBug) {
                PuffBug puffbug = (PuffBug)passenger;
                puffbug.f_20883_ = puffbug.f_20885_ = this.m_146908_() - 75.0f;
                passenger.m_146922_(puffbug.f_20885_);
                if (this.isEndimationPlaying(EEPlayableEndimations.BOOFLO_EAT) && this.getAnimationTick() > 15) {
                    Vec3 ridingPos = new Vec3(1.0, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
                    float yOffset = puffbug.m_6162_() ? 0.1f : 0.3f;
                    func.m_20372_(passenger, this.m_20185_() + ridingPos.m_7096_(), this.m_20186_() - (double)yOffset - (double)(0.15f * Booflo.getEatingOffsetProgress(this.getAnimationTick())), this.m_20189_() + ridingPos.m_7094_());
                } else {
                    func.m_20372_(passenger, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                }
            } else {
                super.m_19956_(passenger, func);
                if (passenger instanceof Mob) {
                    Mob mob = (Mob)passenger;
                    this.f_20883_ = mob.f_20883_;
                }
            }
        }
    }

    public double m_6048_() {
        double original = super.m_6048_();
        return this.isBoofed() ? original + (double)0.15f : original;
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected boolean m_7310_(Entity passenger) {
        int limit = this.isPregnant() ? 3 : 1;
        return this.m_20197_().size() < limit;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entitySource = source.m_7639_();
        if (entitySource instanceof LivingEntity && !this.m_20160_()) {
            if (entitySource instanceof Player) {
                if (!entitySource.m_5833_() && !((Player)entitySource).m_7500_()) {
                    this.setBoofloAttackTargetId(entitySource.m_19879_());
                }
            } else {
                this.setBoofloAttackTargetId(entitySource.m_19879_());
            }
        }
        float newCalculatedDamage = source.m_276093_(DamageTypes.f_268612_) ? 0.5f : amount;
        if (super.m_6469_(source, source.m_7639_() instanceof PuffBug ? 2.5f : newCalculatedDamage)) {
            if (this.isNoEndimationPlaying()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.BOOFLO_HURT);
            }
            return true;
        }
        return false;
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        Entity entitySource = damageSrc.m_7639_();
        if (entitySource instanceof LivingEntity && !this.m_20160_()) {
            if (entitySource instanceof Player) {
                if (!entitySource.m_5833_() && !((Player)entitySource).m_7500_()) {
                    this.setBoofloAttackTargetId(entitySource.m_19879_());
                }
            } else {
                this.setBoofloAttackTargetId(entitySource.m_19879_());
            }
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    public int m_8085_() {
        return 1;
    }

    public int m_5792_() {
        return 3;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isBoofed() ? BOOFED_SIZE : super.m_6972_(poseIn);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob;
        }
        entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    protected boolean isResistantToBoof(Entity entity) {
        return entity instanceof Booflo || entity instanceof BoofloAdolescent || entity instanceof BoofloBaby;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8032_() {
    }

    public SoundEvent getHopSound(boolean landing) {
        return landing ? (SoundEvent)EESoundEvents.BOOFLO_HOP_LAND.get() : (SoundEvent)EESoundEvents.BOOFLO_HOP.get();
    }

    public SoundEvent getGrowlSound() {
        return (SoundEvent)EESoundEvents.BOOFLO_GROWL.get();
    }

    public SoundEvent getSlamSound() {
        return (SoundEvent)EESoundEvents.BOOFLO_SLAM.get();
    }

    public SoundEvent getInflateSound() {
        return (SoundEvent)EESoundEvents.BOOFLO_INFLATE.get();
    }

    protected SoundEvent getDeflateSound() {
        return (SoundEvent)EESoundEvents.BOOFLO_DEFLATE.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EESoundEvents.BOOFLO_CROAK.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EESoundEvents.BOOFLO_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EESoundEvents.BOOFLO_HURT.get();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    public static float getEatingOffsetProgress(float ticks) {
        return Mth.m_14154_((float)(2.0f * Mth.m_14187_((float)(ticks / 20.0f)) - 1.0f));
    }

    public static class GroundMoveHelperController
    extends MoveControl {
        private final Booflo booflo;
        private float yRot;
        public boolean isAggressive;

        public GroundMoveHelperController(Booflo booflo) {
            super((Mob)booflo);
            this.booflo = booflo;
            this.yRot = (float)((double)(180.0f * booflo.m_146908_()) / Math.PI);
        }

        public void setDirection(float yRot, boolean aggressive) {
            this.yRot = yRot;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            if (!this.booflo.hasCaughtPuffBug()) {
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
                this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            }
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21051_(Attributes.f_22279_).m_22135_()));
                    if (this.booflo.hopDelay == 0 && this.booflo.isEndimationPlaying(EEPlayableEndimations.BOOFLO_HOP) && this.booflo.getAnimationTick() == 10) {
                        this.booflo.m_21569_().m_24901_();
                        this.booflo.hopDelay = this.booflo.getDefaultGroundHopDelay();
                    } else {
                        this.booflo.f_20900_ = 0.0f;
                        this.booflo.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_(0.0f);
                }
            }
        }
    }

    public static class FlyingMoveController
    extends MoveControl {
        private final Booflo booflo;

        public FlyingMoveController(Booflo booflo) {
            super((Mob)booflo);
            this.booflo = booflo;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.booflo.m_21573_().m_26571_()) {
                if (this.booflo.hasAggressiveAttackTarget()) {
                    Position pos = this.booflo.getPos();
                    Vec3 vec3d = new Vec3(this.f_24975_ - pos.m_7096_(), this.f_24976_ - pos.m_7098_(), this.f_24977_ - pos.m_7094_());
                    this.booflo.m_146922_(this.m_24991_(this.booflo.m_146908_(), (float)(Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) * 57.2957763671875 - 90.0), 10.0f));
                    this.booflo.f_20883_ = this.booflo.m_146908_();
                    this.booflo.f_20885_ = this.booflo.m_146908_();
                    float f1 = (float)(2.0 * this.booflo.m_21051_(Attributes.f_22279_).m_22135_());
                    float f2 = Mth.m_14179_((float)0.125f, (float)this.booflo.m_6113_(), (float)f1);
                    this.booflo.m_7910_(f2);
                } else {
                    Vec3 vec3d = new Vec3(this.f_24975_ - this.booflo.m_20185_(), this.f_24976_ - this.booflo.m_20186_(), this.f_24977_ - this.booflo.m_20189_());
                    double d0 = vec3d.m_82553_();
                    double d1 = vec3d.f_82480_ / d0;
                    float f = (float)(Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) * 57.2957763671875) - 90.0f;
                    this.booflo.m_146922_(this.m_24991_(this.booflo.m_146908_(), f, 10.0f));
                    this.booflo.f_20883_ = this.booflo.m_146908_();
                    this.booflo.f_20885_ = this.booflo.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.booflo.m_21051_(Attributes.f_22279_).m_22135_());
                    float f2 = Mth.m_14179_((float)0.125f, (float)this.booflo.m_6113_(), (float)f1);
                    this.booflo.m_7910_(f2);
                    double d3 = Math.cos(this.booflo.m_146908_() * ((float)Math.PI / 180));
                    double d4 = Math.sin(this.booflo.m_146908_() * ((float)Math.PI / 180));
                    double d5 = Math.sin((double)(this.booflo.f_19797_ + this.booflo.m_19879_()) * 0.75) * 0.05;
                    if (!this.booflo.m_20069_()) {
                        float f3 = -((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)Mth.m_14116_((float)((float)(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_)))) * 57.2957763671875));
                        f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)-85.0f, (float)85.0f);
                        this.booflo.m_146926_(this.m_24991_(this.booflo.m_146909_(), f3, 5.0f));
                    }
                    this.booflo.m_20256_(this.booflo.m_20184_().m_82520_(0.0, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.02, 0.0));
                }
                this.booflo.setMovingInAir(true);
            } else {
                this.booflo.m_7910_(0.0f);
                this.booflo.setMovingInAir(false);
            }
        }
    }

    static class FlyingLookController
    extends LookControl {
        private final int angleLimit;

        public FlyingLookController(Booflo booflo, int angleLimit) {
            super((Mob)booflo);
            this.angleLimit = angleLimit;
        }

        public void m_8128_() {
            if (this.f_186068_ > 0) {
                --this.f_186068_;
                this.m_180896_().ifPresent(angle -> {
                    this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, angle.floatValue() + 20.0f, this.f_24938_);
                });
                this.m_180897_().ifPresent(angle -> this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), angle.floatValue() + 10.0f, this.f_24939_)));
            } else {
                if (this.f_24937_.m_21573_().m_26571_()) {
                    this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 5.0f));
                }
                this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, this.f_24938_);
            }
            float wrappedDegrees = Mth.m_14177_((float)(this.f_24937_.f_20885_ - this.f_24937_.f_20883_));
            if (wrappedDegrees < (float)(-this.angleLimit)) {
                this.f_24937_.f_20883_ -= 4.0f;
            } else if (wrappedDegrees > (float)this.angleLimit) {
                this.f_24937_.f_20883_ += 4.0f;
            }
            if (((Booflo)this.f_24937_).isEndimationPlaying(EEPlayableEndimations.BOOFLO_CHARGE)) {
                this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 10.0f));
            }
        }
    }
}

