/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.IPlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WingsDataUpdatePacket {
    final UUID uuid;
    long lastFlapTime;
    int dashTicks;
    boolean isFlying;

    public WingsDataUpdatePacket(Player player) {
        this.uuid = player.m_20148_();
        player.getCapability(IPlayerData.INSTANCE).ifPresent(d -> {
            this.lastFlapTime = d.getLastFlapTime(player);
            this.dashTicks = d.getDashTicks(player);
            this.isFlying = d.isFlying(player);
        });
    }

    public WingsDataUpdatePacket(UUID uuid, long lastFlapTime, int dashTicks, boolean isFlying) {
        this.uuid = uuid;
        this.lastFlapTime = lastFlapTime;
        this.dashTicks = dashTicks;
        this.isFlying = isFlying;
    }

    public static void encode(WingsDataUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
        buffer.writeLong(object.lastFlapTime);
        buffer.writeInt(object.dashTicks);
        buffer.writeBoolean(object.isFlying);
    }

    public static WingsDataUpdatePacket decode(FriendlyByteBuf buffer) {
        return new WingsDataUpdatePacket(buffer.m_130259_(), buffer.readLong(), buffer.readInt(), buffer.readBoolean());
    }

    public static void consume(WingsDataUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            Player p = world.m_46003_(packet.uuid);
            if (p != null && p != Minecraft.m_91087_().f_91074_) {
                p.getCapability(IPlayerData.INSTANCE, null).ifPresent(d -> {
                    if (packet.isFlying && !d.isFlying(p)) {
                        d.startFlying(p);
                    } else if (!packet.isFlying && d.isFlying(p)) {
                        d.stopFlying(p);
                    }
                    d.setLastFlapTime(packet.lastFlapTime);
                    d.setDashTicks(packet.dashTicks);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

