/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.api.ritual.IRitualItemProvider;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.block.SingleItemTile;
import elucent.eidolon.common.tile.IBurner;
import elucent.eidolon.network.ExtinguishEffectPacket;
import elucent.eidolon.network.FlameEffectPacket;
import elucent.eidolon.network.IgniteEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualCompletePacket;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.RitualRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class BrazierTileEntity
extends SingleItemTile
implements IBurner {
    boolean burning = false;
    int findingCounter = 0;
    int stepCounter = 0;
    Ritual ritual = null;
    int step = 0;
    boolean ritualDone = false;

    public BrazierTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.BRAZIER_TILE_ENTITY.get(), pos, state);
    }

    public BrazierTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        super.onDestroyed(state, pos);
        if (!this.stack.m_41619_() && this.f_58857_ != null) {
            Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.f_58857_ != null) {
            if (this.burning && player.m_6144_() && player.m_21120_(hand).m_41619_()) {
                this.extinguish();
                return InteractionResult.SUCCESS;
            }
            if (!this.burning && player.m_21120_(hand).m_41619_() && !this.stack.m_41619_()) {
                player.m_36356_(this.stack);
                this.stack = ItemStack.f_41583_;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
            boolean canBurn = this.canStartBurning();
            if (canBurn && player.m_21120_(hand).m_41720_() instanceof FlintAndSteelItem) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.startBurning();
                return InteractionResult.SUCCESS;
            }
            if (!player.m_21120_(hand).m_41619_() && this.stack.m_41619_()) {
                this.stack = player.m_21120_(hand).m_41777_();
                this.stack.m_41764_(1);
                player.m_21120_(hand).m_41774_(1);
                if (player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean canStartBurning() {
        return !this.burning && !this.stack.m_41619_();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.burning = tag.m_128471_("burning");
        this.step = tag.m_128451_("step");
        this.ritualDone = tag.m_128471_("ritualDone");
        if (this.burning && tag.m_128441_("ritual")) {
            ResourceLocation rid = new ResourceLocation(tag.m_128461_("ritual"));
            this.ritual = RitualRegistry.find(rid);
            if (this.ritual == null && this.f_58857_ != null) {
                BrazierTileEntity.getRitualRecipes(this.f_58857_).stream().filter(r -> r.id.equals((Object)rid)).findFirst().ifPresent(r -> {
                    this.ritual = r.getRitual();
                });
            }
        } else {
            this.ritual = null;
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("burning", this.burning);
        if (this.ritual != null) {
            tag.m_128359_("ritual", this.ritual.getRegistryName().toString());
        }
        tag.m_128405_("step", this.step);
        tag.m_128379_("ritualDone", this.ritualDone);
    }

    protected void complete() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.ritual != null) {
                Networking.sendToTracking(this.f_58857_, this.f_58858_.m_6630_(2), new RitualCompletePacket(this.f_58858_.m_6630_(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToTracking(this.f_58857_, this.f_58858_, new ExtinguishEffectPacket(this.f_58858_));
            this.sync();
        }
        this.ritual = null;
    }

    protected void extinguish() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.ritual != null) {
                Networking.sendToTracking(this.f_58857_, this.f_58858_.m_6630_(2), new FlameEffectPacket(this.f_58858_.m_6630_(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToTracking(this.f_58857_, this.f_58858_, new ExtinguishEffectPacket(this.f_58858_));
            this.sync();
        }
        this.ritual = null;
    }

    @Override
    public void startBurning(Player player, @NotNull Level world, BlockPos pos) {
        this.startBurning();
    }

    public void startBurning() {
        this.burning = true;
        this.findingCounter = 0;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Networking.sendToTracking(this.f_58857_, this.f_58858_, new IgniteEffectPacket(this.f_58858_, 1.0f, 0.5f, 0.25f));
            this.sync();
        }
    }

    protected void setRitual(Ritual ritual) {
        this.ritual = ritual;
        if (ritual == null) {
            this.extinguish();
        } else {
            this.stepCounter = 0;
            this.step = 0;
            this.ritualDone = false;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                Networking.sendToTracking(this.f_58857_, this.f_58858_.m_6630_(2), new FlameEffectPacket(this.f_58858_.m_6630_(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
                this.sync();
            }
        }
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.burning && this.findingCounter < 80 && this.ritual == null) {
            float progress = (float)(this.findingCounter - 40) / 40.0f;
            if (progress >= 0.0f) {
                for (int i = 0; i < 8; ++i) {
                    float angle = progress * (float)Math.PI / 4.0f + (float)i * (float)Math.PI / 4.0f;
                    float radius = 0.625f * Mth.m_14031_((float)(4.0f * angle));
                    float x = (float)this.m_58899_().m_123341_() + 0.5f + Mth.m_14031_((float)(angle += 0.7853982f)) * radius;
                    float y = (float)this.m_58899_().m_123342_() + 0.875f;
                    float z = (float)this.m_58899_().m_123343_() + 0.5f + Mth.m_14089_((float)angle) * radius;
                    Particles.create(EidolonParticles.WISP_PARTICLE).setAlpha(0.25f * progress, 0.0f).setScale(0.125f, 0.0625f).setLifetime(20).setColor(1.0f, 0.5f, 0.25f, 1.0f, 0.25f, 0.375f).spawn(this.f_58857_, x, y, z);
                }
            }
            ++this.findingCounter;
            if (this.findingCounter == 80) {
                List<RitualRecipe> recipes = BrazierTileEntity.getRitualRecipes(this.f_58857_);
                recipes.stream().filter(recipe -> recipe.matches(this, this.f_58857_)).findFirst().ifPresentOrElse(recipe -> {
                    this.setRitual(recipe.getRitualWithRequirements());
                    this.stack = ItemStack.f_41583_;
                    this.findingCounter = 81;
                }, () -> {
                    this.ritualDone = true;
                    this.extinguish();
                });
            }
        }
        if (this.burning && this.ritual != null && !this.ritualDone) {
            ++this.stepCounter;
            if (this.stepCounter == 40) {
                Ritual.SetupResult result = this.ritual.setup(this.f_58857_, this.f_58858_, this.step);
                if (result == Ritual.SetupResult.SUCCEED) {
                    this.ritualDone = true;
                    if (!this.f_58857_.f_46443_) {
                        this.sync();
                    }
                    if (this.ritual.start(this.f_58857_, this.f_58858_) == Ritual.RitualResult.TERMINATE) {
                        this.complete();
                    }
                } else if (result == Ritual.SetupResult.FAIL && !this.f_58857_.f_46443_) {
                    this.extinguish();
                } else if (!this.f_58857_.f_46443_) {
                    this.stepCounter = 0;
                    ++this.step;
                    this.sync();
                }
            }
        }
        if (this.burning && this.ritual != null && this.ritualDone && this.ritual.tick(this.f_58857_, this.f_58858_) == Ritual.RitualResult.TERMINATE) {
            this.complete();
        }
        if (this.f_58857_.f_46443_ && this.burning) {
            float x = (float)this.m_58899_().m_123341_() + 0.5f;
            float y = this.m_58899_().m_123342_() + 1;
            float z = (float)this.m_58899_().m_123343_() + 0.5f;
            float r = this.ritual == null ? 1.0f : this.ritual.getRed();
            float g = this.ritual == null ? 0.5f : this.ritual.getGreen();
            float b = this.ritual == null ? 0.25f : this.ritual.getBlue();
            Particles.create(EidolonParticles.FLAME_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.3125f, 0.125f).setLifetime(20).randomOffset(0.25, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(this.f_58857_, x, y, z);
            if (this.f_58857_.f_46441_.m_188503_(5) == 0) {
                Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.125f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.1f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(this.f_58857_, x, (double)y + 0.125, z);
            }
            if (this.f_58857_.f_46441_.m_188503_(40) == 0) {
                Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(this.f_58857_, x, y, z);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.f_58858_.m_123341_() - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - 1), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 4), (double)(this.f_58858_.m_123343_() + 1));
    }

    public void providePedestalItems(List<ItemStack> pedestalItems, List<ItemStack> focusItems) {
        Ritual.getTilesWithinAABB(IRitualItemProvider.class, this.f_58857_, Ritual.getDefaultBounds(this.f_58858_)).forEach(tile -> {
            if (tile instanceof IRitualItemFocus) {
                IRitualItemFocus provider = (IRitualItemFocus)tile;
                focusItems.add(provider.provide());
            } else {
                pedestalItems.add(tile.provide());
            }
        });
        focusItems.removeIf(ItemStack::m_41619_);
        pedestalItems.removeIf(ItemStack::m_41619_);
    }

    public static List<RitualRecipe> getRitualRecipes(Level world) {
        ArrayList<RitualRecipe> recipes = new ArrayList<RitualRecipe>();
        RecipeManager manager = world.m_7465_();
        for (RecipeType<? extends RitualRecipe> type : EidolonRecipes.ritualRecipeTypes) {
            recipes.addAll(manager.m_44013_(type));
        }
        return recipes;
    }
}

