/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.common.item.Tiers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ReversalPickItem
extends PickaxeItem {
    String loreTag = null;

    public ReversalPickItem(Item.Properties builderIn) {
        super((Tier)Tiers.MagicToolTier.INSTANCE, 1, -2.8f, builderIn);
        MinecraftForge.EVENT_BUS.addListener(ReversalPickItem::onStartBreak);
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (this.loreTag != null) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + ChatFormatting.ITALIC + I18n.m_118938_((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    @SubscribeEvent
    public static void onStartBreak(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_21205_().m_41720_() instanceof ReversalPickItem && event.getPosition().isPresent()) {
            float hardness = event.getState().m_60800_((BlockGetter)event.getEntity().f_19853_, (BlockPos)event.getPosition().get());
            float adjHardness = 1.0f / (hardness / 2.0f);
            float newSpeed = Mth.m_14116_((float)(event.getOriginalSpeed() * 0.25f)) * Mth.m_14116_((float)(hardness / adjHardness));
            event.setNewSpeed(newSpeed);
        }
    }
}

