/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.client.particle.RuneParticleData;
import elucent.eidolon.client.particle.RuneParticleRenderType;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RuneParticle
extends TextureSheetParticle {
    final Rune rune;
    final float[] hsv1 = new float[3];
    final float[] hsv2 = new float[3];

    public RuneParticle(ClientLevel world, RuneParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.m_107264_(x, y, z);
        this.rune = data.rune;
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.m_107257_(20);
        this.f_107226_ = -0.05f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        if ((double)this.hsv1[0] < 0.01) {
            this.hsv1[0] = this.hsv2[0];
        }
        if ((double)this.hsv1[1] < 0.01) {
            this.hsv1[1] = 0.01f;
        }
        this.updateTraits();
    }

    protected float getCoeff() {
        float t = ((float)this.f_107224_ + Minecraft.m_91087_().m_91297_()) / (float)this.f_107225_;
        t = Mth.m_14036_((float)t, (float)0.001f, (float)0.999f);
        float ic = (1.0f - t) * (1.0f - t);
        return 1.0f - (Mth.m_14031_((float)((float)Math.PI * 4 * t)) * ic * 0.5f - 0.7f * t + 0.7f);
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        float t = ((float)this.f_107224_ + Minecraft.m_91087_().m_91297_()) / (float)this.f_107225_;
        t = Mth.m_14036_((float)t, (float)0.001f, (float)0.999f);
        float ic = (1.0f - t) * (1.0f - t);
        this.f_107663_ = Mth.m_14179_((float)coeff, (float)0.125f, (float)0.0625f);
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = (float)Math.PI * Mth.m_14031_((float)(Mth.m_14089_((float)((float)Math.PI * 4 * t)) * ic)) / 8.0f;
        this.m_107271_(Mth.m_14179_((float)(coeff * coeff), (float)0.5f, (float)0.0f));
        float h = Mth.m_14189_((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.m_107253_(r, g, b);
    }

    public void m_5989_() {
        this.updateTraits();
        super.m_5989_();
        this.f_107215_ *= 0.98;
        this.f_107216_ *= 0.98;
        this.f_107217_ *= 0.98;
    }

    public void m_5744_(@NotNull VertexConsumer b, Camera info, float pticks) {
        Quaternionf quaternion;
        b = (Boolean)ClientConfig.BETTER_LAYERING.get() != false ? ClientEvents.getDelayedRender().m_6299_(RenderUtil.GLOWING_BLOCK_PARTICLE) : b;
        Vec3 vec3 = info.m_90583_();
        float f = (float)(Mth.m_14139_((double)pticks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pticks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pticks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = info.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)info.m_253121_());
            float f3 = Mth.m_14179_((float)pticks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(pticks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(pticks);
        Vector3f offX = new Vector3f((Vector3fc)avector3f[0]);
        Vector3f offY = new Vector3f((Vector3fc)avector3f[1]);
        offX.sub((Vector3fc)avector3f[2]);
        offX.mul(0.5f);
        offY.sub((Vector3fc)avector3f[3]);
        offY.mul(0.5f);
        TextureAtlasSprite aura = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("eidolon", "particle/aura"));
        for (int i = 0; i < 1; ++i) {
            b.m_5483_((double)avector3f[0].x() + (double)offX.x(), (double)avector3f[0].y() + (double)offX.y(), (double)avector3f[0].z() + (double)offX.z()).m_7421_(aura.m_118410_(), aura.m_118412_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.25f).m_85969_(j).m_5752_();
            b.m_5483_((double)avector3f[1].x() + (double)offY.x(), (double)avector3f[1].y() + (double)offY.y(), (double)avector3f[1].z() + (double)offY.z()).m_7421_(aura.m_118410_(), aura.m_118411_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.25f).m_85969_(j).m_5752_();
            b.m_5483_((double)avector3f[2].x() - (double)offX.x(), (double)avector3f[2].y() - (double)offX.y(), (double)avector3f[2].z() - (double)offX.z()).m_7421_(aura.m_118409_(), aura.m_118411_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.25f).m_85969_(j).m_5752_();
            b.m_5483_((double)avector3f[3].x() - (double)offY.x(), (double)avector3f[3].y() - (double)offY.y(), (double)avector3f[3].z() - (double)offY.z()).m_7421_(aura.m_118409_(), aura.m_118412_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * 0.25f).m_85969_(j).m_5752_();
        }
        b.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        b.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        b.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        b.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return RuneParticleRenderType.INSTANCE;
    }
}

