/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.volume;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.VolumeTransitionConfig;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.duck.DuckSoundEngine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundSource;

public class SmoothVolumeHandler {
    private static boolean active = false;
    private static boolean needsUpdating = false;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Map<SoundSource, Float> currentOverrides = new HashMap<SoundSource, Float>();

    public static void init() {
        if (active || !DynamicFPSConfig.INSTANCE.volumeTransitionSpeed().isActive()) {
            return;
        }
        active = true;
        Platform.getInstance().registerStartTickEvent(SmoothVolumeHandler::tickVolumes);
    }

    public static void onStateChange() {
        if (active) {
            needsUpdating = true;
        } else {
            for (SoundSource source : SoundSource.values()) {
                SmoothVolumeHandler.updateVolume(source);
            }
        }
    }

    public static float volumeMultiplier(SoundSource source) {
        if (!active) {
            return DynamicFPSMod.volumeMultiplier(source);
        }
        return currentOverrides.getOrDefault(source, Float.valueOf(1.0f)).floatValue();
    }

    private static void tickVolumes() {
        if (!needsUpdating) {
            return;
        }
        boolean didUpdate = false;
        VolumeTransitionConfig config = DynamicFPSConfig.INSTANCE.volumeTransitionSpeed();
        for (SoundSource source : SoundSource.values()) {
            float desired = DynamicFPSMod.volumeMultiplier(source);
            float current = currentOverrides.getOrDefault(source, Float.valueOf(1.0f)).floatValue();
            if (current == desired) continue;
            didUpdate = true;
            if (current < desired) {
                currentOverrides.put(source, Float.valueOf(Math.min(desired, current + config.getUp() / 20.0f)));
            } else {
                currentOverrides.put(source, Float.valueOf(Math.max(desired, current - config.getDown() / 20.0f)));
            }
            SmoothVolumeHandler.updateVolume(source);
        }
        if (!didUpdate) {
            needsUpdating = false;
        }
    }

    private static void updateVolume(SoundSource source) {
        ((DuckSoundEngine)SmoothVolumeHandler.minecraft.m_91106_().f_120349_).dynamic_fps$updateVolume(source);
    }
}

