/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl;

import dynamic_fps.impl.Constants;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.compat.ClothConfig;
import dynamic_fps.impl.compat.GLFW;
import dynamic_fps.impl.config.BatteryTrackerConfig;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.GraphicsState;
import dynamic_fps.impl.feature.battery.BatteryToast;
import dynamic_fps.impl.feature.battery.BatteryTracker;
import dynamic_fps.impl.feature.state.IdleHandler;
import dynamic_fps.impl.feature.state.OptionHolder;
import dynamic_fps.impl.feature.state.WindowObserver;
import dynamic_fps.impl.feature.volume.SmoothVolumeHandler;
import dynamic_fps.impl.service.ModCompat;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.BatteryUtil;
import dynamic_fps.impl.util.FallbackConfigScreen;
import dynamic_fps.impl.util.Localization;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.ModCompatHelper;
import dynamic_fps.impl.util.ResourceLocations;
import dynamic_fps.impl.util.Version;
import dynamic_fps.impl.util.duck.DuckLoadingOverlay;
import dynamic_fps.impl.util.duck.DuckScreen;
import java.util.ArrayList;
import net.lostluma.battery.api.State;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class DynamicFPSMod {
    private static Config config = Config.ACTIVE;
    private static PowerState state = PowerState.FOCUSED;
    private static boolean isForcingLowFPS = false;
    private static boolean isKeybindDisabled = false;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    private static WindowObserver window;
    private static long lastRender;
    private static boolean hasRenderedLastFrame;
    private static final boolean OVERLAY_OPTIMIZATION_ACTIVE;

    public static void init() {
        DynamicFPSMod.doInit();
        Platform platform = Platform.getInstance();
        Version version = platform.getModVersion("dynamic_fps").orElseThrow();
        Logging.getLogger().info("Dynamic FPS {} active on {}!", (Object)version, (Object)platform.getName());
    }

    public static boolean disabledByUser() {
        return isKeybindDisabled;
    }

    @Nullable
    public static WindowObserver getWindow() {
        return window;
    }

    public static boolean isDisabled() {
        return isKeybindDisabled || !DynamicFPSConfig.INSTANCE.enabled() || ModCompat.getInstance().isDisabled();
    }

    public static String whyIsTheModNotWorking() {
        ArrayList<String> results = new ArrayList<String>();
        if (isKeybindDisabled) {
            results.add("keybinding");
        }
        if (!DynamicFPSConfig.INSTANCE.enabled()) {
            results.add("mod config");
        }
        if (ModCompat.getInstance().isDisabled()) {
            results.add("another mod");
        }
        return String.join((CharSequence)", ", results);
    }

    public static void toggleDisabled() {
        isKeybindDisabled = !isKeybindDisabled;
        DynamicFPSMod.onStatusChanged(true);
    }

    public static void onConfigChanged() {
        DynamicFPSMod.doInit();
        DynamicFPSConfig.INSTANCE.save();
        DynamicFPSMod.checkForStateChanges();
    }

    public static Screen getConfigScreen(Screen parent) {
        if (!Platform.getInstance().isModLoaded(Constants.CLOTH_CONFIG_ID)) {
            return new FallbackConfigScreen(parent);
        }
        return ClothConfig.genConfigScreen(parent);
    }

    public static void onStatusChanged(boolean userInitiated) {
        if (userInitiated) {
            IdleHandler.onActivity();
        }
        DynamicFPSMod.checkForStateChanges();
    }

    public static PowerState powerState() {
        return state;
    }

    public static boolean isForcingLowFPS() {
        return isForcingLowFPS;
    }

    public static void toggleForceLowFPS() {
        isForcingLowFPS = !isForcingLowFPS;
        DynamicFPSMod.onStatusChanged(true);
    }

    public static void setWindow(long address) {
        IdleHandler.setWindow(address);
        window = new WindowObserver(address);
    }

    public static boolean checkForRender() {
        long currentTime = Util.m_137574_();
        long timeSinceLastRender = currentTime - lastRender;
        if (!DynamicFPSMod.checkForRender(timeSinceLastRender)) {
            return false;
        }
        lastRender = currentTime;
        return true;
    }

    public static int targetFrameRate() {
        return config.frameRateTarget();
    }

    public static boolean enableVsync() {
        return config.enableVsync();
    }

    public static float volumeMultiplier(SoundSource source) {
        return config.volumeMultiplier(source);
    }

    public static boolean shouldShowToasts() {
        return config.showToasts();
    }

    public static GraphicsState graphicsState() {
        return config.graphicsState();
    }

    public static boolean shouldShowLevels() {
        return DynamicFPSMod.isDisabled() || !DynamicFPSMod.isLevelCoveredByScreen() && !DynamicFPSMod.isLevelCoveredByOverlay();
    }

    public static void onBatteryChargeChanged(int before, int after) {
        if (before > 10 && after <= 10) {
            DynamicFPSMod.showNotification("battery_critical", "reminder");
        }
    }

    public static void onBatteryStatusChanged(State before, State after) {
        if (before == State.DISCHARGING && BatteryUtil.isCharging(after)) {
            DynamicFPSMod.showNotification("battery_charging", "charging");
        } else if (BatteryUtil.isCharging(before) && after == State.DISCHARGING) {
            DynamicFPSMod.showNotification("battery_draining", "draining");
        }
    }

    private static void doInit() {
        ModCompatHelper.init();
        BatteryTracker.init();
        IdleHandler.init();
        SmoothVolumeHandler.init();
    }

    private static boolean isLevelCoveredByScreen() {
        return DynamicFPSMod.minecraft.f_91080_ != null && ((DuckScreen)DynamicFPSMod.minecraft.f_91080_).dynamic_fps$rendersBackground();
    }

    private static void showNotification(String titleTranslationKey, String iconPath) {
        if (!DynamicFPSConfig.INSTANCE.batteryTracker().notifications()) {
            return;
        }
        MutableComponent title = Localization.localized("toast", titleTranslationKey, new Object[0]);
        ResourceLocation icon = ResourceLocations.of("dynamic_fps", "textures/battery/toast/" + iconPath + ".png");
        BatteryToast.queueToast((Component)title, icon);
    }

    private static boolean isLevelCoveredByOverlay() {
        return OVERLAY_OPTIMIZATION_ACTIVE && minecraft.m_91265_() instanceof LoadingOverlay && ((DuckLoadingOverlay)minecraft.m_91265_()).dynamic_fps$isReloadComplete();
    }

    public static void handleStateChange(PowerState previous, PowerState current) {
        boolean enableVsync;
        if (Constants.DEBUG) {
            Logging.getLogger().info("State changed from {} to {}.", (Object)previous, (Object)current);
        }
        Config before = config;
        config = DynamicFPSConfig.INSTANCE.get(current);
        GLFW.applyWorkaround();
        hasRenderedLastFrame = false;
        if (config.runGarbageCollector()) {
            System.gc();
        }
        SmoothVolumeHandler.onStateChange();
        if (before.graphicsState() != config.graphicsState()) {
            if (before.graphicsState() == GraphicsState.DEFAULT) {
                OptionHolder.copyOptions(DynamicFPSMod.minecraft.f_91066_);
            }
            OptionHolder.applyOptions(DynamicFPSMod.minecraft.f_91066_, config.graphicsState());
        }
        boolean bl = enableVsync = current != PowerState.FOCUSED ? config.enableVsync() : ((Boolean)DynamicFPSMod.minecraft.f_91066_.m_231817_().m_231551_()).booleanValue();
        if (enableVsync != before.enableVsync()) {
            minecraft.m_91268_().m_85409_(enableVsync);
        }
    }

    private static void checkForStateChanges() {
        if (window == null) {
            return;
        }
        if (minecraft.m_18695_()) {
            DynamicFPSMod.checkForStateChanges0();
        } else {
            minecraft.m_6937_(DynamicFPSMod::checkForStateChanges0);
        }
    }

    private static void checkForStateChanges0() {
        BatteryTrackerConfig batteryTracking = DynamicFPSConfig.INSTANCE.batteryTracker();
        PowerState current = DynamicFPSMod.isDisabled() ? PowerState.FOCUSED : (isForcingLowFPS ? PowerState.UNFOCUSED : (window.isFocused() ? (IdleHandler.isIdle() ? PowerState.ABANDONED : (batteryTracking.enabled() && batteryTracking.switchStates() && BatteryTracker.status() == State.DISCHARGING ? PowerState.UNPLUGGED : PowerState.FOCUSED)) : (window.isHovered() ? PowerState.HOVERED : (!window.isIconified() ? PowerState.UNFOCUSED : PowerState.INVISIBLE))));
        if (state != current) {
            PowerState previous = state;
            state = current;
            DynamicFPSMod.handleStateChange(previous, current);
        }
    }

    private static boolean checkForRender(long timeSinceLastRender) {
        int frameRateTarget = DynamicFPSMod.targetFrameRate();
        if (frameRateTarget == 0) {
            return false;
        }
        if (frameRateTarget == 260) {
            return true;
        }
        if (!hasRenderedLastFrame) {
            hasRenderedLastFrame = true;
            return true;
        }
        long frameTime = 1000 / frameRateTarget;
        return timeSinceLastRender >= frameTime;
    }

    static {
        hasRenderedLastFrame = false;
        OVERLAY_OPTIMIZATION_ACTIVE = !ModCompat.getInstance().disableOverlayOptimization();
    }
}

