/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.block;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.server.block.DrumBlockEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.misc.DISoundRegistry;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DrumBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty COMMAND = IntegerProperty.m_61631_((String)"command", (int)0, (int)2);
    private static Random random = new Random();

    public DrumBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60978_(1.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COMMAND, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> context) {
        context.m_61104_(new Property[]{COMMAND, POWERED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        int currentCommand = (Integer)state.m_61143_((Property)COMMAND);
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)COMMAND));
        int count = this.issueCommand(level, pos, currentCommand, player.m_20148_());
        if (count > 0) {
            player.m_5661_((Component)Component.m_237110_((String)("message.domesticationinnovation.drum_command_" + currentCommand), (Object[])new Object[]{count}), true);
        }
        player.m_5496_((SoundEvent)DISoundRegistry.DRUM.get(), 3.0f, 0.3f + 0.4f * random.nextFloat());
        level.m_142346_((Entity)player, GameEvent.f_223699_, pos);
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (livingEntity != null && blockentity instanceof DrumBlockEntity) {
            DrumBlockEntity drum = (DrumBlockEntity)blockentity;
            drum.setPlacerUUID(livingEntity.m_20148_());
        }
    }

    public int issueCommand(Level level, BlockPos pos, int command, UUID issuer) {
        int count = 0;
        if (issuer != null) {
            Predicate<Entity> tames = animal -> TameableUtils.isTamed((Entity)((LivingEntity)animal)) && TameableUtils.getOwnerUUIDOf(animal) != null && TameableUtils.getOwnerUUIDOf(animal).equals(issuer);
            AABB area = new AABB(pos.m_7918_(-32, -32, -32), pos.m_7918_(32, 32, 32));
            for (Animal animal2 : level.m_6443_(Animal.class, area, EntitySelector.f_20408_.and(tames))) {
                if (animal2 instanceof IComandableMob) {
                    ((IComandableMob)animal2).setCommand(command);
                    ++count;
                }
                if (animal2 instanceof TamableAnimal && command != 0) {
                    ((TamableAnimal)animal2).m_21839_(command == 1);
                    ((TamableAnimal)animal2).m_21837_(command == 1);
                    if (!(animal2 instanceof IComandableMob)) {
                        ++count;
                    }
                }
                animal2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60, 0));
            }
        }
        return count;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean b) {
        boolean flag = level.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                UUID uuid = null;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof DrumBlockEntity) {
                    DrumBlockEntity drum = (DrumBlockEntity)blockEntity;
                    uuid = drum.getPlacerUUID();
                }
                this.issueCommand(level, pos, (Integer)state.m_61143_((Property)COMMAND), uuid);
                level.m_5594_(null, pos, (SoundEvent)DISoundRegistry.DRUM.get(), SoundSource.BLOCKS, 3.0f, 0.3f + 0.4f * random.nextFloat());
                level.m_142346_(null, GameEvent.f_223699_, pos);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float f) {
        entity.m_5496_((SoundEvent)DISoundRegistry.DRUM.get(), 3.0f, 0.6f + 0.4f * random.nextFloat());
        super.m_142072_(level, state, pos, entity, f);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DrumBlockEntity(pos, state);
    }
}

