/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.network.server;

import com.illusivesoulworks.diet.client.DietClientPacketReceiver;
import com.illusivesoulworks.diet.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record SPacketGroups(CompoundTag groups, Map<Item, Set<String>> generated) {
    public static void encode(SPacketGroups msg, FriendlyByteBuf buf) {
        CompoundTag compoundNBT = new CompoundTag();
        for (Map.Entry<Item, Set<String>> entry : msg.generated().entrySet()) {
            ListTag listNBT = new ListTag();
            for (String s : entry.getValue()) {
                listNBT.add((Object)StringTag.m_129297_((String)s));
            }
            compoundNBT.m_128365_(Objects.requireNonNull(Services.REGISTRY.getItemKey(entry.getKey())).toString(), (Tag)listNBT);
        }
        buf.m_130079_(compoundNBT);
        buf.m_130079_(msg.groups());
    }

    public static SPacketGroups decode(FriendlyByteBuf buf) {
        CompoundTag compoundNBT = buf.m_130260_();
        HashMap<Item, Set<String>> generated = new HashMap<Item, Set<String>>();
        if (compoundNBT != null) {
            for (String name : compoundNBT.m_128431_()) {
                Item item = Services.REGISTRY.getItem(new ResourceLocation(name)).orElse(null);
                if (item == null) continue;
                ListTag listNBT = compoundNBT.m_128437_(name, 8);
                HashSet<String> found = new HashSet<String>();
                for (Tag nbt : listNBT) {
                    String entry = nbt.m_7916_();
                    found.add(entry);
                }
                generated.put(item, found);
            }
        }
        return new SPacketGroups(buf.m_130260_(), generated);
    }

    public static void handle(SPacketGroups msg) {
        DietClientPacketReceiver.handleGroups(msg.groups(), msg.generated());
    }
}

