/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropdailyweather;

import cool.bot.botslib.util.RNG;
import cool.bot.dewdropdailyweather.Config;
import cool.bot.dewdropdailyweather.DewDropDailyWeather;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TickEventHandler {
    public static List<WeatherEvent> schedule = TickEventHandler.updateSchedule();

    private static ArrayList<WeatherEvent> updateSchedule() {
        ArrayList<Integer> times = new ArrayList<Integer>(List.copyOf(Config.weatherTimes));
        List<List<Integer>> timesRanges = List.copyOf(Config.weatherRanges);
        List<List<Integer>> weightss = List.copyOf(Config.weatherWeights);
        List<List<String>> pools = List.copyOf(Config.weatherOptions);
        int events = times.size();
        ArrayList<WeatherEvent> trueSchedule = new ArrayList<WeatherEvent>(List.of());
        for (int i = 0; i < events; ++i) {
            if (!timesRanges.isEmpty()) {
                times.set(i, (Integer)times.get(i) + RNG.irandRange((int)timesRanges.get(i).get(0), (int)timesRanges.get(i).get(1)));
            }
            List<String> cpool = pools.get(i);
            List<Integer> cweights = weightss.get(i);
            String weatherType = (String)RNG.weightedChoice(cpool, cweights);
            trueSchedule.add(new WeatherEvent((Integer)times.get(i), weatherType));
        }
        trueSchedule.sort(Comparator.comparingInt(WeatherEvent::getTime));
        return trueSchedule;
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerLevel level = event.getServer().m_129783_();
            if (!level.m_46469_().m_46207_(GameRules.f_46150_) || !level.m_46469_().m_46207_(GameRules.f_46140_)) {
                return;
            }
            int dayTime = (int)level.m_46468_() % 24000;
            if (dayTime == 1) {
                schedule = TickEventHandler.updateSchedule();
                if (Config.logSchedule) {
                    TickEventHandler.logSchedule(schedule);
                }
            } else if (schedule.stream().anyMatch(weatherEvent -> weatherEvent.getTime() == dayTime)) {
                String weatherType = schedule.stream().filter(weatherEvent -> weatherEvent.getTime() == dayTime).findFirst().get().getWeather();
                if (Config.logSchedule) {
                    DewDropDailyWeather.LOGGER.info("Current Weather: {}", (Object)weatherType);
                }
                switch (weatherType) {
                    case "clear": {
                        level.m_8606_(0, Integer.MAX_VALUE, false, false);
                        break;
                    }
                    case "rain": {
                        level.m_8606_(0, Integer.MAX_VALUE, true, false);
                        break;
                    }
                    case "storm": {
                        level.m_8606_(0, Integer.MAX_VALUE, true, true);
                        break;
                    }
                    case "ignore": {
                        break;
                    }
                }
            }
        }
    }

    private static void logSchedule(List<WeatherEvent> schedule) {
        DewDropDailyWeather.LOGGER.info("Today's Forecast:");
        for (WeatherEvent event : schedule) {
            DewDropDailyWeather.LOGGER.info("{}: {}", (Object)event.getTime(), (Object)event.getWeather());
        }
    }

    public static class WeatherEvent {
        public int time;
        public String weather;

        public int getTime() {
            return this.time;
        }

        public String getWeather() {
            return this.weather;
        }

        public WeatherEvent(int time, String weather) {
            this.time = time;
            this.weather = weather;
        }
    }
}

