/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client.gui;

import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;

public class DeathListEntryContainer
extends FlowLayout {
    protected final EventStream<OnSelected> selectedEvents = OnSelected.newStream();
    protected final Animation<Insets> slideAnimation = this.padding.animate(150, Easing.QUADRATIC, (Animatable)((Insets)this.padding.get()).add(0, 0, 5, 0));
    protected boolean focused = false;
    protected boolean selected = false;

    public DeathListEntryContainer() {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
    }

    public EventSource<OnSelected> onSelected() {
        return this.selectedEvents.source();
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        if (this.selected) {
            context.drawRectOutline(this.x, this.y, this.width, this.height, -5263441);
        }
    }

    protected void parentUpdate(float delta, int mouseX, int mouseY) {
        if (this.hovered || this.focused || this.selected) {
            this.slideAnimation.forwards();
        } else {
            this.slideAnimation.backwards();
        }
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        if (button == 0) {
            super.onMouseDown(mouseX, mouseY, button);
            this.select();
            return true;
        }
        return super.onMouseDown(mouseX, mouseY, button);
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        boolean success = super.onKeyPress(keyCode, scanCode, modifiers);
        if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
            return success;
        }
        this.select();
        return true;
    }

    private void select() {
        for (Component sibling : this.parent.children()) {
            if (sibling == this || !(sibling instanceof DeathListEntryContainer)) continue;
            DeathListEntryContainer container = (DeathListEntryContainer)sibling;
            container.selected = false;
        }
        this.selected = true;
        ((OnSelected)this.selectedEvents.sink()).onSelected(this);
        UISounds.playInteractionSound();
    }

    public boolean canFocus(Component.FocusSource source) {
        return true;
    }

    public void onFocusGained(Component.FocusSource source) {
        super.onFocusGained(source);
        this.focused = true;
    }

    public void onFocusLost() {
        super.onFocusLost();
        this.focused = false;
    }

    public static interface OnSelected {
        public void onSelected(DeathListEntryContainer var1);

        public static EventStream<OnSelected> newStream() {
            return new EventStream(subscribers -> container -> {
                for (OnSelected subscriber : subscribers) {
                    subscriber.onSelected(container);
                }
            });
        }
    }
}

