/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.lgearbox;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import me.duquee.createutilities.blocks.lgearbox.LShapedGearboxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class LShapedGearboxInstance
extends KineticBlockEntityInstance<GearboxBlockEntity> {
    protected final EnumMap<Direction, RotatingData> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public LShapedGearboxInstance(MaterialManager modelManager, GearboxBlockEntity tile) {
        super(modelManager, (KineticBlockEntity)tile);
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        this.updateSourceFacing();
        Material rotatingMaterial = this.getRotatingMaterial();
        Direction facing1 = (Direction)this.blockState.m_61143_((Property)LShapedGearboxBlock.FACING_1);
        this.putShaft((Material<RotatingData>)rotatingMaterial, tile, facing1, blockLight, skyLight);
        Direction facing2 = LShapedGearboxBlock.getAbsolute(facing1, (Direction)this.blockState.m_61143_((Property)LShapedGearboxBlock.FACING_2));
        this.putShaft((Material<RotatingData>)rotatingMaterial, tile, facing2, blockLight, skyLight);
    }

    private void putShaft(Material<RotatingData> rotatingMaterial, GearboxBlockEntity tile, Direction direction, int blockLight, int skyLight) {
        Direction.Axis axis = direction.m_122434_();
        Instancer shaft = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, direction);
        RotatingData key = (RotatingData)shaft.createInstance();
        key.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_253071_()).setRotationalSpeed(((GearboxBlockEntity)this.blockEntity).getSpeed()).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticBlockEntity)tile).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.keys.put(direction, key);
    }

    protected void updateSourceFacing() {
        if (((GearboxBlockEntity)this.blockEntity).hasSource()) {
            BlockPos source = ((GearboxBlockEntity)this.blockEntity).source.m_121996_((Vec3i)this.pos);
            this.sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingData> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.m_122434_();
            this.updateRotation(key.getValue(), axis, ((GearboxBlockEntity)this.blockEntity).getSpeed());
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

