/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.base.Objects;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class TrainPrediction
implements Comparable<TrainPrediction> {
    private static final String NBT_ENTRY_INDEX = "EntryIndex";
    private static final String NBT_STATION_NAME = "StationName";
    private static final String NBT_TITLE = "Title";
    private static final String NBT_SCHEDULED_TICKS = "ScheduledTicks";
    private static final String NBT_SCHEDULED_REFRESH_TIME = "ScheduledRefreshTime";
    private static final String NBT_REAL_TIME_TICKS = "RealTimeTicks";
    private static final String NBT_REAL_TIME_REFRESH_TIME = "RealTimeRefreshTime";
    private static final String NBT_CURRENT_TICKS_CORRECTION = "CurrentTicksCorrection";
    private static final String NBT_STOPOVERS = "Stopovers";
    private static final String NBT_CYCLE = "Cycle";
    private static final String NBT_CYCLE_TIME = "CycleTime";
    private static final String NBT_STAY_DURATION = "StayDuration";
    private static final String NBT_MIN_STAY_DURATION = "MinStayDuration";
    private final transient TrainData data;
    private final int entryIndex;
    private final String title;
    private String stationName;
    private int scheduledTicks;
    private long scheduleRefreshTime;
    private int realTimeTicks;
    private long realTimeRefreshTime;
    private long arrivalTicksCorrection;
    private long departureTicksCorrection;
    private List<String> stopovers = new ArrayList<String>();
    private int cycle;
    private long cycleTime;
    private final int stayDuration;
    private final int minStayDuration;
    private long previousScheduledArrivalTime;
    private long previousScheduledDepartureTime;
    private long previousRealTimeArrivalTime;
    private long previousRealTimeDepartureTime;
    private final Cache<Boolean> isCustomTitle = new Cache(() -> {
        if (this.getData().getPredictionsChronologically().isEmpty()) {
            return false;
        }
        TrainPrediction nextPrediction = this.getData().getPredictionsChronologically().get((this.getData().getPredictionsChronologically().indexOf(this) + 1) % this.getData().getPredictionsChronologically().size());
        return !this.getTitle().matches(nextPrediction.getStationName());
    });
    private final Cache<Boolean> isLastStopOfSection = new Cache(() -> {
        TrainTravelSection section = this.getSection();
        return section.isFinalStop(this);
    });
    private final Cache<StationTag> tagCache = new Cache(() -> GlobalSettings.getInstance().getOrCreateStationTagFor(this.stationName));
    private final Cache<TrainTravelSection> section;

    private TrainPrediction(TrainData data, int entryIndex, String stationName, String title, int ticks, int stayDuration, int minStayDuration) {
        this.entryIndex = entryIndex;
        this.data = data;
        this.title = title;
        this.stayDuration = stayDuration;
        this.minStayDuration = minStayDuration;
        this.stationName = stationName;
        this.realTimeTicks = ticks;
        this.realTimeRefreshTime = DragonLib.getCurrentWorldTime();
        this.section = new Cache(() -> data.getSectionForIndex(entryIndex));
        this.reset();
    }

    public TrainPrediction(TrainData data, int entryIndex, GlobalTrainDisplayData.TrainDeparturePrediction prediction, int stayDuration, int minStayDuration) {
        this(data, entryIndex, prediction.destination, prediction.scheduleTitle.getString(), prediction.ticks, stayDuration, minStayDuration);
    }

    public static TrainPrediction unpredictable(TrainData data) {
        CreateRailwaysNavigator.LOGGER.warn("Train " + data.getTrain().name.getString() + " (" + String.valueOf(data.getTrain().id) + ") is unpredictable!");
        return new TrainPrediction(data, -1, "", "", 0, 0, 0);
    }

    public void reset() {
        this.cycleTime = 0L;
        this.departureTicksCorrection = 0L;
        this.arrivalTicksCorrection = 0L;
        this.scheduledTicks = this.realTimeTicks;
        this.scheduleRefreshTime = this.realTimeRefreshTime;
    }

    public TrainData getData() {
        return this.data;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasCustomTitle() {
        return (Boolean)this.isCustomTitle.get();
    }

    public int getStayDuration() {
        return this.stayDuration;
    }

    public int getMinStayDuration() {
        return this.minStayDuration;
    }

    public List<String> getStopovers() {
        return this.stopovers;
    }

    public long getScheduleRefreshTime() {
        return this.scheduleRefreshTime;
    }

    public long getCycleTime() {
        return this.cycleTime;
    }

    public int getScheduledArrivalTicks() {
        return this.scheduledTicks;
    }

    public long getScheduledArrivalTime() {
        return this.getScheduleRefreshTime() + (long)this.getScheduledArrivalTicks() + this.getCycleTime();
    }

    public long getRealTimeRefreshTime() {
        return this.realTimeRefreshTime;
    }

    public int getRealTimeArrivalTicks() {
        return this.realTimeTicks;
    }

    private long getRealTimeArrivalTimeRaw() {
        return this.getRealTimeRefreshTime() + (long)this.getRealTimeArrivalTicks();
    }

    private long getArrivalTimeRawDeviation() {
        return this.getRealTimeArrivalTimeRaw() - this.getScheduledArrivalTime();
    }

    public long getRealTimeArrivalTime() {
        return this.getRealTimeArrivalTimeRaw() - this.arrivalTicksCorrection;
    }

    public long getArrivalTimeDeviation() {
        return this.getArrivalTimeRawDeviation() - this.arrivalTicksCorrection;
    }

    public int getScheduledDepartureTicks() {
        return this.getScheduledArrivalTicks() + this.getStayDuration();
    }

    public long getScheduledDepartureTime() {
        return this.getScheduledArrivalTime() + (long)this.getStayDuration();
    }

    public long getRealTimeDepartureTime() {
        return this.getRealTimeArrivalTime() + (long)this.getStayDuration() - this.departureTicksCorrection;
    }

    public long getDepartureTimeDeviation() {
        return this.getArrivalTimeDeviation() - this.departureTicksCorrection;
    }

    public int getLastTransitTime() {
        return this.data.getTransitTicks();
    }

    public long getBufferTime() {
        return Math.max(this.getStayDuration() - this.getMinStayDuration(), 0);
    }

    public long getBufferTimeLeft() {
        return this.getBufferTime() - this.data.waitingAtStationTicks();
    }

    public long getScheduledArrivalDay() {
        return this.getScheduledArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getScheduledDepartureDay() {
        return this.getScheduledDepartureDay() / DragonLib.ticksPerDay();
    }

    public long getRealTimeArrivalDay() {
        return this.getRealTimeArrivalTime() / DragonLib.ticksPerDay();
    }

    public long getRealTimeDepartureDay() {
        return this.getRealTimeDepartureTime() / DragonLib.ticksPerDay();
    }

    public void setStopovers(List<String> stopovers) {
        this.stopovers = stopovers;
    }

    public void nextCycle() {
        this.previousScheduledArrivalTime = this.getScheduledArrivalTime();
        this.previousScheduledDepartureTime = this.getScheduledDepartureTime();
        this.previousRealTimeArrivalTime = this.getRealTimeArrivalTime();
        this.previousRealTimeDepartureTime = this.getRealTimeDepartureTime();
        ++this.cycle;
        this.cycleTime += (long)this.data.getTotalDuration();
    }

    public int getCurrentCycle() {
        return this.cycle;
    }

    public long getPreviousScheduledArrivalTime() {
        return this.previousScheduledArrivalTime;
    }

    public long getPreviousScheduledDepartureTime() {
        return this.previousScheduledDepartureTime;
    }

    public long getPreviousRealTimeArrivalTime() {
        return this.previousRealTimeArrivalTime;
    }

    public long getPreviousRealTimeDepartureTime() {
        return this.previousRealTimeDepartureTime;
    }

    public int estimateCycleIn(int ticks) {
        return this.getCurrentCycle() + ticks / this.data.getTotalDuration();
    }

    public long getRuntime() {
        return DragonLib.getCurrentWorldTime() - this.getScheduleRefreshTime();
    }

    public boolean hasDepartedOnce() {
        return this.getCurrentCycle() > 0;
    }

    public boolean isArrivalDelayed() {
        return this.getRealTimeArrivalTime() - (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue() > this.getScheduledArrivalTime();
    }

    public boolean isDepartureDelayed() {
        return this.getRealTimeDepartureTime() - (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue() > this.getScheduledDepartureTime();
    }

    public boolean isAnyDelayed() {
        return this.isArrivalDelayed() || this.isDepartureDelayed();
    }

    public StationTag getStationTag() throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return (StationTag)this.tagCache.get();
    }

    public TrainTravelSection getSection() {
        TrainTravelSection sec = (TrainTravelSection)this.section.get();
        if (sec.isDefault()) {
            this.section.clear();
        }
        return sec;
    }

    public String getSectionDestinationText() {
        TrainTravelSection sec = (TrainTravelSection)this.section.get();
        if (sec.isDefault()) {
            this.section.clear();
        }
        return (Boolean)this.isLastStopOfSection.get() != false ? sec.nextSection().getDisplayText() : sec.getDisplayText();
    }

    public void updateRealTime(String stationName, int realTimeTicks) {
        this.isCustomTitle.clear();
        this.stationName = stationName == null ? this.stationName : stationName;
        this.realTimeRefreshTime = DragonLib.getCurrentWorldTime();
        this.realTimeTicks = realTimeTicks;
        List<TrainPrediction> prevPreds = this.data.getPredictionsChronologically();
        Optional<TrainPrediction> currentPrediction = this.data.getNextStopPrediction();
        this.arrivalTicksCorrection = 0L;
        this.departureTicksCorrection = 0L;
        if (this.data.isWaitingAtStation() && this.data.getCurrentScheduleIndex() == this.getEntryIndex()) {
            this.arrivalTicksCorrection = Math.min(this.data.waitingAtStationTicks(), (long)this.getStayDuration());
        }
        if (currentPrediction.isPresent()) {
            this.arrivalTicksCorrection = currentPrediction.get().arrivalTicksCorrection;
        }
        long tempDepartureCorrection = this.getBufferTime();
        long tempArrivalCorrection = 0L;
        for (int i = 0; i < prevPreds.size(); ++i) {
            TrainPrediction pred = prevPreds.get(i);
            tempArrivalCorrection += pred.getBufferTime();
            if (pred == this) break;
        }
        this.arrivalTicksCorrection += Math.min(tempArrivalCorrection, this.getArrivalTimeDeviation());
        this.departureTicksCorrection += Math.min(tempDepartureCorrection, this.getArrivalTimeDeviation());
        this.resetAllTimedCaches();
    }

    private void resetAllTimedCaches() {
        this.tagCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TrainPrediction)) return false;
        TrainPrediction o = (TrainPrediction)obj;
        if (this.scheduledTicks != o.scheduledTicks) return false;
        if (this.scheduleRefreshTime != o.scheduleRefreshTime) return false;
        if (this.entryIndex != o.entryIndex) return false;
        if (!this.stationName.equals(o.stationName)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduledTicks, this.scheduleRefreshTime, this.entryIndex, this.stationName});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean similarTo(Object obj) {
        if (!(obj instanceof TrainPrediction)) return false;
        TrainPrediction o = (TrainPrediction)obj;
        if (!this.stationName.equals(o.stationName)) return false;
        if (this.entryIndex != o.entryIndex) return false;
        return true;
    }

    public String toString() {
        return this.formattedText().getString();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag stopovers = new ListTag();
        List<String> stops = this.stopovers;
        for (String s : stops) {
            stopovers.add((Object)StringTag.m_129297_((String)s));
        }
        nbt.m_128405_(NBT_ENTRY_INDEX, this.entryIndex);
        nbt.m_128359_(NBT_STATION_NAME, this.stationName == null ? "" : this.stationName);
        nbt.m_128359_(NBT_TITLE, this.title == null ? "" : this.title);
        nbt.m_128405_(NBT_SCHEDULED_TICKS, this.scheduledTicks);
        nbt.m_128356_(NBT_SCHEDULED_REFRESH_TIME, this.scheduleRefreshTime);
        nbt.m_128405_(NBT_REAL_TIME_TICKS, this.realTimeTicks);
        nbt.m_128356_(NBT_REAL_TIME_REFRESH_TIME, this.realTimeRefreshTime);
        nbt.m_128356_(NBT_CURRENT_TICKS_CORRECTION, this.departureTicksCorrection);
        nbt.m_128365_(NBT_STOPOVERS, (Tag)stopovers);
        nbt.m_128405_(NBT_CYCLE, this.cycle);
        nbt.m_128356_(NBT_CYCLE_TIME, this.cycleTime);
        nbt.m_128405_(NBT_STAY_DURATION, this.stayDuration);
        nbt.m_128405_(NBT_MIN_STAY_DURATION, this.minStayDuration);
        return nbt;
    }

    public static TrainPrediction fromNbt(TrainData data, CompoundTag nbt) {
        TrainPrediction pred = new TrainPrediction(data, nbt.m_128451_(NBT_ENTRY_INDEX), nbt.m_128461_(NBT_STATION_NAME), nbt.m_128461_(NBT_TITLE), nbt.m_128451_(NBT_SCHEDULED_TICKS), nbt.m_128451_(NBT_STAY_DURATION), nbt.m_128451_(NBT_MIN_STAY_DURATION));
        pred.deserializeNbt(nbt);
        return pred;
    }

    protected void deserializeNbt(CompoundTag nbt) {
        this.scheduledTicks = nbt.m_128451_(NBT_SCHEDULED_TICKS);
        this.scheduleRefreshTime = nbt.m_128454_(NBT_SCHEDULED_REFRESH_TIME);
        this.realTimeTicks = nbt.m_128451_(NBT_REAL_TIME_TICKS);
        this.realTimeRefreshTime = nbt.m_128454_(NBT_REAL_TIME_REFRESH_TIME);
        this.departureTicksCorrection = nbt.m_128454_(NBT_CURRENT_TICKS_CORRECTION);
        this.stopovers = new ArrayList<String>(nbt.m_128437_(NBT_STOPOVERS, 8).stream().map(x -> x.m_7916_()).toList());
        this.cycle = nbt.m_128451_(NBT_CYCLE);
        this.cycleTime = nbt.m_128454_(NBT_CYCLE_TIME);
    }

    public Component formattedText() {
        return TextUtils.text((String)("[ " + this.entryIndex + " ]: ")).m_130940_(ChatFormatting.WHITE).m_7220_((Component)TextUtils.text((String)this.stationName).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("*" + this.getCurrentCycle())).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("CT: " + this.getRealTimeArrivalTime())).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("D: " + this.getArrivalTimeDeviation() + " / " + this.getDepartureTimeDeviation())).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("B: " + this.departureTicksCorrection)).m_130940_(ChatFormatting.DARK_GREEN)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("P: " + this.getScheduledArrivalTime())).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("S: " + this.getStayDuration())).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("Tr: " + this.getLastTransitTime())).m_130940_(ChatFormatting.DARK_RED)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("T: " + String.valueOf(this.getSection()))).m_130940_(ChatFormatting.RED)).m_7220_((Component)TextUtils.text((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)("Ti: " + this.title)).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    public void shiftTime(long l) {
        this.scheduleRefreshTime += l;
        this.realTimeRefreshTime += l;
    }

    @Override
    public int compareTo(TrainPrediction o) {
        return Long.compare(this.getScheduledArrivalTime(), o.getScheduledArrivalTime());
    }
}

