/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.lang;

import de.mrjulsen.crn.client.lang.ModTranslatableComponent;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Arrays;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;

public enum CustomLanguage implements StringRepresentable
{
    DEFAULT("defaut", "def"),
    ENGLISH("english", "en_us"),
    GERMAN("german", "de_de"),
    DUTCH("dutch", "nl_nl"),
    POLISH("polish", "pl_pl"),
    CHINESE_SIMPLIFIED("chinese_simplified", "zh_cn"),
    SAXON("saxon", "sxu"),
    BAVARIAN("bavarian", "bar"),
    SPANISH("spanish", "es_es"),
    RUSSIAN("russian", "ru_ru"),
    FRENCH("french", "fr_fr"),
    KOREAN("korean", "ko_kr"),
    SWEDISH("swedish", "sv_se"),
    PORTUGUESE("portuguese", "pt_pt"),
    BASQUE("basque", "eu_es"),
    ITALIAN("italian", "it_it"),
    JAPANESE("japanese", "ja_jp"),
    PORTUGUESE_BRAZILIAN("portuguese_brazilian", "pt_br"),
    UKRAINIAN("ukrainian", "uk_ua"),
    ARABIC("arabic", "ar_sa"),
    CZECH("czech", "cs_cz"),
    GERMAN_SWITZERLAND("german_switzerland", "de_ch"),
    ROMANIAN("romanian", "ro_ro"),
    TURKISH("turkish", "tr_tr");

    private String name;
    private String code;

    private CustomLanguage(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static CustomLanguage getByCode(String code) {
        return Arrays.stream(CustomLanguage.values()).filter(x -> x.getCode().equals(code)).findFirst().orElse(DEFAULT);
    }

    public static MutableComponent translate(String key) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            MutableComponent comp = MutableComponent.m_237204_((ComponentContents)new ModTranslatableComponent(key));
            if (comp.getString().equals(key)) {
                return TextUtils.translate((String)key);
            }
            return comp;
        }
        return TextUtils.translate((String)key);
    }

    public static MutableComponent translate(String key, Object ... args) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            MutableComponent comp = MutableComponent.m_237204_((ComponentContents)new ModTranslatableComponent(key, args));
            if (comp.getString().equals(key)) {
                return TextUtils.translate((String)key, (Object[])args);
            }
            return comp;
        }
        return TextUtils.translate((String)key, (Object[])args);
    }

    public String m_7912_() {
        return this.code;
    }
}

