/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.SavedRoutesScreen;
import de.mrjulsen.crn.client.gui.screen.ScheduleBoardScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractNotificationPopup;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModDestinationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.gui.widgets.SearchOptionButton;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutAdvancedSearchsettingsWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutDepartureInWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutTrainGroupsWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutTransferTimeWidget;
import de.mrjulsen.crn.client.gui.widgets.notifications.NotificationTrainInitialization;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class NavigatorScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private boolean initialized = false;
    private int angle = 0;
    private DLCreateIconButton locationButton;
    private DLCreateIconButton searchButton;
    private DLCreateIconButton globalSettingsButton;
    private DLEditBox fromBox;
    private DLEditBox toBox;
    private RouteViewer routeViewer;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private ModDestinationSuggestions destinationSuggestions;
    private AbstractNotificationPopup notificationPopup;
    private UserSettings userSettings;
    private final Collection<ClientRoute> routes;
    private final List<StationTag> stationNames;
    private String stationFrom;
    private String stationTo;
    private final NavigatorScreen instance;
    private boolean isLoadingRoutes;
    private boolean generatingRouteEntries;
    private final MutableComponent searchingText;
    private final MutableComponent noConnectionsText;
    private final MutableComponent notSearchedText;
    private final MutableComponent errorTitle;
    private final MutableComponent startEndEqualText;
    private final MutableComponent startEndNullText;
    private final MutableComponent tooltipSearch;
    private final MutableComponent tooltipLocation;
    private final MutableComponent tooltipSwitch;
    private final MutableComponent tooltipGlobalSettings;
    private final MutableComponent tooltipSavedRoutes;
    private final MutableComponent tooltipScheduleViewer;

    public NavigatorScreen(Screen lastScreen) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.title"), CreateDynamicWidgets.BarColor.GRAY);
        this.userSettings = new UserSettings(Minecraft.m_91087_().f_91074_.m_20148_(), false);
        this.routes = new ArrayList<ClientRoute>();
        this.stationNames = new ArrayList<StationTag>();
        this.stationFrom = "";
        this.stationTo = "";
        this.isLoadingRoutes = false;
        this.generatingRouteEntries = false;
        this.searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
        this.noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
        this.notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
        this.errorTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.error_title");
        this.startEndEqualText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_equal");
        this.startEndNullText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_null");
        this.tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
        this.tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
        this.tooltipSwitch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.switch.tooltip");
        this.tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
        this.tooltipSavedRoutes = TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.title");
        this.tooltipScheduleViewer = TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.title");
        this.instance = this;
    }

    private void generateRouteEntries() {
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        this.clearRoutes();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public synchronized void clearRoutes() {
        this.routes.stream().forEach(x -> x.close());
        this.routes.clear();
    }

    private void switchButtonClick() {
        String fromInput = this.fromBox.m_94155_();
        String toInput = this.toBox.m_94155_();
        this.fromBox.m_94144_(toInput);
        this.toBox.m_94144_(fromInput);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setAllowedLayer(0);
        this.initialized = false;
        DataAccessor.getFromServer((Object)true, ModAccessorTypes.GET_ALL_STATIONS_AS_TAGS, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<StationTag>)names);
        });
        this.locationButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 195, this.guiTop + 20, 18, 18, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                DataAccessor.getFromServer((Object)((NavigatorScreen)NavigatorScreen.this).f_96541_.f_91074_.m_20183_(), ModAccessorTypes.GET_NEAREST_STATION, result -> {
                    if (result.tagName.isPresent()) {
                        NavigatorScreen.this.fromBox.m_94144_(result.tagName.get().get());
                    }
                });
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipLocation).assignedTo((AbstractWidget)this.locationButton));
        this.fromBox = this.addEditBox(this.guiLeft + 32 + 5, this.guiTop + 25, 157, 12, this.stationFrom, (Component)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationFrom = v;
            this.updateEditorSubwidgets(this.fromBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.fromBox.m_94199_(32);
        this.toBox = this.addEditBox(this.guiLeft + 32 + 5, this.guiTop + 47, 157, 12, this.stationTo, (Component)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationTo = v;
            this.updateEditorSubwidgets(this.toBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.toBox.m_94199_(32);
        if (this.f_96541_.f_91074_.m_20310_(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue())) {
            this.globalSettingsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 30, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()){

                public void m_5716_(double mouseX, double mouseY) {
                    super.m_5716_(mouseX, mouseY);
                    NavigatorScreen.this.f_96541_.m_91152_((Screen)new GlobalSettingsScreen((Screen)NavigatorScreen.this.instance));
                }
            });
            this.addTooltip(DLTooltip.of((FormattedText)this.tooltipGlobalSettings).assignedTo((AbstractWidget)this.globalSettingsButton));
        }
        DLCreateIconButton savedRoutes = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.MAP_PATH.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                NavigatorScreen.this.f_96541_.m_91152_((Screen)new SavedRoutesScreen((Screen)NavigatorScreen.this.instance));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSavedRoutes).assignedTo((AbstractWidget)savedRoutes));
        DLCreateIconButton scheduleBoardBtn = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 240 - 18 - 30, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.VERY_DETAILED.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                NavigatorScreen.this.f_96541_.m_91152_((Screen)new ScheduleBoardScreen((Screen)NavigatorScreen.this.instance, null));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipScheduleViewer).assignedTo((AbstractWidget)scheduleBoardBtn));
        DLIconButton btn = (DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, new Sprite(CRNGui.GUI, 64, 64, 55, 0, 9, 12), this.guiLeft + 176, this.guiTop + 33, 13, 14, (Component)TextUtils.empty(), b -> this.switchButtonClick()));
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSwitch).assignedTo((AbstractWidget)btn));
        btn.setBackColor(0);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.guiLeft + 240 - 8, this.guiTop + 88, 128, GuiAreaDefinition.empty());
        this.routeViewer = (RouteViewer)this.m_142416_((GuiEventListener)new RouteViewer((Screen)this, this.guiLeft + 3, this.guiTop + 88, 234, 128, (DLAbstractScrollBar<?>)scrollBar));
        this.m_142416_((GuiEventListener)scrollBar);
        DLUtils.doIfNotNull((Object)((Object)this.routeViewer), x -> x.displayRoutes((List<ClientRoute>)ImmutableList.copyOf(this.routes)));
        this.searchButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 195, this.guiTop + 42, 18, 18, (ScreenElement)AllIcons.I_MTD_SCAN){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                if (NavigatorScreen.this.stationFrom == null || NavigatorScreen.this.stationTo == null || NavigatorScreen.this.stationFrom.isBlank() || NavigatorScreen.this.stationTo.isBlank()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)NavigatorScreen.this.errorTitle, (Component)NavigatorScreen.this.startEndNullText));
                    return;
                }
                if (NavigatorScreen.this.stationFrom.equals(NavigatorScreen.this.stationTo)) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)NavigatorScreen.this.errorTitle, (Component)NavigatorScreen.this.startEndEqualText));
                    return;
                }
                NavigatorScreen.this.isLoadingRoutes = true;
                NavigatorScreen.this.clearRoutes();
                NavigatorScreen.this.routeViewer.clear();
                DataAccessor.getFromServer((Object)new ModAccessorTypes.NavigationData(NavigatorScreen.this.stationFrom, NavigatorScreen.this.stationTo, Minecraft.m_91087_().f_91074_.m_20148_()), ModAccessorTypes.NAVIGATE, routeList -> {
                    NavigatorScreen.this.routes.addAll((Collection<ClientRoute>)routeList);
                    NavigatorScreen.this.routeViewer.displayRoutes((List<ClientRoute>)ImmutableList.copyOf(NavigatorScreen.this.routes));
                    NavigatorScreen.this.isLoadingRoutes = false;
                    DataAccessor.getFromServer(null, ModAccessorTypes.ALL_TRAINS_INITIALIZED, result -> {
                        DLUtils.doIfNotNull((Object)((Object)NavigatorScreen.this.notificationPopup), x -> x.close());
                        if (!result.booleanValue()) {
                            NavigatorScreen.this.notificationPopup = (AbstractNotificationPopup)NavigatorScreen.this.m_142416_((GuiEventListener)new NotificationTrainInitialization(NavigatorScreen.this.instance, NavigatorScreen.this.guiLeft + 10, NavigatorScreen.this.guiTop + 247 - CreateDynamicWidgets.FooterSize.DEFAULT.size() - 20, 220, arg_0 -> ((NavigatorScreen)NavigatorScreen.this.instance).m_169411_(arg_0)));
                        }
                    });
                });
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipSearch).assignedTo((AbstractWidget)this.searchButton));
        int btnCount = 3;
        int btnWidth = 72;
        this.m_142416_((GuiEventListener)new SearchOptionButton(this.guiLeft + 3, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.departure_in"), () -> this.userSettings.navigationDepartureInTicks.toString(), b -> new FlyoutDepartureInWidget<GuiEventListener>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), this.userSettings, () -> this.userSettings.navigationDepartureInTicks, w -> {
            this.m_169411_((GuiEventListener)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        this.m_142416_((GuiEventListener)new SearchOptionButton(this.guiLeft + 3 + btnWidth, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.transfer_time"), () -> this.userSettings.navigationTransferTime.toString(), b -> new FlyoutTransferTimeWidget<GuiEventListener>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), this.userSettings, () -> this.userSettings.navigationTransferTime, w -> {
            this.m_169411_((GuiEventListener)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        this.m_142416_((GuiEventListener)new SearchOptionButton(this.guiLeft + 3 + btnWidth * 2, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups"), () -> this.userSettings.navigationExcludedTrainGroups.toString(), b -> new FlyoutTrainGroupsWidget<GuiEventListener>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), this.userSettings, () -> this.userSettings.navigationExcludedTrainGroups, w -> {
            this.m_169411_((GuiEventListener)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        DLIconButton moreSearchOptionsBtn = (DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, GuiIcons.ARROW_RIGHT.getAsSprite(16, 16), this.guiLeft + 240 - 3 - (240 - btnWidth * 3 - 6), this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, 240 - btnWidth * 3 - 6, 18, (Component)TextUtils.empty(), b -> new FlyoutAdvancedSearchsettingsWidget<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> this.m_142416_((GuiEventListener)x$0), w -> this.m_169411_((GuiEventListener)w)).open((IDragonLibWidget)b)));
        moreSearchOptionsBtn.setBackColor(0);
        this.generateRouteEntries();
        this.reloadUserSettings();
        this.initialized = true;
    }

    private void reloadUserSettings() {
        DataAccessor.getFromServer((Object)Minecraft.m_91087_().f_91074_.m_20148_(), ModAccessorTypes.GET_USER_SETTINGS, settings -> {
            this.userSettings = settings;
        });
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.updateEditorSubwidgetsInternal(field, this.getViableStations(this.stationNames));
    }

    protected void updateEditorSubwidgetsInternal(DLEditBox field, List<StationTag> list) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModDestinationSuggestions(this.f_96541_, (Screen)this, (EditBox)field, this.f_96547_, list, field.m_93694_() + 2 + field.y());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<StationTag> getViableStations(Collection<StationTag> src) {
        return src.stream().distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList();
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().m_94167_("");
        }
        this.destinationSuggestions = null;
    }

    public void m_86600_() {
        this.scroll.tickChaser();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.toBox.m_94204_() && !this.fromBox.m_94204_()) {
                this.clearSuggestions();
            }
        });
        DLUtils.doIfNotNull((Object)((Object)this.searchButton), x -> x.set_active(!this.isLoadingRoutes));
        super.m_86600_();
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.f_96541_.m_91296_();
        this.angle = (int)((float)this.angle + 6.0f * pPartialTick);
        if (this.angle > 360) {
            this.angle = 0;
        }
        this.renderNavigatorBackground(graphics, pMouseX, pMouseY, pPartialTick);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, 52, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y + 52 - 1, 238, 22, CreateDynamicWidgets.ContainerColor.GOLD);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + (y += 72), 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GRAY);
        CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 32, this.guiTop + 20, 159);
        CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 32, this.guiTop + 42, 159);
        GuiUtils.drawTexture((ResourceLocation)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 16), (int)7, (int)24, (int)0, (int)30, (int)7, (int)24, (int)64, (int)64);
        GuiUtils.drawTexture((ResourceLocation)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 16 + 24), (int)7, (int)24, (int)7, (int)30, (int)7, (int)24, (int)64, (int)64);
        if (!this.isLoadingRoutes && !this.generatingRouteEntries) {
            if (this.routes == null) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (FormattedText)this.notSearchedText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                ModGuiIcons.INFO.render(graphics, this.guiLeft + 120 - 8, this.guiTop + 123);
            } else if (this.routes.isEmpty()) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (FormattedText)this.noConnectionsText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                AllIcons.I_ACTIVE.render(graphics.graphics(), this.guiLeft + 120 - 8, this.guiTop + 123);
            }
        } else {
            double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
            double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (FormattedText)this.searchingText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            AllIcons.I_MTD_SCAN.render(graphics.graphics(), (int)((double)(this.guiLeft + 120 - 8) + offsetX), (int)((double)(this.guiTop + 123) + offsetY));
        }
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_(0.0f, 0.0f, 500.0f);
            this.destinationSuggestions.render(graphics.graphics(), mouseX, mouseY);
            graphics.poseStack().m_85849_();
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

