/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.fuzes;

import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.index.CBCMenuTypes;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.fuzes.DelayedImpactFuzeContainer;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class DelayedImpactFuzeItem
extends FuzeItem
implements MenuProvider {
    public DelayedImpactFuzeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer && player.m_36326_()) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("FuzeTimer")) {
                tag.m_128405_("FuzeTimer", 20);
            }
            int timer = tag.m_128451_("FuzeTimer");
            CBCMenuTypes.SET_DELAYED_IMPACT_FUZE.open((ServerPlayer)player, this.m_5446_(), (MenuConstructor)this, buf -> {
                buf.m_130130_(timer);
                buf.m_130055_(new ItemStack((ItemLike)this));
            });
        }
        return super.m_7203_(level, player, hand);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        ItemStack stack = player.m_21205_();
        return DelayedImpactFuzeContainer.getServerMenu(windowId, playerInv, stack);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    @Override
    public boolean onProjectileImpact(ItemStack stack, AbstractCannonProjectile projectile, HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, boolean baseFuze) {
        int damage;
        if (baseFuze || impactResult.shouldRemove()) {
            return false;
        }
        CompoundTag tag = stack.m_41784_();
        int n = damage = tag.m_128441_("Damage") ? tag.m_128451_("Damage") : this.getFuzeDurability();
        if (damage > 0 && !tag.m_128441_("Activated")) {
            tag.m_128405_("Damage", --damage);
            float f = this.getDetonateChance();
            if (f > 0.0f && projectile.m_9236_().m_213780_().m_188501_() < f) {
                tag.m_128379_("Activated", true);
            }
        }
        return false;
    }

    @Override
    public boolean onProjectileTick(ItemStack stack, AbstractCannonProjectile projectile) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Activated")) {
            return false;
        }
        if (!tag.m_128441_("FuzeTimer")) {
            return true;
        }
        int timer = tag.m_128451_("FuzeTimer");
        tag.m_128405_("FuzeTimer", --timer);
        return timer <= 0;
    }

    @Override
    public boolean onProjectileExpiry(ItemStack stack, AbstractCannonProjectile projectile) {
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendImpactFuzeText(stack, level, tooltip, flag, this.getDetonateChance(), this.getFuzeDurability());
        int time = stack.m_41784_().m_128451_("FuzeTimer");
        int seconds = time / 20;
        int ticks = time - seconds * 20;
        tooltip.add((Component)Lang.builder((String)"item").translate("createbigcannons.timed_fuze.tooltip.shell_info.item", new Object[]{seconds, ticks}).component());
    }

    protected float getDetonateChance() {
        return CBCConfigs.SERVER.munitions.impactFuzeDetonationChance.getF();
    }

    protected int getFuzeDurability() {
        return (Integer)CBCConfigs.SERVER.munitions.impactFuzeDurability.get();
    }

    @Override
    public boolean canLingerInGround(ItemStack stack, AbstractCannonProjectile projectile) {
        return stack.m_41784_().m_128441_("Activated");
    }

    @Override
    public void addExtraInfo(List<Component> tooltip, boolean isSneaking, ItemStack stack) {
        super.addExtraInfo(tooltip, isSneaking, stack);
        MutableComponent info = Lang.builder((String)"item").translate("createbigcannons.delayed_impact_fuze.tooltip.shell_info.chance", new Object[]{(int)(this.getDetonateChance() * 100.0f)}).component();
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)info, (Style)Style.f_131099_, (Style)Style.f_131099_, (int)6));
        int time = stack.m_41784_().m_128451_("FuzeTimer");
        int seconds = time / 20;
        int ticks = time - seconds * 20;
        MutableComponent info1 = Lang.builder((String)"item").translate("createbigcannons.timed_fuze.tooltip.shell_info", new Object[]{seconds, ticks}).component();
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)info1, (Style)Style.f_131099_, (Style)Style.f_131099_, (int)6));
    }

    public static ItemStack getCreativeTabItem(int defaultFuze) {
        ItemStack stack = CBCItems.DELAYED_IMPACT_FUZE.asStack();
        stack.m_41784_().m_128405_("FuzeTimer", defaultFuze);
        return stack;
    }
}

