/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CannonMountInstance
extends BlockEntityInstance<CannonMountBlockEntity>
implements DynamicInstance {
    private OrientedData rotatingMount;
    private OrientedData rotatingMountShaft;
    private RotatingData pitchShaft;
    private RotatingData yawShaft;

    public CannonMountInstance(MaterialManager dispatcher, CannonMountBlockEntity tile) {
        super(dispatcher, (BlockEntity)tile);
    }

    public void init() {
        super.init();
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        Direction vertical = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_155997_);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        Material rotatingMaterial = this.materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING);
        Instancer shaftInstance = rotatingMaterial.getModel((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)pitchAxis));
        Instancer halfShaftInstance = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, vertical);
        this.rotatingMount = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.ROTATING_MOUNT, this.blockState).createInstance();
        this.rotatingMount.setPosition(this.getInstancePosition().m_121945_(vertical.m_122424_()));
        this.rotatingMountShaft = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.CANNON_CARRIAGE_AXLE, this.blockState, Direction.NORTH).createInstance();
        this.rotatingMountShaft.setPosition(this.getInstancePosition().m_5484_(vertical, -2));
        this.pitchShaft = (RotatingData)shaftInstance.createInstance();
        this.pitchShaft.setRotationAxis(pitchAxis).setRotationOffset(this.getRotationOffset(pitchAxis)).setColor(((CannonMountBlockEntity)this.blockEntity).getPitchInterface()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.yawShaft = (RotatingData)halfShaftInstance.createInstance();
        this.yawShaft.setRotationAxis(Direction.Axis.Y).setRotationOffset(this.getRotationOffset(Direction.Axis.Y)).setColor(((CannonMountBlockEntity)this.blockEntity).getYawInterface()).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.transformModels();
    }

    public void remove() {
        this.rotatingMount.delete();
        this.rotatingMountShaft.delete();
        this.pitchShaft.delete();
        this.yawShaft.delete();
    }

    private void transformModels() {
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction.Axis pitchAxis = facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        this.updateRotation(this.pitchShaft, pitchAxis, ((CannonMountBlockEntity)this.blockEntity).getPitchSpeed(), true);
        this.updateRotation(this.yawShaft, Direction.Axis.Y, ((CannonMountBlockEntity)this.blockEntity).getYawSpeed(), false);
    }

    protected void updateRotation(RotatingData instance, Direction.Axis axis, float speed, boolean pitch) {
        instance.setRotationAxis(axis).setRotationOffset(this.getRotationOffset(axis)).setRotationalSpeed(speed).setColor(pitch ? ((CannonMountBlockEntity)this.blockEntity).getPitchInterface() : ((CannonMountBlockEntity)this.blockEntity).getYawInterface());
    }

    protected float getRotationOffset(Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog((BlockState)this.blockState) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : this.pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : this.pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : this.pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public void beginFrame() {
        this.transformModels();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        boolean upsideDown = this.blockState.m_61143_((Property)BlockStateProperties.f_155997_) == Direction.UP;
        float yaw = ((CannonMountBlockEntity)this.blockEntity).getYawOffset(partialTicks);
        Quaternionf qyaw = upsideDown ? Axis.f_252403_.m_252977_(180.0f).mul((Quaternionfc)Axis.f_252436_.m_252977_(yaw)) : Axis.f_252436_.m_252977_(-yaw);
        this.rotatingMount.setRotation(qyaw);
        float pitch = ((CannonMountBlockEntity)this.blockEntity).getPitchOffset(partialTicks);
        Quaternionf qpitch = upsideDown ? Axis.f_252529_.m_252977_(pitch) : Axis.f_252529_.m_252977_(-pitch);
        Quaternionf qyaw1 = new Quaternionf((Quaternionfc)qyaw);
        qyaw1.mul((Quaternionfc)qpitch);
        this.rotatingMountShaft.setRotation(qyaw1);
    }

    public void updateLight() {
        super.updateLight();
        Direction vertical = ((Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_155997_)).m_122424_();
        this.relight(this.pos.m_121945_(vertical), new FlatLit[]{this.rotatingMount});
        this.relight(this.pos.m_5484_(vertical, 2), new FlatLit[]{this.rotatingMountShaft});
        this.relight(this.pos, new FlatLit[]{this.pitchShaft});
        this.relight(this.pos, new FlatLit[]{this.yawShaft});
    }
}

