/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.registry;

import com.happysg.radar.CreateRadar;
import com.happysg.radar.block.controller.pitch.PitchLinkBehavior;
import com.happysg.radar.block.controller.yaw.YawLinkBehavior;
import com.happysg.radar.block.monitor.MonitorRadarBehavior;
import com.happysg.radar.block.radar.bearing.RadarBearingLinkBehavior;
import com.happysg.radar.block.radar.link.RadarLinkBehavior;
import com.happysg.radar.block.radar.link.RadarSource;
import com.happysg.radar.block.radar.link.RadarTarget;
import com.happysg.radar.registry.ModBlockEntityTypes;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AllRadarBehaviors {
    public static final Map<ResourceLocation, RadarLinkBehavior> GATHERER_BEHAVIOURS = new HashMap<ResourceLocation, RadarLinkBehavior>();
    private static final AttachedRegistry<Block, RadarSource> SOURCES_BY_BLOCK = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final AttachedRegistry<BlockEntityType<?>, RadarSource> SOURCES_BY_BLOCK_ENTITY = new AttachedRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private static final AttachedRegistry<Block, RadarTarget> TARGETS_BY_BLOCK = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final AttachedRegistry<BlockEntityType<?>, RadarTarget> TARGETS_BY_BLOCK_ENTITY = new AttachedRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);

    public static RadarLinkBehavior register(ResourceLocation id, RadarLinkBehavior behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(RadarLinkBehavior behaviour, ResourceLocation block) {
        if (behaviour instanceof RadarSource) {
            RadarSource source = (RadarSource)behaviour;
            SOURCES_BY_BLOCK.register(block, (Object)source);
        }
        if (behaviour instanceof RadarTarget) {
            RadarTarget target = (RadarTarget)behaviour;
            TARGETS_BY_BLOCK.register(block, (Object)target);
        }
    }

    public static void assignBlockEntity(RadarLinkBehavior behaviour, ResourceLocation beType) {
        if (behaviour instanceof RadarSource) {
            RadarSource source = (RadarSource)behaviour;
            SOURCES_BY_BLOCK_ENTITY.register(beType, (Object)source);
        }
        if (behaviour instanceof RadarTarget) {
            RadarTarget target = (RadarTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register(beType, (Object)target);
        }
    }

    public static void assignBlock(RadarLinkBehavior behaviour, Block block) {
        if (behaviour instanceof RadarSource) {
            RadarSource source = (RadarSource)behaviour;
            SOURCES_BY_BLOCK.register((Object)block, (Object)source);
        }
        if (behaviour instanceof RadarTarget) {
            RadarTarget target = (RadarTarget)behaviour;
            TARGETS_BY_BLOCK.register((Object)block, (Object)target);
        }
    }

    public static void assignBlockEntity(RadarLinkBehavior behaviour, BlockEntityType<?> beType) {
        if (behaviour instanceof RadarSource) {
            RadarSource source = (RadarSource)behaviour;
            SOURCES_BY_BLOCK_ENTITY.register(beType, (Object)source);
        }
        if (behaviour instanceof RadarTarget) {
            RadarTarget target = (RadarTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register(beType, (Object)target);
        }
    }

    public static <B extends Block> NonNullConsumer<? super B> assignDataBehaviour(RadarLinkBehavior behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow((Block)b);
            Object object = idSuffix = behaviour instanceof RadarSource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllRadarBehaviors.assignBlock(AllRadarBehaviors.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    public static <B extends BlockEntityType<?>> NonNullConsumer<? super B> assignDataBehaviourBE(RadarLinkBehavior behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow((BlockEntityType)b);
            Object object = idSuffix = behaviour instanceof RadarSource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllRadarBehaviors.assignBlockEntity(AllRadarBehaviors.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    @Nullable
    public static RadarSource getSource(ResourceLocation resourceLocation) {
        RadarLinkBehavior available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof RadarSource) {
            RadarSource source = (RadarSource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static RadarTarget getTarget(ResourceLocation resourceLocation) {
        RadarLinkBehavior available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof RadarTarget) {
            RadarTarget target = (RadarTarget)available;
            return target;
        }
        return null;
    }

    public static RadarSource sourcesOf(Block block) {
        return (RadarSource)SOURCES_BY_BLOCK.get((Object)block);
    }

    public static RadarSource sourcesOf(BlockState state) {
        return AllRadarBehaviors.sourcesOf(state.m_60734_());
    }

    public static RadarSource sourcesOf(BlockEntityType<?> blockEntityType) {
        return (RadarSource)SOURCES_BY_BLOCK_ENTITY.get(blockEntityType);
    }

    public static RadarSource sourcesOf(BlockEntity blockEntity) {
        return AllRadarBehaviors.sourcesOf(blockEntity.m_58903_());
    }

    @Nullable
    public static RadarTarget targetOf(Block block) {
        return (RadarTarget)TARGETS_BY_BLOCK.get((Object)block);
    }

    @Nullable
    public static RadarTarget targetOf(BlockState state) {
        return AllRadarBehaviors.targetOf(state.m_60734_());
    }

    @Nullable
    public static RadarTarget targetOf(BlockEntityType<?> blockEntityType) {
        return (RadarTarget)TARGETS_BY_BLOCK_ENTITY.get(blockEntityType);
    }

    @Nullable
    public static RadarTarget targetOf(BlockEntity blockEntity) {
        return AllRadarBehaviors.targetOf(blockEntity.m_58903_());
    }

    public static RadarSource sourcesOf(LevelAccessor level, BlockPos pos) {
        RadarSource sourcesOfBlockEntity;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        RadarSource sourcesOfBlock = AllRadarBehaviors.sourcesOf(blockState);
        RadarSource radarSource = sourcesOfBlockEntity = blockEntity == null ? null : AllRadarBehaviors.sourcesOf(blockEntity);
        if (sourcesOfBlockEntity == null) {
            return sourcesOfBlock;
        }
        return sourcesOfBlockEntity;
    }

    @Nullable
    public static RadarTarget targetOf(LevelAccessor level, BlockPos pos) {
        RadarTarget targetOfBlockEntity;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        RadarTarget targetOfBlock = AllRadarBehaviors.targetOf(blockState);
        RadarTarget radarTarget = targetOfBlockEntity = blockEntity == null ? null : AllRadarBehaviors.targetOf(blockEntity);
        if (targetOfBlockEntity == null) {
            return targetOfBlock;
        }
        return targetOfBlockEntity;
    }

    public static void registerDefaults() {
        AllRadarBehaviors.assignBlockEntity(AllRadarBehaviors.register(CreateRadar.asResource("monitor"), new MonitorRadarBehavior()), (BlockEntityType)ModBlockEntityTypes.MONITOR.get());
        AllRadarBehaviors.assignBlockEntity(AllRadarBehaviors.register(CreateRadar.asResource("radar"), new RadarBearingLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.RADAR_BEARING.get());
        AllRadarBehaviors.assignBlockEntity(AllRadarBehaviors.register(CreateRadar.asResource("pitch"), new PitchLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.AUTO_PITCH_CONTROLLER.get());
        AllRadarBehaviors.assignBlockEntity(AllRadarBehaviors.register(CreateRadar.asResource("yaw"), new YawLinkBehavior()), (BlockEntityType)ModBlockEntityTypes.AUTO_YAW_CONTROLLER.get());
    }
}

