/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.link.screens.TargetingConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class GuidedFuzeItem
extends FuzeItem {
    public GuidedFuzeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos clickedPos = pContext.m_8083_();
        BlockEntity blockEntity = pContext.m_43725_().m_7702_(clickedPos);
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity blockEntity2 = (MonitorBlockEntity)blockEntity;
            pContext.m_43722_().m_41784_().m_128365_("monitorPos", (Tag)NbtUtils.m_129224_((BlockPos)blockEntity2.getControllerPos()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    public boolean onProjectileTick(ItemStack stack, AbstractCannonProjectile projectile) {
        CompoundTag tag = stack.m_41784_();
        Vec3 delta = projectile.m_20184_();
        if (tag.m_128441_("monitorPos")) {
            BlockPos monitorPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("monitorPos"));
            if (delta.f_82480_ > 0.0) {
                return false;
            }
            BlockEntity blockEntity = projectile.m_9236_().m_7702_(monitorPos);
            if (blockEntity instanceof MonitorBlockEntity) {
                MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
                Vec3 target = monitor.getTargetPos(TargetingConfig.DEFAULT);
                if (target == null) {
                    return false;
                }
                double horizontalDistance = Math.sqrt(Math.pow(projectile.m_20182_().f_82479_ - target.f_82479_, 2.0) + Math.pow(projectile.m_20182_().f_82481_ - target.f_82481_, 2.0));
                if (!(Math.abs(projectile.m_20182_().f_82480_ - target.f_82480_) > horizontalDistance / 2.0) && !tag.m_128441_("valid")) {
                    return false;
                }
                tag.m_128379_("valid", true);
                Vec3 direction = target.m_82546_(projectile.m_20182_());
                projectile.m_20256_(direction.m_82541_().m_82490_(3.0));
            }
        }
        return super.onProjectileTick(stack, projectile);
    }

    public boolean onProjectileImpact(ItemStack stack, AbstractCannonProjectile projectile, HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, boolean baseFuze) {
        return true;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41784_().m_128441_("monitorPos")) {
            BlockPos monitorPos = NbtUtils.m_129239_((CompoundTag)pStack.m_41784_().m_128469_("monitorPos"));
            pTooltipComponents.add((Component)Component.m_237113_((String)("Linked Monitor:" + String.valueOf(monitorPos))));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"create_radar.guided_fuze.no_monitor"));
        }
    }
}

