/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.link.screens;

import com.happysg.radar.block.radar.link.RadarLinkBlock;
import com.happysg.radar.block.radar.link.RadarLinkBlockEntity;
import com.happysg.radar.block.radar.link.RadarSource;
import com.happysg.radar.block.radar.link.RadarTarget;
import com.happysg.radar.networking.ModMessages;
import com.happysg.radar.networking.packets.RadarLinkConfigurationPacket;
import com.happysg.radar.registry.AllRadarBehaviors;
import com.happysg.radar.registry.ModGuiTextures;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AbstractRadarLinkScreen
extends AbstractSimiScreen {
    private static final ItemStack FALLBACK = new ItemStack((ItemLike)Items.f_42127_);
    protected ModGuiTextures background;
    private final RadarLinkBlockEntity blockEntity;
    private IconButton confirmButton;
    BlockState sourceState;
    BlockState targetState;
    RadarSource source;
    RadarTarget target;

    public AbstractRadarLinkScreen(RadarLinkBlockEntity be) {
        this.blockEntity = be;
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        super.m_7856_();
        this.m_169413_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.initGathererOptions();
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::m_7379_);
        this.m_142416_((GuiEventListener)this.confirmButton);
    }

    private void initGathererOptions() {
        ClientLevel level = this.f_96541_.f_91073_;
        this.sourceState = level.m_8055_(this.blockEntity.getSourcePosition());
        this.targetState = level.m_8055_(this.blockEntity.getTargetPosition());
        int x = this.guiLeft;
        int y = this.guiTop;
        this.source = AllRadarBehaviors.sourcesOf((LevelAccessor)level, this.blockEntity.getSourcePosition());
        this.target = AllRadarBehaviors.targetOf((LevelAccessor)level, this.blockEntity.getTargetPosition());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        MutableComponent header = Component.m_237115_((String)"create_radar.radar_link.title");
        graphics.m_280614_(this.f_96547_, (Component)header, x + this.background.width / 2 - this.f_96547_.m_92852_((FormattedText)header) / 2, y + 4, 0, false);
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_(0.0f, (float)(this.guiTop + 46), 0.0f);
        ms.m_252880_(0.0f, 21.0f, 0.0f);
        ms.m_85849_();
        ms.m_85836_();
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).pushPose()).translate((double)(x + this.background.width + 4), (double)(y + this.background.height + 4), 100.0)).scale(40.0f)).rotateX(-22.0)).rotateY(63.0);
        GuiGameElement.of((BlockState)((BlockState)this.blockEntity.m_58900_().m_61124_((Property)RadarLinkBlock.f_52588_, (Comparable)Direction.UP))).render(graphics);
        ms.m_85849_();
    }

    public void m_7379_() {
        super.m_7379_();
        CompoundTag sourceData = new CompoundTag();
        if (this.source != null) {
            sourceData.m_128359_("Id", this.source.id.toString());
            this.onClose(sourceData);
        }
        ModMessages.sendToServer(new RadarLinkConfigurationPacket(this.blockEntity.m_58899_(), sourceData));
    }

    public void onClose(CompoundTag tag) {
    }
}

