/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.link;

import com.happysg.radar.block.radar.link.RadarLinkBlock;
import com.happysg.radar.block.radar.link.RadarLinkContext;
import com.happysg.radar.block.radar.link.RadarSource;
import com.happysg.radar.block.radar.link.RadarTarget;
import com.happysg.radar.block.radar.link.screens.AbstractRadarLinkScreen;
import com.happysg.radar.registry.AllRadarBehaviors;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RadarLinkBlockEntity
extends SmartBlockEntity {
    protected BlockPos targetOffset = BlockPos.f_121853_;
    public RadarSource activeSource;
    public RadarTarget activeTarget;
    private CompoundTag sourceConfig;
    boolean ledState = false;

    public RadarLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        BlockPos sourcePosition = this.getSourcePosition();
        BlockPos targetPosition = this.getTargetPosition();
        if (!this.f_58857_.m_46749_(targetPosition) || !this.f_58857_.m_46749_(sourcePosition)) {
            return;
        }
        RadarTarget target = AllRadarBehaviors.targetOf((LevelAccessor)this.f_58857_, targetPosition);
        RadarSource source = AllRadarBehaviors.sourcesOf((LevelAccessor)this.f_58857_, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != source) {
            this.activeSource = source;
            this.sourceConfig = new CompoundTag();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            this.ledState = false;
            return;
        }
        this.ledState = true;
        this.activeSource.transferData(new RadarLinkContext(this.f_58857_, this), this.activeTarget);
        this.sendData();
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeGatheredData(tag);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeGatheredData(tag);
        if (clientPacket && this.activeTarget != null) {
            tag.m_128359_("TargetType", this.activeTarget.id.toString());
        }
        tag.m_128379_("LedState", this.ledState);
    }

    private void writeGatheredData(CompoundTag tag) {
        tag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.targetOffset));
        if (this.activeSource != null) {
            CompoundTag data = this.sourceConfig.m_6426_();
            data.m_128359_("Id", this.activeSource.id.toString());
            tag.m_128365_("Source", (Tag)data);
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.targetOffset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("TargetOffset"));
        this.ledState = tag.m_128471_("LedState");
        if (clientPacket && tag.m_128441_("TargetType")) {
            this.activeTarget = AllRadarBehaviors.getTarget(new ResourceLocation(tag.m_128461_("TargetType")));
        }
        if (!tag.m_128441_("Source")) {
            return;
        }
        CompoundTag data = tag.m_128469_("Source");
        this.activeSource = AllRadarBehaviors.getSource(new ResourceLocation(data.m_128461_("Id")));
        this.sourceConfig = new CompoundTag();
        if (this.activeSource != null) {
            this.sourceConfig = data.m_6426_();
        }
    }

    Optional<AbstractRadarLinkScreen> getScreen() {
        return this.activeSource == null ? Optional.empty() : Optional.ofNullable(this.activeSource.getScreen(this));
    }

    public void target(BlockPos targetPosition) {
        this.targetOffset = targetPosition.m_121996_((Vec3i)this.f_58858_);
    }

    public BlockPos getSourcePosition() {
        return this.f_58858_.m_121945_(this.getDirection());
    }

    public CompoundTag getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(CompoundTag sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_((Property)RadarLinkBlock.f_52588_).orElse(Direction.UP).m_122424_();
    }

    public BlockPos getTargetPosition() {
        return this.f_58858_.m_121955_((Vec3i)this.targetOffset);
    }
}

