/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.yaw;

import com.happysg.radar.compat.Mods;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class AutoYawControllerBlockEntity
extends GeneratingKineticBlockEntity {
    private static final double TOLERANCE = 0.1;
    private double targetAngle;
    private boolean isRunning;

    public AutoYawControllerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        if (Mods.CREATEBIGCANNONS.isLoaded()) {
            this.tryRotateCannon();
        }
    }

    private void tryRotateCannon() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isRunning) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (!(blockEntity instanceof CannonMountBlockEntity)) {
            return;
        }
        CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return;
        }
        double currentYaw = contraption.yaw;
        if (currentYaw == this.targetAngle) {
            return;
        }
        currentYaw = (currentYaw + 360.0) % 360.0;
        this.targetAngle = (this.targetAngle + 360.0) % 360.0;
        double yawDifference = this.targetAngle - currentYaw;
        if ((yawDifference = (yawDifference + 180.0) % 360.0 - 180.0) > 180.0) {
            yawDifference -= 360.0;
        } else if (yawDifference < -180.0) {
            yawDifference += 360.0;
        }
        double speedFactor = (double)Math.abs(this.getSpeed()) / 32.0;
        currentYaw = Math.abs(yawDifference) > 0.1 ? (Math.abs(yawDifference) > speedFactor ? (currentYaw += Math.signum(yawDifference) * speedFactor) : this.targetAngle) : this.targetAngle;
        mount.setYaw((float)((currentYaw + 360.0) % 360.0));
        mount.notifyUpdate();
    }

    public void setTargetAngle(float targetAngle) {
        this.targetAngle = targetAngle;
        this.notifyUpdate();
    }

    public double getTargetAngle() {
        return this.targetAngle;
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.targetAngle = compound.m_128459_("TargetAngle");
        this.isRunning = compound.m_128471_("IsRunning");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128347_("TargetAngle", this.targetAngle);
        compound.m_128379_("IsRunning", this.isRunning);
    }

    public void setTarget(Vec3 targetPos) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (targetPos == null) {
            this.isRunning = false;
            return;
        }
        this.isRunning = true;
        Vec3 cannonCenter = this.m_58899_().m_6630_(3).m_252807_();
        double dx = cannonCenter.f_82479_ - targetPos.f_82479_;
        double dz = cannonCenter.f_82481_ - targetPos.f_82481_;
        this.targetAngle = Math.toDegrees(Math.atan2(dz, dx)) + 90.0;
        if (this.targetAngle < 0.0) {
            this.targetAngle += 360.0;
        }
        this.notifyUpdate();
    }

    public boolean atTargetYaw() {
        BlockPos turretPos = this.m_58899_().m_7494_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(turretPos);
        if (!(blockEntity instanceof CannonMountBlockEntity)) {
            return false;
        }
        CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return false;
        }
        return Math.abs((double)contraption.yaw - this.targetAngle) < 0.1;
    }
}

