/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.transmission.sequencer;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.Instruction;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class SequencedGearshiftBlockEntity
extends SplitShaftBlockEntity {
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentInstructionDuration = -1;
    float currentInstructionProgress = 0.0f;
    int timer = 0;
    boolean poweredPreviously = false;
    public AbstractComputerBehaviour computerBehaviour;

    public SequencedGearshiftBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.currentInstructionDuration < 0) {
            return;
        }
        if (this.timer < this.currentInstructionDuration) {
            ++this.timer;
            this.currentInstructionProgress += this.getInstruction(this.currentInstruction).getTickProgress(this.speed);
            return;
        }
        this.run(this.currentInstruction + 1);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.isIdle()) {
            return;
        }
        float currentSpeed = Math.abs(this.speed);
        if (Math.abs(previousSpeed) == currentSpeed) {
            return;
        }
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            this.run(-1);
        }
        this.currentInstructionDuration = instruction.getDuration(this.currentInstructionProgress, this.getTheoreticalSpeed());
        this.timer = 0;
    }

    public boolean isIdle() {
        return this.currentInstruction == -1;
    }

    public void onRedstoneUpdate(boolean isPowered, boolean isRunning) {
        if (this.computerBehaviour.hasAttachedComputer()) {
            return;
        }
        if (!this.poweredPreviously && isPowered) {
            this.risingFlank();
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle()) {
            return;
        }
        if (isPowered == isRunning) {
            return;
        }
        if (!this.f_58857_.m_276867_(this.f_58858_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.run(0);
    }

    public void risingFlank() {
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.poweredPreviously) {
            return;
        }
        this.poweredPreviously = true;
        switch (instruction.onRedstonePulse()) {
            case CONTINUE: {
                this.run(this.currentInstruction + 1);
                break;
            }
        }
    }

    public void run(int instructionIndex) {
        Instruction instruction = this.getInstruction(instructionIndex);
        if (instruction == null || instruction.instruction == SequencerInstructions.END) {
            if (this.getModifier() != 0) {
                this.detachKinetics();
            }
            this.currentInstruction = -1;
            this.currentInstructionDuration = -1;
            this.currentInstructionProgress = 0.0f;
            this.sequenceContext = null;
            this.timer = 0;
            if (!this.f_58857_.m_276867_(this.f_58858_)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                this.sendData();
            }
            return;
        }
        this.detachKinetics();
        this.currentInstructionDuration = instruction.getDuration(0.0f, this.getTheoreticalSpeed());
        this.currentInstruction = instructionIndex;
        this.currentInstructionProgress = 0.0f;
        this.sequenceContext = SequenceContext.fromGearshift(instruction.instruction, this.getTheoreticalSpeed() * (float)this.getModifier(), instruction.value);
        this.timer = 0;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(instructionIndex + 1)), 3);
    }

    public Instruction getInstruction(int instructionIndex) {
        return instructionIndex >= 0 && instructionIndex < this.instructions.size() ? this.instructions.get(instructionIndex) : null;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InstructionIndex", this.currentInstruction);
        compound.m_128405_("InstructionDuration", this.currentInstructionDuration);
        compound.m_128350_("InstructionProgress", this.currentInstructionProgress);
        compound.m_128405_("Timer", this.timer);
        compound.m_128379_("PrevPowered", this.poweredPreviously);
        compound.m_128365_("Instructions", (Tag)Instruction.serializeAll(this.instructions));
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.currentInstruction = compound.m_128451_("InstructionIndex");
        this.currentInstructionDuration = compound.m_128451_("InstructionDuration");
        this.currentInstructionProgress = compound.m_128457_("InstructionProgress");
        this.poweredPreviously = compound.m_128471_("PrevPowered");
        this.timer = compound.m_128451_("Timer");
        this.instructions = Instruction.deserializeAll(compound.m_128437_("Instructions", 10));
        super.read(compound, clientPacket);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.computerBehaviour.removePeripheral();
    }

    @Override
    public float getRotationSpeedModifier(Direction face) {
        if (this.isVirtual()) {
            return 1.0f;
        }
        return !this.hasSource() || face == this.getSourceFacing() ? 1.0f : (float)this.getModifier();
    }

    public int getModifier() {
        if (this.currentInstruction >= this.instructions.size()) {
            return 0;
        }
        return this.isIdle() ? 0 : this.instructions.get(this.currentInstruction).getSpeedModifier();
    }

    public Vector<Instruction> getInstructions() {
        return this.instructions;
    }

    public record SequenceContext(SequencerInstructions instruction, double relativeValue) {
        public static SequenceContext fromGearshift(SequencerInstructions instruction, double kineticSpeed, int absoluteValue) {
            return instruction.needsPropagation() ? new SequenceContext(instruction, kineticSpeed == 0.0 ? 0.0 : (double)absoluteValue / kineticSpeed) : null;
        }

        public double getEffectiveValue(double speedAtTarget) {
            return Math.abs(this.relativeValue * speedAtTarget);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            NBTHelper.writeEnum(nbt, "Mode", this.instruction);
            nbt.m_128347_("Value", this.relativeValue);
            return nbt;
        }

        public static SequenceContext fromNBT(CompoundTag nbt) {
            if (nbt.m_128456_()) {
                return null;
            }
            return new SequenceContext(NBTHelper.readEnum(nbt, "Mode", SequencerInstructions.class), nbt.m_128459_("Value"));
        }
    }
}

