/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMultiStateCopycatBlockEntity
extends ICopycatBlockEntity {
    public MaterialItemStorage getMaterialItemStorage();

    @ApiStatus.OverrideOnly
    public void setMaterialItemStorageInternal(MaterialItemStorage var1);

    @Override
    default public void init() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            Set<String> properties = copycatBlock.storageProperties();
            this.setMaterialItemStorageInternal(MaterialItemStorage.create(properties));
        } else {
            this.setMaterialItemStorageInternal(MaterialItemStorage.create(Set.of("block")));
        }
    }

    @Override
    default public BlockState getMaterial() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).material();
    }

    @Override
    default public ItemStack getConsumedItem() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).consumedItem();
    }

    @Override
    default public boolean isCTEnabled() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).enableCT();
    }

    @Override
    default public void setMaterialInternal(BlockState material) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setMaterial(material);
    }

    @Override
    default public void setConsumedItemInternal(ItemStack consumedItem) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setConsumedItem(consumedItem);
    }

    @Override
    default public void setCTEnabledInternal(boolean value) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setEnableCT(value);
    }

    @Override
    default public IMultiStateCopycatBlock getBlock() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            return copycatBlock;
        }
        return new IMultiStateCopycatBlock(){

            @Override
            public String defaultProperty() {
                return IMultiStateCopycatBlockEntity.this.getMaterialItemStorage().getAllProperties().stream().findFirst().orElse("material");
            }

            @Override
            public Vec3i vectorScale(BlockState state) {
                return new Vec3i(1, 1, 1);
            }

            @Override
            public Set<String> storageProperties() {
                return Set.of(this.defaultProperty());
            }

            @Override
            public int getColorIndex(String property) {
                return 0;
            }

            @Override
            public boolean partExists(BlockState state, String property) {
                return false;
            }

            @Override
            public Vec3i getVectorFromProperty(BlockState state, String property) {
                return new Vec3i(0, 0, 0);
            }

            @Override
            public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
                return this.defaultProperty();
            }

            @Override
            public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
            }

            @Override
            public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos, BlockState toState) {
                return true;
            }

            @Override
            public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
                return false;
            }
        };
    }

    @Override
    default public boolean hasCustomMaterial() {
        return !this.getMaterialItemStorage().getAllMaterials().stream().allMatch(state -> state.m_60713_((Block)AllBlocks.COPYCAT_BASE.get()));
    }

    default public void setMaterial(String property, BlockState blockState) {
        BlockState wrapperState = this.m_58900_();
        BlockState finalMaterial = blockState;
        if (!this.getMaterialItemStorage().getMaterialItem(property).material().m_60713_(finalMaterial.m_60734_())) {
            for (Direction side : Iterate.directions) {
                IMultiStateCopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.m_58899_().m_121945_(side);
                BlockState neighbourState = this.m_58904_().m_8055_(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.m_58904_().m_7702_(neighbour)) instanceof IMultiStateCopycatBlockEntity) || !(otherMaterial = (cbe = (IMultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(property).material()).m_60713_(blockState.m_60734_())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        MaterialItemStorage.MaterialItem materialItem = this.getMaterialItemStorage().getMaterialItem(property);
        materialItem.setMaterial(blockState);
        this.getMaterialItemStorage().storeMaterialItem(property, materialItem);
        BlockEntityUtils.redraw((BlockEntity)this);
    }

    default public boolean cycleMaterial(String property) {
        BlockState material = this.getMaterialItemStorage().getMaterialItem(property).material();
        if (material.m_61138_((Property)TrapDoorBlock.f_57515_) && material.m_61145_((Property)TrapDoorBlock.f_57514_).orElse(false).booleanValue()) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)TrapDoorBlock.f_57515_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61372_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.setMaterial(property, (BlockState)material.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)material.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_()));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61365_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61365_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61364_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61364_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61443_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61443_));
        } else if (material.m_61138_((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    default public void setConsumedItem(String property, ItemStack itemStack) {
        this.getMaterialItemStorage().getMaterialItem(property).setConsumedItem(itemStack);
        this.notifyUpdate();
    }

    default public void setEnableCT(String property, boolean value) {
        this.getMaterialItemStorage().getMaterialItem(property).setEnableCT(value);
        this.notifyUpdate();
    }

    @Override
    default public ItemRequirement getRequiredItems(BlockState state) {
        return new ItemRequirement(this.getMaterialItemStorage().getAllConsumedItems().stream().map(stack -> new ItemRequirement.StackRequirement(stack, ItemRequirement.ItemUseType.CONSUME)).toList());
    }

    @Override
    default public void transform(StructureTransform transform) {
        this.getBlock().transformStorage(this.m_58900_(), this, transform);
        for (String key : this.getMaterialItemStorage().getAllProperties()) {
            this.getMaterialItemStorage().getMaterialItem(key).setMaterial(transform.apply(this.getMaterialItemStorage().getMaterialItem(key).material()));
        }
        this.notifyUpdate();
    }

    public static void read(IMultiStateCopycatBlockEntity self, CompoundTag tag, boolean clientPacket) {
        boolean anyUpdated;
        if (self.m_58900_().m_60734_() instanceof IMultiStateCopycatBlock && (anyUpdated = self.getMaterialItemStorage().deserialize(tag.m_128469_("material_data")))) {
            BlockEntityUtils.redraw((BlockEntity)self);
        }
    }

    public static void writeSafe(IMultiStateCopycatBlockEntity self, CompoundTag tag) {
        BlockEntityUtils.saveMetadata((BlockEntity)self, tag);
        tag.m_128365_("material_data", (Tag)self.getMaterialItemStorage().serializeSafe());
    }

    public static void write(IMultiStateCopycatBlockEntity self, CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("material_data", (Tag)self.getMaterialItemStorage().serialize());
    }
}

