/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.vertical_stairs;

import com.copycatsplus.copycats.CCBlockStateProperties;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.stairs.CopycatStairsBlock;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatVerticalStairBlock
extends CCWaterloggedCopycatBlock
implements ICustomCTBlocking,
IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CCBlockStateProperties.Side> SIDE = CCBlockStateProperties.SIDE;
    public static final EnumProperty<CCBlockStateProperties.VerticalStairShape> SHAPE = CCBlockStateProperties.VERTICAL_STAIR_SHAPE;

    public CopycatVerticalStairBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SIDE, (Comparable)((Object)CCBlockStateProperties.Side.LEFT))).m_61124_(SHAPE, (Comparable)((Object)CCBlockStateProperties.VerticalStairShape.STRAIGHT)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING, SIDE, SHAPE}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        CCBlockStateProperties.Side side;
        BlockPos blockPos = context.m_8083_();
        Direction facing = context.m_8125_();
        CCBlockStateProperties.Side side2 = side = context.m_43720_().m_82507_(facing.m_122427_().m_122434_()) - (double)context.m_8083_().m_123304_(facing.m_122427_().m_122434_()) > 0.5 ? CCBlockStateProperties.Side.RIGHT : CCBlockStateProperties.Side.LEFT;
        if (facing.m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE) {
            side = side.getOpposite();
        }
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(SIDE, (Comparable)((Object)side));
        return this.withWater((BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)CopycatVerticalStairBlock.getStairsShape(blockState, (BlockGetter)context.m_43725_(), blockPos))), context);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        CCBlockStateProperties.Side side = (CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE));
        CCBlockStateProperties.VerticalStairShape shape = (CCBlockStateProperties.VerticalStairShape)((Object)state.m_61143_(SHAPE));
        return CCShapes.VERTICAL_STAIR.get(facing).get((Object)side).get((Object)shape).toShape();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState = super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
        if (direction.m_122434_() != ((Direction)newState.m_61143_((Property)FACING)).m_122434_()) {
            return (BlockState)newState.m_61124_(SHAPE, (Comparable)((Object)CopycatVerticalStairBlock.getStairsShape(newState, (BlockGetter)level, pos)));
        }
        return newState;
    }

    public boolean m_7923_(@NotNull BlockState pState) {
        return true;
    }

    private static CCBlockStateProperties.VerticalStairShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean side = ((CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE))).isRight();
        Direction verticalDirection = null;
        Boolean horizontalConnection = null;
        boolean down = CopycatVerticalStairBlock.canConnect(state, level, pos, Direction.DOWN);
        boolean downParity = CopycatVerticalStairBlock.getVerticalParity(state, level, pos, Direction.DOWN);
        if (down && side == downParity) {
            verticalDirection = Direction.DOWN;
        } else {
            boolean up = CopycatVerticalStairBlock.canConnect(state, level, pos, Direction.UP);
            boolean upParity = CopycatVerticalStairBlock.getVerticalParity(state, level, pos, Direction.UP);
            if (up && side == upParity) {
                verticalDirection = Direction.UP;
            }
        }
        boolean left = CopycatVerticalStairBlock.canConnect(state, level, pos, facing.m_122428_());
        boolean leftParity = CopycatVerticalStairBlock.getHorizontalParity(state, level, pos, facing.m_122428_());
        if (left) {
            horizontalConnection = false;
            if (verticalDirection == null) {
                verticalDirection = leftParity == side ? Direction.DOWN : Direction.UP;
            }
        } else {
            boolean right = CopycatVerticalStairBlock.canConnect(state, level, pos, facing.m_122427_());
            boolean rightParity = CopycatVerticalStairBlock.getHorizontalParity(state, level, pos, facing.m_122427_());
            if (right) {
                horizontalConnection = true;
                if (verticalDirection == null) {
                    Direction direction = verticalDirection = rightParity == side ? Direction.DOWN : Direction.UP;
                }
            }
        }
        if (horizontalConnection == null) {
            return CCBlockStateProperties.VerticalStairShape.STRAIGHT;
        }
        if (!horizontalConnection.booleanValue()) {
            if (verticalDirection == Direction.DOWN) {
                return side ? CCBlockStateProperties.VerticalStairShape.INNER_TOP : CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM;
            }
            return side ? CCBlockStateProperties.VerticalStairShape.INNER_BOTTOM : CCBlockStateProperties.VerticalStairShape.OUTER_TOP;
        }
        if (verticalDirection == Direction.DOWN) {
            return side ? CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM : CCBlockStateProperties.VerticalStairShape.INNER_TOP;
        }
        return side ? CCBlockStateProperties.VerticalStairShape.OUTER_TOP : CCBlockStateProperties.VerticalStairShape.INNER_BOTTOM;
    }

    private static boolean getVerticalParity(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        if (!(blockState.m_60734_() instanceof CopycatVerticalStairBlock)) {
            return false;
        }
        return ((CCBlockStateProperties.Side)((Object)blockState.m_61143_(SIDE))).isRight();
    }

    private static boolean getHorizontalParity(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        if (!CopycatVerticalStairBlock.isStairs(blockState)) {
            return false;
        }
        if (blockState.m_60734_() instanceof CopycatVerticalStairBlock) {
            return ((Direction)state.m_61143_((Property)FACING)).m_122428_() == face == ((CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE))).isRight() == ((CCBlockStateProperties.Side)((Object)blockState.m_61143_(SIDE))).isRight();
        }
        return blockState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
    }

    private static boolean canConnect(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        Direction otherFacing;
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        if (!CopycatVerticalStairBlock.isStairs(blockState)) {
            return false;
        }
        if (face.m_122434_().m_122478_() && !(blockState.m_60734_() instanceof CopycatVerticalStairBlock)) {
            return false;
        }
        Direction selfFacing = (Direction)state.m_61143_((Property)FACING);
        if (selfFacing == (otherFacing = (Direction)blockState.m_61143_((Property)FACING)).m_122424_()) {
            return false;
        }
        if (selfFacing == otherFacing && face.m_122434_() != selfFacing.m_122434_()) {
            return true;
        }
        return selfFacing == otherFacing;
    }

    public static boolean isStairs(BlockState state) {
        return state.m_60734_() instanceof StairBlock || state.m_60734_() instanceof CopycatVerticalStairBlock;
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            Direction.Axis mirrorAxis = null;
            for (Direction.Axis axis : Iterate.axes) {
                if (!transform.mirror.m_54842_().m_56526_(axis)) continue;
                mirrorAxis = axis;
                break;
            }
            if (mirrorAxis != null && !mirrorAxis.m_122478_()) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                state = facing.m_122434_() != mirrorAxis ? (BlockState)state.m_61122_(SIDE) : (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_())).m_61122_(SIDE);
            }
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == Direction.Axis.Y) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)transform.rotateFacing((Direction)state.m_61143_((Property)FACING)));
            } else {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                CCBlockStateProperties.Side side = (CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE));
                if (facing.m_122434_() != transform.rotationAxis) {
                    state = side == CCBlockStateProperties.Side.LEFT ? (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122428_())).m_61122_(SIDE) : (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122427_())).m_61122_(SIDE);
                }
                facing = (Direction)state.m_61143_((Property)FACING);
                side = (CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE));
                if (transform.rotation == Rotation.CLOCKWISE_180) {
                    state = (BlockState)state.m_61122_(SIDE);
                } else if (transform.rotation != Rotation.NONE) {
                    Direction offset = transform.rotateFacing(side.isRight() ? facing.m_122427_() : facing.m_122428_());
                    state = (BlockState)BlockUtils.tryCopyProperties(state, CCBlocks.COPYCAT_STAIRS.getDefaultState()).m_61124_((Property)StairBlock.f_56842_, (Comparable)(offset == Direction.DOWN ? Half.BOTTOM : Half.TOP));
                }
            }
        }
        return state;
    }

    @Override
    public Optional<Boolean> isCTBlocked(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos connectingPos, BlockPos blockingPos, Direction face) {
        if (!CopycatVerticalStairBlock.getFaceShape(state, face).canConnect()) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> blockCTTowards(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos ctPos, BlockPos connectingPos, Direction face) {
        CopycatStairsBlock.FaceShape sideShape = CopycatVerticalStairBlock.getFaceShape(state, face);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!sideShape.canConnect()) {
            return Optional.of(false);
        }
        BlockState connectingState = reader.m_8055_(connectingPos);
        if (connectingState.m_60713_((Block)this)) {
            if (sideShape.equals(CopycatVerticalStairBlock.getFaceShape(connectingState, face.m_122424_()))) {
                return Optional.of(true);
            }
        } else if (sideShape.isFull()) {
            BlockState ctState = reader.m_8055_(ctPos);
            if (ctPos.m_123304_(facing.m_122434_()) == pos.m_123304_(facing.m_122434_()) || !CopycatVerticalStairBlock.isStairs(ctState) || ctState.m_61145_(SIDE).orElse(null) != state.m_61145_(SIDE).orElse(null) || ctState.m_61145_((Property)StairBlock.f_56842_).orElse(null) != state.m_61145_((Property)StairBlock.f_56842_).orElse(null)) {
                return Optional.of(true);
            }
        }
        return Optional.empty();
    }

    private static Direction.AxisDirection directionOf(int value) {
        return value >= 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public static CopycatStairsBlock.FaceShape getFaceShape(BlockState state, Direction face) {
        if (!(state.m_60734_() instanceof CopycatVerticalStairBlock)) {
            return CopycatStairsBlock.getFaceShape(state, face);
        }
        boolean right = ((CCBlockStateProperties.Side)((Object)state.m_61143_(SIDE))).isRight();
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        CCBlockStateProperties.VerticalStairShape shape = (CCBlockStateProperties.VerticalStairShape)((Object)state.m_61143_(SHAPE));
        if (face == facing) {
            return new CopycatStairsBlock.FaceShape().fillAll();
        }
        CopycatStairsBlock.FaceShape faceShape = new CopycatStairsBlock.FaceShape();
        switch (shape) {
            case STRAIGHT: {
                if (face == facing.m_122424_()) {
                    return right ? faceShape.fillRight(facing) : faceShape.fillLeft(facing);
                }
                if (face == facing.m_122428_()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing);
                }
                if (face == facing.m_122427_()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing);
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.m_122435_());
            }
            case INNER_BOTTOM: {
                if (face == facing.m_122424_()) {
                    faceShape.fillBottom();
                    if (right) {
                        faceShape.fillRight(facing);
                    } else {
                        faceShape.fillLeft(facing);
                    }
                    return faceShape;
                }
                if (face == facing.m_122428_()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing).fillBottom();
                }
                if (face == facing.m_122427_()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing).fillBottom();
                }
                if (face == Direction.DOWN) {
                    return faceShape.fillAll();
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.m_122435_());
            }
            case INNER_TOP: {
                if (face == facing.m_122424_()) {
                    faceShape.fillTop();
                    if (right) {
                        faceShape.fillRight(facing);
                    } else {
                        faceShape.fillLeft(facing);
                    }
                    return faceShape;
                }
                if (face == facing.m_122428_()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing).fillTop();
                }
                if (face == facing.m_122427_()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing).fillTop();
                }
                if (face == Direction.UP) {
                    return faceShape.fillAll();
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.m_122435_());
            }
            case OUTER_BOTTOM: {
                if (face == facing.m_122424_()) {
                    return faceShape.fillBottom(right ? facing.m_122428_().m_122421_() : facing.m_122427_().m_122421_());
                }
                if (face == facing.m_122428_()) {
                    return !right ? faceShape.fillLeft(facing).fillBottom() : faceShape.fillLeft(facing);
                }
                if (face == facing.m_122427_()) {
                    return right ? faceShape.fillRight(facing).fillBottom() : faceShape.fillRight(facing);
                }
                if (face == Direction.UP) {
                    return faceShape.fillTop().rotate(facing.m_122435_());
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.m_122435_());
            }
            case OUTER_TOP: {
                if (face == facing.m_122424_()) {
                    return faceShape.fillTop(right ? facing.m_122428_().m_122421_() : facing.m_122427_().m_122421_());
                }
                if (face == facing.m_122428_()) {
                    return !right ? faceShape.fillLeft(facing).fillTop() : faceShape.fillLeft(facing);
                }
                if (face == facing.m_122427_()) {
                    return right ? faceShape.fillRight(facing).fillTop() : faceShape.fillRight(facing);
                }
                if (face == Direction.DOWN) {
                    return faceShape.fillTop().rotate(facing.m_122435_());
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.m_122435_());
            }
        }
        return faceShape;
    }
}

