/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.stacked_half_layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.half_layer.CopycatHalfLayerBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatStackedHalfLayerBlock
extends WaterloggedMultiStateCopycatBlock
implements ISpecialBlockItemRequirement {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public CopycatStackedHalfLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CopycatHalfLayerBlock.POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)CopycatHalfLayerBlock.NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0)));
        this.shapesCache = this.m_152458_(CopycatStackedHalfLayerBlock::calculateMultiFaceShape);
    }

    @Override
    public String defaultProperty() {
        return CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_();
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return new Vec3i(1, 2, 1);
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        if (property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)CopycatHalfLayerBlock.POSITIVE_LAYERS) > 0;
        }
        if (property.equals(CopycatHalfLayerBlock.NEGATIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)CopycatHalfLayerBlock.NEGATIVE_LAYERS) > 0;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_(), CopycatHalfLayerBlock.NEGATIVE_LAYERS.m_61708_());
    }

    @Override
    public int getColorIndex(String property) {
        return property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_()) ? 1 : 0;
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        return (double)hitLocation.m_123342_() > 0.5 ? CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_() : CopycatHalfLayerBlock.NEGATIVE_LAYERS.m_61708_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return new Vec3i(0, property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_()) ? 1 : 0, 0);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), blockPos, context.m_43720_(), context.m_43719_(), false);
            IntegerProperty targetProp = property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_()) ? CopycatHalfLayerBlock.POSITIVE_LAYERS : CopycatHalfLayerBlock.NEGATIVE_LAYERS;
            if ((Integer)state.m_61143_((Property)targetProp) < 8) {
                return (BlockState)state.m_61122_((Property)targetProp);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a half layer! Please file an issue if you see this.");
            return state;
        }
        Direction facing = context.m_43719_().m_122424_();
        if (facing.m_122434_().m_122478_()) {
            facing = context.m_8125_();
        }
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        return (BlockState)((BlockState)stateForPlacement.m_61124_(FACING, (Comparable)facing)).m_61124_((Property)(clickPosition.f_82480_ >= 0.5 ? CopycatHalfLayerBlock.POSITIVE_LAYERS : CopycatHalfLayerBlock.NEGATIVE_LAYERS), (Comparable)Integer.valueOf(1));
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext context) {
        ItemStack itemstack = context.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (context.m_43719_() == state.m_61143_(FACING)) {
            return false;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), false);
        IntegerProperty targetProp = property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_()) ? CopycatHalfLayerBlock.POSITIVE_LAYERS : CopycatHalfLayerBlock.NEGATIVE_LAYERS;
        return (Integer)state.m_61143_((Property)targetProp) != 8;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)CopycatHalfLayerBlock.POSITIVE_LAYERS) + (Integer)state.m_61143_((Property)CopycatHalfLayerBlock.NEGATIVE_LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
        IntegerProperty targetProp = property.equals(CopycatHalfLayerBlock.POSITIVE_LAYERS.m_61708_()) ? CopycatHalfLayerBlock.POSITIVE_LAYERS : CopycatHalfLayerBlock.NEGATIVE_LAYERS;
        if ((Integer)state.m_61143_((Property)targetProp) == 1) {
            this.onWrenched(state, context);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CopycatHalfLayerBlock.POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)CopycatHalfLayerBlock.NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)targetProp, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)targetProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)targetProp) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ICopycatBlock.getRequiredItemsForLayer(state, CopycatHalfLayerBlock.POSITIVE_LAYERS).union(ICopycatBlock.getRequiredItemsForLayer(state, CopycatHalfLayerBlock.NEGATIVE_LAYERS));
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return CopycatHalfLayerBlock.fromTransformableState(state, CopycatHalfLayerBlock.toTransformableState(state).transform(transform));
    }

    @Override
    public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        state = CopycatHalfLayerBlock.fromTransformableState(state, CopycatHalfLayerBlock.toTransformableState(state).untransform(transform));
        CopycatHalfLayerBlock.fromTransformableStorage(state, be, CopycatHalfLayerBlock.toTransformableStorage(state, be).transform(transform));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING, CopycatHalfLayerBlock.POSITIVE_LAYERS, CopycatHalfLayerBlock.NEGATIVE_LAYERS}));
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)CCShapes.STACKED_HALF_LAYER_TOP.get(pState.m_61143_(FACING)).get(pState.m_61143_((Property)CopycatHalfLayerBlock.POSITIVE_LAYERS)).toShape(), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)CCShapes.STACKED_HALF_LAYER_BOTTOM.get(pState.m_61143_(FACING)).get(pState.m_61143_((Property)CopycatHalfLayerBlock.NEGATIVE_LAYERS)).toShape(), (BooleanOp)BooleanOp.f_82695_);
        return shape.m_83296_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }
}

