/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.chunkoptimizer.server;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chunkoptimizer", value={Dist.DEDICATED_SERVER})
public class ChunkPriorityUtil {
    public static int calculateFinalChunkPriority(Vec3 playerPos, Vec3 lookDirection, Vec3 chunkPos, ServerLevel world, int chunkX, int chunkZ) {
        int positionPriority = ChunkPriorityUtil.calculateChunkPriority(playerPos, lookDirection, chunkPos);
        int complexityPriority = ChunkPriorityUtil.calculateChunkComplexity(world, chunkX, chunkZ);
        int finalPriority = positionPriority * 3 + complexityPriority;
        return finalPriority;
    }

    private static int calculateChunkPriority(Vec3 playerPos, Vec3 lookDirection, Vec3 chunkPos) {
        Vec3 toChunk = chunkPos.m_82546_(playerPos).m_82541_();
        double dotProduct = lookDirection.m_82526_(toChunk);
        if (dotProduct >= 0.9) {
            return 3;
        }
        if (dotProduct >= 0.7) {
            return 2;
        }
        return 1;
    }

    private static int calculateChunkComplexity(ServerLevel world, int chunkX, int chunkZ) {
        int averageHeight;
        LevelChunk chunk;
        int complexity = 0;
        String biomeName = world.m_204166_(new BlockPos(chunkX * 16, 0, chunkZ * 16)).toString();
        if (biomeName.contains("Jungle") || biomeName.contains("Forest")) {
            complexity += 2;
        }
        if ((chunk = world.m_6325_(chunkX, chunkZ)) != null) {
            complexity += chunk.m_62954_().size();
        }
        if ((averageHeight = ChunkPriorityUtil.getChunkAverageHeight(world, chunkX, chunkZ)) > 80) {
            ++complexity;
        }
        try {
            if (world.m_7726_().m_62227_(chunkX, chunkZ, false).m_187678_()) {
                complexity += 100;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return complexity;
    }

    private static int getChunkAverageHeight(ServerLevel world, int chunkX, int chunkZ) {
        int totalHeight = 0;
        int blockCount = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = world.m_6924_(Heightmap.Types.WORLD_SURFACE, chunkX * 16 + x, chunkZ * 16 + z);
                totalHeight += height;
                ++blockCount;
            }
        }
        return blockCount == 0 ? 0 : totalHeight / blockCount;
    }
}

