/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.chunkoptimizer.server;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.talesstudio.chunkoptimizer.server.AsyncChunkManager;
import net.talesstudio.chunkoptimizer.server.ChunkPriority;
import net.talesstudio.chunkoptimizer.server.ChunkPriorityUtil;

@Mod.EventBusSubscriber(modid="chunkoptimizer", value={Dist.DEDICATED_SERVER})
public class ChunkOptimizerPreloader {
    private static final int PRELOAD_RADIUS = 3;
    private static final int CHECK_INTERVAL = 20;
    private static final int UNLOAD_DISTANCE = 200;
    private static final int PRIORITY_UPDATE_INTERVAL = 5;
    private static Vec3 lastDirection = new Vec3(0.0, 0.0, 0.0);
    private static final int DIRECTION_BUFFER_SIZE = 5;
    private static final double ANGLE_THRESHOLD = 0.9848;
    private static final LinkedList<Vec3> directionBuffer = new LinkedList();
    private static int tickCounter = 0;
    private static int tickPriorityCounter = 0;
    private static final Map<Long, Vec3> preloadedChunks = new HashMap<Long, Vec3>();
    private static final PriorityQueue<ChunkPriority> chunkPriorityQueue = new PriorityQueue<ChunkPriority>(Comparator.comparingInt(ChunkPriority::priority).reversed());

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.m_9236_() instanceof ServerLevel) {
            Player player = event.player;
            ServerLevel serverWorld = (ServerLevel)player.m_9236_();
            if (++tickCounter % 20 != 0) {
                return;
            }
            tickCounter = 0;
            Vec3 lookDirection = ChunkOptimizerPreloader.getBufferedDirection(player.m_20154_());
            Vec3 playerPosition = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
            int playerChunkX = (int)player.m_20185_() >> 4;
            int playerChunkZ = (int)player.m_20189_() >> 4;
            preloadedChunks.entrySet().removeIf(entry -> {
                Vec3 chunkPos = (Vec3)entry.getValue();
                double distance = chunkPos.m_82554_(playerPosition);
                return distance > 200.0;
            });
            int dynamicRadius = 3 + (int)Math.min(player.m_20184_().m_82553_() * 2.0, 4.0);
            if (++tickPriorityCounter % 5 == 0) {
                ChunkOptimizerPreloader.updateChunkPriorities(playerPosition, lookDirection, serverWorld, playerChunkX, playerChunkZ, dynamicRadius);
                tickPriorityCounter = 0;
            }
            ChunkOptimizerPreloader.preloadChunks(serverWorld);
        }
    }

    private static void updateChunkPriorities(Vec3 playerPos, Vec3 lookDirection, ServerLevel world, int playerChunkX, int playerChunkZ, int dynamicRadius) {
        chunkPriorityQueue.clear();
        for (int dx = -dynamicRadius; dx <= dynamicRadius; ++dx) {
            for (int dz = -dynamicRadius; dz <= dynamicRadius; ++dz) {
                int chunkZ;
                int chunkX = playerChunkX + dx + (int)Math.signum(lookDirection.f_82479_);
                long chunkKey = ChunkOptimizerPreloader.getChunkKey(chunkX, chunkZ = playerChunkZ + dz + (int)Math.signum(lookDirection.f_82481_));
                if (preloadedChunks.containsKey(chunkKey)) continue;
                int priority = ChunkPriorityUtil.calculateFinalChunkPriority(playerPos, lookDirection, new Vec3((double)(chunkX * 16), 0.0, (double)(chunkZ * 16)), world, chunkX, chunkZ);
                chunkPriorityQueue.offer(new ChunkPriority(chunkX, chunkZ, priority));
            }
        }
    }

    private static void preloadChunks(ServerLevel serverWorld) {
        while (!chunkPriorityQueue.isEmpty()) {
            ChunkPriority chunkPriority = chunkPriorityQueue.poll();
            int chunkX = chunkPriority.chunkX();
            int chunkZ = chunkPriority.chunkZ();
            long chunkKey = ChunkOptimizerPreloader.getChunkKey(chunkX, chunkZ);
            AsyncChunkManager.preloadChunkAsync(serverWorld, chunkX, chunkZ);
            preloadedChunks.put(chunkKey, new Vec3((double)(chunkX * 16), 0.0, (double)(chunkZ * 16)));
        }
    }

    private static long getChunkKey(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    private static Vec3 getBufferedDirection(Vec3 currentDirection) {
        currentDirection = currentDirection.m_82541_();
        if (lastDirection.m_82553_() == 0.0) {
            lastDirection = currentDirection;
        }
        if (lastDirection.m_82526_(currentDirection) >= 0.9848) {
            return lastDirection;
        }
        if (directionBuffer.size() >= 5) {
            directionBuffer.poll();
        }
        directionBuffer.add(currentDirection);
        Vec3 averageDirection = directionBuffer.stream().reduce(Vec3.f_82478_, Vec3::m_82549_).m_82490_(1.0 / (double)directionBuffer.size());
        lastDirection = averageDirection.m_82541_();
        return lastDirection;
    }
}

