/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.nukemod3;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.snackpirate.nukemod3.NukeShellBlock;
import com.snackpirate.nukemod3.NukeShellProjectile;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.EntityBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.ModGroup;
import rbasamoyai.createbigcannons.datagen.assets.CBCBuilderTransformers;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.multiloader.EntityTypeConfigurator;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonProjectileRenderer;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.PropertiesTypeHandler;
import rbasamoyai.ritchiesprojectilelib.RPLTags;

@Mod(value="cbc_nukes")
public class CBCNukes {
    public static final String MOD_ID = "cbc_nukes";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"cbc_nukes");
    public static final BlockEntry<NukeShellBlock> NUKE_SHELL;
    public static final EntityEntry<NukeShellProjectile> NUKE_SHELL_PROJECTILE;

    public CBCNukes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::putInCBC);
        modEventBus.addListener(this::dataGen);
        REGISTRATE.registerEventListeners(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void putInCBC(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == ModGroup.MAIN_TAB_KEY) {
            event.m_246326_((ItemLike)NUKE_SHELL.m_5456_());
        }
    }

    @SubscribeEvent
    void dataGen(GatherDataEvent event) {
        if (event.includeClient()) {
            REGISTRATE.addRawLang("block.createnukecannon.nuke_shell.tooltip.summary", "\"Now, I am become _Death_, the destroyer of worlds.\"");
            REGISTRATE.addRawLang("block.createnukecannon.nuke_shell.tooltip.condition1", "On Detonation");
            REGISTRATE.addRawLang("block.createnukecannon.nuke_shell.tooltip.behaviour1", "Unleashes a powerful nuclear blast, devastating the immediate area in an inferno and irradiating the surrounding environment.");
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> shell(MapColor color) {
        return b -> b.addLayer(() -> RenderType::m_110451_).properties(p -> p.m_284180_(color)).properties(p -> p.m_60913_(2.0f, 3.0f)).properties(p -> p.m_60918_(SoundType.f_56742_));
    }

    private static <T extends AbstractBigCannonProjectile> EntityEntry<T> cannonProjectile(String id, EntityType.EntityFactory<T> factory, String enUSdiffLang, PropertiesTypeHandler<EntityType<?>, ?> handler) {
        return ((EntityBuilder)REGISTRATE.entity(id, factory, MobCategory.MISC).properties(CBCNukes.cannonProperties()).renderer(() -> BigCannonProjectileRenderer::new).lang(enUSdiffLang).tag(new TagKey[]{RPLTags.PRECISE_MOTION}).onRegister(type -> MunitionPropertiesHandler.registerProjectileHandler((EntityType)type, (PropertiesTypeHandler)handler))).register();
    }

    private static <T> NonNullConsumer<T> cannonProperties() {
        return CBCNukes.configure(c -> c.size(0.8f, 0.8f).fireImmune().updateInterval(1).updateVelocity(false).trackingRange(16));
    }

    private static <T> NonNullConsumer<T> configure(Consumer<EntityTypeConfigurator> cons) {
        return b -> cons.accept(EntityTypeConfigurator.of((Object)b));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> projectile(String pathAndMaterial, boolean useStandardModel) {
        ResourceLocation baseLoc = CreateBigCannons.resource((String)String.format("block/%sprojectile_block", useStandardModel ? "standard_" : ""));
        ResourceLocation sideLoc = CBCNukes.resource("block/" + pathAndMaterial);
        ResourceLocation topLoc = CBCNukes.resource("block/" + pathAndMaterial + "_top");
        ResourceLocation bottomLoc = CBCNukes.resource("block/" + pathAndMaterial + "_bottom");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110451_).blockstate((c, p) -> {
            BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("particle", topLoc);
            if (!useStandardModel) {
                builder.texture("bottom", bottomLoc);
            }
            p.directionalBlock((Block)c.get(), (ModelFile)builder);
        });
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        NUKE_SHELL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("nuke_shell", NukeShellBlock::new).transform(CBCNukes.shell(MapColor.f_283818_))).transform(TagGen.axeOrPickaxe())).transform(CBCNukes.projectile("projectile/nuke_shell", false))).transform((NonNullFunction)CBCBuilderTransformers.safeNbt())).properties(p -> p.m_60918_(ACSoundTypes.NUCLEAR_BOMB)).loot(CBCBuilderTransformers.shellLoot()).onRegisterAfter(Registries.f_256913_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.createnukecannon.nuke_shell"))).lang("Nuclear Shell").item().tag(new TagKey[]{CBCTags.CBCItemTags.BIG_CANNON_PROJECTILES}).build()).register();
        NUKE_SHELL_PROJECTILE = CBCNukes.cannonProjectile("nuke_shell", NukeShellProjectile::new, "Nuclear Shell", CBCMunitionPropertiesHandlers.COMMON_SHELL_BIG_CANNON_PROJECTILE);
    }

    @Mod.EventBusSubscriber(modid="cbc_nukes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

