/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class PropertyUtil {
    public static Item.Properties stacksOnce() {
        return new Item.Properties().m_41487_(1);
    }

    public static Item.Properties food(FoodProperties food) {
        return new Item.Properties().m_41489_(food);
    }

    public static BlockBehaviour.Properties flower() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties sapling() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties ladder() {
        return BlockBehaviour.Properties.m_284310_().m_280574_().m_60978_(0.4f).m_60918_(SoundType.f_56748_).m_60955_().m_278166_(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties flowerPot(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties blockbehaviour$properties = BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            blockbehaviour$properties = blockbehaviour$properties.m_246843_(featureFlags);
        }
        return blockbehaviour$properties;
    }

    public static BlockBehaviour.Properties thatch(MapColor color, SoundType soundType) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60978_(0.5f).m_60918_(soundType).m_60955_();
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    public static boolean always(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public static boolean always(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entity) {
        return true;
    }

    public static boolean ocelotOrParrot(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.f_20505_ || entity == EntityType.f_20508_;
    }

    public record WoodSetProperties(MapColor woodColor, MapColor barkColor, MapColor leavesColor, Consumer<BlockBehaviour.Properties> basePropertiesConsumer, SoundType sound, SoundType logSound, SoundType leavesSound, SoundType chiseledBookshelfSound, NoteBlockInstrument instrument) {
        public static Builder builder(MapColor woodColor, MapColor barkColor) {
            return new Builder(woodColor, barkColor);
        }

        public static Builder builder(MapColor woodColor) {
            return new Builder(woodColor, woodColor);
        }

        public BlockBehaviour.Properties planks() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60913_(2.0f, 3.0f).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties log() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284495_(state -> state.m_61138_((Property)BlockStateProperties.f_61365_) && state.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y ? this.barkColor : this.woodColor).m_280658_(this.instrument).m_60978_(2.0f).m_60918_(this.logSound);
        }

        public BlockBehaviour.Properties leaves() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(this.leavesColor).m_60978_(0.2f).m_60977_().m_60918_(this.leavesSound).m_60955_().m_60922_(PropertyUtil::ocelotOrParrot).m_60960_(PropertyUtil::never).m_60971_(PropertyUtil::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(PropertyUtil::never);
        }

        public BlockBehaviour.Properties pressurePlate() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280606_().m_280658_(this.instrument).m_60910_().m_60978_(0.5f).m_60918_(this.sound).m_278166_(PushReaction.DESTROY);
        }

        public BlockBehaviour.Properties trapdoor() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(3.0f).m_60955_().m_60922_(PropertyUtil::never).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties button() {
            return BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties door() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(3.0f).m_60955_().m_60918_(this.sound).m_278166_(PushReaction.DESTROY);
        }

        public BlockBehaviour.Properties beehive() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(0.6f).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties bookshelf() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(1.5f).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties chiseledBookshelf() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(1.5f).m_60918_(this.chiseledBookshelfSound);
        }

        public BlockBehaviour.Properties ladder() {
            return PropertyUtil.ladder();
        }

        public BlockBehaviour.Properties sapling() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(this.leavesColor).m_60910_().m_60977_().m_60966_().m_60918_(this.leavesSound).m_278166_(PushReaction.DESTROY);
        }

        public BlockBehaviour.Properties chest() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60978_(2.5f).m_60918_(this.sound);
        }

        public BlockBehaviour.Properties sign() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return BlockBehaviour.Properties.m_284310_().m_284180_(this.woodColor).m_280606_().m_280658_(this.instrument).m_60910_().m_60978_(1.0f);
        }

        public BlockBehaviour.Properties hangingSign() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280606_().m_280658_(this.instrument).m_60910_().m_60978_(1.0f);
        }

        public BlockBehaviour.Properties leafPile() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(this.leavesColor).m_280170_().m_60910_().m_60978_(0.2f).m_60918_(this.leavesSound).m_278183_().m_278166_(PushReaction.DESTROY);
        }

        @Deprecated
        public BlockBehaviour.Properties leafCarpet() {
            return BlockBehaviour.Properties.m_284310_().m_284180_(this.leavesColor).m_60910_().m_60978_(0.0f).m_60918_(this.leavesSound).m_60955_().m_278183_();
        }

        @Deprecated
        public BlockBehaviour.Properties post() {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
            this.basePropertiesConsumer.accept(properties);
            return properties.m_284180_(this.woodColor).m_280658_(this.instrument).m_60913_(2.0f, 3.0f).m_60918_(this.logSound);
        }

        public static final class Builder {
            private final MapColor woodColor;
            private final MapColor barkColor;
            private MapColor leavesColor = MapColor.f_283915_;
            private Consumer<BlockBehaviour.Properties> basePropertiesConsumer = BlockBehaviour.Properties::m_278183_;
            private SoundType sound = SoundType.f_56736_;
            private SoundType logSound = SoundType.f_56736_;
            private SoundType leavesSound = SoundType.f_56740_;
            private SoundType chiseledBookshelfSound = SoundType.f_256956_;
            private NoteBlockInstrument instrument = NoteBlockInstrument.BASS;

            private Builder(MapColor woodColor, MapColor barkColor) {
                this.woodColor = woodColor;
                this.barkColor = barkColor;
            }

            public Builder basePropertiesConsumer(Consumer<BlockBehaviour.Properties> basePropertiesConsumer) {
                this.basePropertiesConsumer = basePropertiesConsumer;
                return this;
            }

            public Builder fireproof() {
                this.basePropertiesConsumer = block -> BlockBehaviour.Properties.m_284310_();
                return this;
            }

            public Builder leavesColor(MapColor color) {
                this.leavesColor = color;
                return this;
            }

            public Builder sound(SoundType soundType) {
                this.sound = soundType;
                return this;
            }

            public Builder logSound(SoundType soundType) {
                this.logSound = soundType;
                return this;
            }

            public Builder leavesSound(SoundType soundType) {
                this.leavesSound = soundType;
                return this;
            }

            public Builder chiseledBookshelfSound(SoundType soundType) {
                this.chiseledBookshelfSound = soundType;
                return this;
            }

            public Builder instrument(NoteBlockInstrument instrument) {
                this.instrument = instrument;
                return this;
            }

            public WoodSetProperties build() {
                return new WoodSetProperties(this.barkColor, this.woodColor, this.leavesColor, this.basePropertiesConsumer, this.sound, this.logSound, this.leavesSound, this.chiseledBookshelfSound, this.instrument);
            }
        }
    }
}

